import { useEffect, useState } from 'react';

interface Alert {
  type: string;
  description: string;
  severity: string;
  action: string;
  user_id?: string;
  ip_address?: string;
}

export const useRealtimeAlerts = () => {
  const [alerts, setAlerts] = useState<Alert[]>([]);
  const [connected, setConnected] = useState(false);

  useEffect(() => {
    const ws = new WebSocket(`ws://localhost:8000/api/audit-logs/ws/alerts`);
    
    ws.onopen = () => {
      setConnected(true);
      console.log('🔌 Connected to real-time alerts');
    };
    
    ws.onmessage = (event) => {
      const data = JSON.parse(event.data);
      if (data.type === 'security_alert') {
        setAlerts(prev => [data.alert, ...prev].slice(0, 50));
      }
    };
    
    ws.onerror = () => setConnected(false);
    ws.onclose = () => setConnected(false);
    
    return () => ws.close();
  }, []);

  return { alerts, connected };
};
