import { createRoot } from "react-dom/client";
import App from "./App";
import "./index.css";
import 'leaflet/dist/leaflet.css';
import { setupErrorHandling } from "./utils/debugHelper";
import './utils/behaviorTracker';

// Setup global error handling
setupErrorHandling();

// Safe root element access
const rootElement = document.getElementById("root");
if (!rootElement) {
  console.error('Root element not found!');
  throw new Error('Root element not found');
}

try {
  createRoot(rootElement).render(<App />);
  console.log('✅ App rendered successfully');
} catch (error) {
  console.error('❌ Failed to render app:', error);
}