import React from 'react';
import { useAuth } from '../hooks/useAuth'; // Adjust import path as needed
import AdminDataRetention from '../components/data-retention/AdminDataRetention';

const AdminDataRetentionPage: React.FC = () => {
  const { user } = useAuth(); // Assuming you have auth context
  
  // Check if user is admin (adjust this logic based on your auth system)
  const isAdmin = user?.role === 'admin' || user?.is_admin || false;
  
  return <AdminDataRetention isAdmin={isAdmin} />;
};

export default AdminDataRetentionPage;