import React from 'react';
import { ArrowLeft } from 'lucide-react';
import { useNavigate } from 'react-router-dom';
import { AgentKYCForm } from '../components/agent-kyc';

const AgentKYCPage: React.FC = () => {
  const navigate = useNavigate();

  return (
    <div className="min-h-screen bg-gray-50">
      <div className="bg-white border-b border-gray-200 sticky top-0 z-40">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex items-center h-16">
            <button onClick={() => navigate(-1)} className="p-2 hover:bg-gray-100 rounded-full transition-colors mr-4">
              <ArrowLeft className="w-5 h-5 text-gray-600" />
            </button>
            <div>
              <h1 className="text-xl font-semibold text-gray-900">Agent KYC Verification</h1>
              <p className="text-sm text-gray-500">Complete verification to list properties and manage clients</p>
            </div>
          </div>
        </div>
      </div>

      <div className="py-8">
        <AgentKYCForm />
      </div>
    </div>
  );
};

export default AgentKYCPage;
