import React from 'react';
import { CheckCircle, Phone, Mail, Target } from 'lucide-react';
import { Button } from '../components/ui/button';

export function AssetManagementPage() {
  const solution = {
    title: 'Asset Management',
    description: 'Complete property lifecycle management including rent collection, inspections, repairs, maintenance coordination, and comprehensive owner reports.',
    features: [
      { title: 'UPI/NEFT Rent Collection', description: 'Digital rent collection with GST invoicing and TDS compliance.' },
      { title: 'Pan-India Vendor Network', description: 'Trusted vendors across 100+ Indian cities with quality assurance.' },
      { title: 'RERA Compliance Reporting', description: 'Monthly reports compliant with state RERA regulations.' },
      { title: 'Aadhaar-based Tenant Verification', description: 'Police verification and CIBIL score checks for tenant screening.' }
    ],
    benefits: [
      'NRI-friendly management with FEMA compliance and foreign remittance support',
      'Income Tax Act Section 24 optimization with professional tax filing assistance',
      'State rent control act compliance across all 28 Indian states',
      'Integration with Indian banking system for seamless fund transfers'
    ],
    useCases: [
      'NRI property portfolios across India',
      'Indian REIT and InvIT management',
      'Corporate housing for IT companies',
      'Student accommodation near IITs/IIMs',
      'Senior living communities',
      'Co-working spaces in metro cities',
      'Warehouse and logistics properties',
      'Retail and commercial complexes'
    ],
    pricing: 'Custom pricing based on portfolio size'
  };

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <div className="text-white py-16" style={{backgroundColor: '#1e40af'}}>
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <h1 className="text-4xl md:text-5xl font-bold mb-6">{solution.title}</h1>
            <p className="text-xl md:text-2xl text-green-100 max-w-3xl mx-auto">{solution.description}</p>
            <div className="mt-8">
              <span className="inline-block bg-white/20 text-white px-6 py-3 rounded-full text-lg font-semibold">
                {solution.pricing}
              </span>
            </div>
          </div>
        </div>
      </div>

      {/* Solutions Images Section */}
      <div className="bg-white py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="text-center">
              <img 
                src="/solutions/porfolio management.jpg"
                alt="Asset Management" 
                className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
              />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Portfolio Management</h3>
              <p className="text-gray-600">Professional property management</p>
            </div>
            
            <div className="text-center">
              <img 
                src="/solutions/property management.jpg"
                alt="Smart Technology" 
                className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
              />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Property Care</h3>
              <p className="text-gray-600">Professional property maintenance</p>
            </div>
            
            <div className="text-center">
              <img 
                src="/solutions/peace of mind.jpg"
                alt="Professional Services" 
                className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
              />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Peace of Mind</h3>
              <p className="text-gray-600">Complete peace of mind for owners</p>
            </div>
          </div>
        </div>
      </div>

      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-12">
          {/* Features */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Features</h2>
            <ul className="space-y-4">
              {solution.features.map((feature, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                  <div className="text-gray-700">
                    <div className="font-semibold text-gray-900 mb-1">{feature.title}</div>
                    <div className="text-gray-600 text-sm">{feature.description}</div>
                  </div>
                </li>
              ))}
            </ul>
          </div>

          {/* Benefits */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Benefits</h2>
            <ul className="space-y-4">
              {solution.benefits.map((benefit, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{benefit}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Use Cases */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Use Cases</h2>
            <ul className="space-y-4">
              {solution.useCases.map((useCase, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{useCase}</span>
                </li>
              ))}
            </ul>
          </div>
        </div>

        {/* CTA Section */}
        <div className="mt-16 bg-white rounded-lg p-8 shadow-sm border border-gray-200 text-center">
          <h2 className="text-3xl font-bold text-gray-900 mb-4">Ready to Transform Your Business?</h2>
          <p className="text-gray-600 mb-8 max-w-2xl mx-auto">
            Discover how asset management can revolutionize your real estate operations and drive growth.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button className="bg-[#16a34a] hover:bg-[#15803d] text-white px-8 py-3">
              <Phone className="w-4 h-4 mr-2" />
+91-8068447416
            </Button>
            <Button 
              variant="outline" 
              className="border-[#16a34a] text-[#16a34a] hover:bg-[#16a34a] hover:text-white px-8 py-3"
              onClick={() => alert(`Request Quote for ${solution.title}\n\nSolution: ${solution.title}\nPricing: ${solution.pricing}\n\nContact us at +91-8068447416 for a detailed quote.`)}
            >
              <Mail className="w-4 h-4 mr-2" />
              Request Quote
            </Button>
          </div>
        </div>
      </div>
    </div>
  );
}