import React from 'react';
import { useNavigate } from 'react-router-dom';
import { Button } from '../components/ui/button';
import { CheckCircle, Shield, Clock, FileText, Users, Award } from 'lucide-react';

export function DocumentVerificationPage() {
  const navigate = useNavigate();

  const features = [
    "AI-powered document analysis",
    "Government database verification",
    "Legal compliance checking",
    "Fraud detection algorithms",
    "Real-time status updates",
    "Professional verification reports"
  ];

  const benefits = [
    "Prevent property fraud",
    "Ensure legal compliance",
    "Save time and money",
    "Professional verification",
    "Peace of mind",
    "Instant digital reports"
  ];

  const process = [
    "Upload Documents",
    "AI Analysis",
    "Database Verification", 
    "Legal Review",
    "Generate Report"
  ];

  return (
    <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <div className="bg-gradient-to-br from-blue-50 to-indigo-100 py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <h1 className="text-4xl md:text-6xl font-bold text-gray-900 mb-6">
              Document Verification
            </h1>
            <p className="text-xl text-gray-600 mb-8 max-w-3xl mx-auto">
              Comprehensive AI-powered property document verification to ensure legal compliance and prevent fraud
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button 
                onClick={() => navigate('/docverification')}
                className="bg-[#0056D2] hover:bg-[#0041A3] text-white px-8 py-3 text-lg"
              >
                Start Verification
              </Button>
              <Button 
                variant="outline" 
                className="border-[#0056D2] text-[#0056D2] hover:bg-[#0056D2] hover:text-white px-8 py-3 text-lg"
              >
                Learn More
              </Button>
            </div>
          </div>
        </div>
      </div>

      {/* Key Features Section */}
      <div className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Advanced Verification Technology</h2>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Our AI-powered system analyzes property documents with precision, cross-references government databases, and provides comprehensive verification reports
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="text-center p-6 rounded-lg border border-gray-200 hover:shadow-lg transition-shadow">
              <Shield className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-xl font-semibold text-gray-900 mb-2">AI-Powered Analysis</h3>
              <p className="text-gray-600">Advanced algorithms detect document authenticity and identify potential fraud indicators</p>
            </div>
            
            <div className="text-center p-6 rounded-lg border border-gray-200 hover:shadow-lg transition-shadow">
              <FileText className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-xl font-semibold text-gray-900 mb-2">Database Verification</h3>
              <p className="text-gray-600">Cross-reference with government databases for accurate document validation</p>
            </div>
            
            <div className="text-center p-6 rounded-lg border border-gray-200 hover:shadow-lg transition-shadow">
              <Award className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-xl font-semibold text-gray-900 mb-2">Professional Reports</h3>
              <p className="text-gray-600">Detailed verification reports with legal recommendations and compliance status</p>
            </div>
          </div>
        </div>
      </div>

      {/* Main Content */}
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-12">
          {/* Features */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Key Features</h2>
            <ul className="space-y-4">
              {features.map((feature, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{feature}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Benefits */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Benefits</h2>
            <ul className="space-y-4">
              {benefits.map((benefit, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{benefit}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Process */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">How It Works</h2>
            <ol className="space-y-4">
              {process.map((step, index) => (
                <li key={index} className="flex items-start gap-3">
                  <div className="w-6 h-6 bg-[#0056D2] text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">
                    {index + 1}
                  </div>
                  <span className="text-gray-700">{step}</span>
                </li>
              ))}
            </ol>
          </div>
        </div>
      </div>

      {/* CTA Section */}
      <div className="bg-gradient-to-br from-blue-50 to-indigo-50 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl font-bold text-gray-900 mb-4">Ready to Verify Your Documents?</h2>
          <p className="text-gray-600 mb-8 max-w-2xl mx-auto">
            Get professional document verification with our AI-powered system. Ensure your property documents are legally compliant and fraud-free.
          </p>
          <Button 
            onClick={() => navigate('/docverification')}
            className="bg-[#0056D2] hover:bg-[#0041A3] text-white px-8 py-3 text-lg"
          >
            Start Document Verification
          </Button>
        </div>
      </div>
    </div>
  );
}