import React, { useEffect } from 'react';
import { ArrowLeft } from 'lucide-react';
import { Button } from '@/components/ui/button';

const DocumentViewer: React.FC = () => {
  const handleBack = () => {
    const previousLocation = sessionStorage.getItem('previousLocation');
    if (previousLocation) {
      window.location.href = previousLocation;
    } else {
      window.history.back();
    }
  };

  return (
    <div className="min-h-screen bg-gray-50">
      <div className="bg-white shadow-sm border-b">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex items-center justify-between h-16">
            <Button
              onClick={handleBack}
              variant="outline"
              className="flex items-center gap-2"
            >
              <ArrowLeft className="w-4 h-4" />
              Back to Admin Dashboard
            </Button>
            <h1 className="text-lg font-semibold text-gray-900">Document Viewer</h1>
            <div></div>
          </div>
        </div>
      </div>
      
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
        <div className="bg-white rounded-lg shadow-sm border p-4">
          <p className="text-gray-600 text-center">
            Document will load here. If you see this page, the document viewer is working.
          </p>
        </div>
      </div>
    </div>
  );
};

export default DocumentViewer;