import React from 'react';
import { Shield, User, Home, CreditCard, CheckCircle, Phone, Lock, Settings, AlertTriangle, Mail } from 'lucide-react';

export function HelpCenter() {
  const sections = [
    {
      id: "account",
      title: "Account & Login",
      icon: <User className="w-5 h-5" />,
      faqs: [
        {
          question: "How do I create an account?",
          answer: "You can sign up using your mobile number, email ID, or Google account. Verify your contact details to start listing or browsing properties."
        },
        {
          question: "I forgot my password. How can I reset it?",
          answer: "Click 'Forgot Password' on the login page → enter your registered email or mobile number → follow the reset link sent to you."
        },
        {
          question: "Can I change my registered mobile number or email?",
          answer: "Yes. Go to Profile → Edit Details → Update Contact Info. Verify new contact details via OTP."
        }
      ]
    },
    {
      id: "listings",
      title: "Property Listings",
      icon: <Home className="w-5 h-5" />,
      faqs: [
        {
          question: "How do I post a property?",
          answer: "Go to 'Post Property' → choose Sell / Rent → fill in property details (type, location, price, photos) → submit. Your listing goes live after verification."
        },
        {
          question: "How long will my property remain active?",
          answer: "Free listings stay active for 30 days. Premium listings have extended validity based on your subscription plan."
        },
        {
          question: "How can I edit or remove my listing?",
          answer: "Go to My Listings → Edit / Delete to update details or deactivate the listing anytime."
        }
      ]
    },
    {
      id: "payments",
      title: "Payments & Subscriptions",
      icon: <CreditCard className="w-5 h-5" />,
      faqs: [
        {
          question: "What are premium listings?",
          answer: "Premium listings increase visibility and attract more leads. They appear on top search results and include verified badges."
        },
        {
          question: "What payment methods are supported?",
          answer: "We accept UPI, Credit/Debit Cards, Net Banking, and Wallets through secure payment gateways."
        },
        {
          question: "Are payments refundable?",
          answer: "Payments are non-refundable, except in cases of duplicate transactions or technical errors."
        }
      ]
    },
    {
      id: "verification",
      title: "Verification & Safety",
      icon: <CheckCircle className="w-5 h-5" />,
      faqs: [
        {
          question: "Is property verification mandatory?",
          answer: "Certain listings may require document verification or site validation to ensure authenticity."
        },
        {
          question: "How do I identify verified listings?",
          answer: "Verified listings are marked with a ✓ Verified badge on the property page."
        },
        {
          question: "How can I avoid fraud?",
          answer: "Do not share OTPs or confidential information. Visit the property before making payments. Report suspicious listings to newagelandindia@gmail.com."
        }
      ]
    },
    {
      id: "contact",
      title: "Contacting Owners, Agents & Builders",
      icon: <Phone className="w-5 h-5" />,
      faqs: [
        {
          question: "How can I contact a property owner or builder?",
          answer: "Click the 'Contact Owner/Agent' button on the listing page. You can call or message them directly."
        },
        {
          question: "Is there any charge for contacting owners?",
          answer: "Basic access is free. Premium users may get additional contact views or early access to new listings."
        }
      ]
    },
    {
      id: "privacy",
      title: "Privacy & Data",
      icon: <Lock className="w-5 h-5" />,
      faqs: [
        {
          question: "How is my personal data protected?",
          answer: "Your data is secured in compliance with the Information Technology Act, 2000 and Privacy Rules, 2011. Read our full Privacy Policy for details."
        },
        {
          question: "Can I delete my account?",
          answer: "Yes. Write to newagelandindia@gmail.com requesting account deletion. Data will be removed within 30 days as per our retention policy."
        }
      ]
    },
    {
      id: "technical",
      title: "Technical Support",
      icon: <Settings className="w-5 h-5" />,
      faqs: [
        {
          question: "The website/app isn't loading properly. What should I do?",
          answer: "Try clearing your browser cache, updating your app, or using a different device/network."
        },
        {
          question: "I'm not receiving OTPs or emails.",
          answer: "Check spam/junk folders or ensure your mobile number/email is active. If the issue persists, contact support."
        }
      ]
    }
  ];

  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 pt-20">
      {/* Header */}
      <div
        className="bg-gradient-to-r from-blue-500 to-blue-700"
        style={{
          background: "linear-gradient(90deg, #3B82F6 0%, #1D4ED8 100%)",
        }}
      >
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
          <div className="text-center">
            <h1
              className="text-4xl md:text-5xl font-bold mb-4"
              style={{ color: "#FFFFFF" }}
            >
              Help Center
            </h1>
            <p
              className="text-xl max-w-3xl mx-auto"
              style={{ color: "#FFFFFF" }}
            >
              We're here to assist you with property listings, account
              management, payments, and general support. Find answers to
              frequently asked questions or get in touch with our support team.
            </p>
          </div>
        </div>
      </div>

      <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        {/* FAQ Sections */}
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-16">
          {sections.map((section, index) => (
            <div
              key={section.id}
              className="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden hover:shadow-2xl transition-all duration-300"
            >
              <div className="p-8">
                <div className="flex items-center space-x-4 mb-6">
                  <div className="flex-shrink-0 p-3 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl text-white">
                    {section.icon}
                  </div>
                  <h2 className="text-2xl font-bold text-gray-900">
                    {section.title}
                  </h2>
                </div>

                <div className="space-y-6">
                  {section.faqs.map((faq, idx) => (
                    <div key={idx}>
                      <h3 className="font-bold text-gray-900 mb-2 text-lg">
                        Q: {faq.question}
                      </h3>
                      <p className="text-gray-700 leading-relaxed">
                        {faq.answer}
                      </p>
                    </div>
                  ))}
                </div>
              </div>
            </div>
          ))}
        </div>

        {/* Report Issue Section */}
        <div className="bg-gradient-to-r from-red-50 to-red-100 border-2 border-red-200 rounded-2xl p-8 mb-8">
          <div className="flex items-start space-x-4">
            <div className="w-12 h-12 bg-gradient-to-br from-red-500 to-red-600 rounded-xl flex items-center justify-center flex-shrink-0">
              <AlertTriangle className="w-6 h-6 text-white" />
            </div>
            <div>
              <h3 className="text-2xl font-bold text-red-900 mb-4">
                Report an Issue
              </h3>
              <p className="text-red-800 mb-4">
                If you face any problem or suspect fraud, please report it
                immediately:
              </p>
              <div className="space-y-2 text-red-800">
                <div className="flex items-center space-x-2">
                  <Mail className="w-4 h-4" />
                  <span>Email:info@newagelandindia.com</span>
                </div>
                <div className="flex items-center space-x-2">
                  <Phone className="w-4 h-4" />
                  <span>Helpline: +91-8068447416</span>
                </div>
                <p>
                  Office Address: NAL India Pvt Ltd. #28, Third Floor, MCHS
                  Layout KV Jayaram Road, Jakkur, Bengaluru, India
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}