import React from 'react';
import { CheckCircle, Phone, Mail, Target } from 'lucide-react';
import { Button } from '../components/ui/button';

export function InvestorsPage() {
  const solution = {
    title: 'Investor Tools',
    description: 'Dedicated investment insights for serious buyers, connecting with verified investors and providing comprehensive investment opportunities in the real estate market.',
    features: [
      'Network of HNI and UHNI investors across Mumbai, Delhi, and Bangalore',
      'NRI investor connections from USA, UK, Canada, and Gulf countries',
      'Integration with Indian family offices and wealth management firms',
      'SEBI-compliant investment structures and documentation support',
      'Due diligence support with CA and legal expert network across India'
    ],
    benefits: [
      'Access to Indian institutional investors including pension funds and insurance companies',
      'FEMA-compliant investment structures for NRI and foreign investors',
      'Tax-efficient investment planning under Indian Income Tax Act',
      'Integration with Indian REIT and InvIT investment opportunities',
      'Compliance with RBI guidelines for foreign investment in real estate'
    ],
    useCases: [
      'Luxury residential projects in South Mumbai and South Delhi markets',
      'Commercial office developments in IT hubs like Gurgaon and Whitefield',
      'Warehouse and logistics projects along major Indian highways',
      'Student housing projects near IITs, IIMs, and major universities',
      'Senior living and healthcare real estate projects in metro cities'
    ],
    pricing: 'Success-based fees'
  };

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <div className="text-white py-16" style={{backgroundColor: '#1e40af'}}>
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <h1 className="text-4xl md:text-5xl font-bold mb-6">{solution.title}</h1>
            <p className="text-xl md:text-2xl text-red-100 max-w-3xl mx-auto">{solution.description}</p>
            <div className="mt-8">
              <span className="inline-block bg-white/20 text-white px-6 py-3 rounded-full text-lg font-semibold">
                {solution.pricing}
              </span>
            </div>
          </div>
        </div>
      </div>

      {/* Solutions Images Section */}
      <div className="bg-white py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="text-center">
              <img 
                src="/solutions/investment network.jpg"
                alt="Investment Network" 
                className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
              />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Investment Network</h3>
              <p className="text-gray-600">Verified investor connections</p>
            </div>
            
            <div className="text-center">
              <img 
                src="/solutions/Deal Facilitation.jpg"
                alt="Smart Technology" 
                className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
              />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Deal Facilitation</h3>
              <p className="text-gray-600">Professional deal structuring</p>
            </div>
            
            <div className="text-center">
              <img 
                src="/solutions/risk management.jpg"
                alt="Professional Services" 
                className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
              />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Risk Management</h3>
              <p className="text-gray-600">Comprehensive risk assessment</p>
            </div>
          </div>
        </div>
      </div>

      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-12">
          {/* Features */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Features</h2>
            <ul className="space-y-4">
              {solution.features.map((feature, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{feature}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Benefits */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Benefits</h2>
            <ul className="space-y-4">
              {solution.benefits.map((benefit, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{benefit}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Use Cases */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Use Cases</h2>
            <ul className="space-y-4">
              {solution.useCases.map((useCase, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{useCase}</span>
                </li>
              ))}
            </ul>
          </div>
        </div>

        {/* CTA Section */}
        <div className="mt-16 bg-white rounded-lg p-8 shadow-sm border border-gray-200 text-center">
          <h2 className="text-3xl font-bold text-gray-900 mb-4">Ready to Transform Your Business?</h2>
          <p className="text-gray-600 mb-8 max-w-2xl mx-auto">
            Discover how investor tools can revolutionize your real estate operations and drive growth.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <Button className="text-black px-8 py-3" style={{backgroundColor: '#dc2626'}}>
              <Phone className="w-4 h-4 mr-2" />
+91-8068447416
            </Button>
            <Button 
              variant="outline" 
              className="border-[#dc2626] text-[#dc2626] hover:bg-[#dc2626] hover:text-white px-8 py-3"
              onClick={() => alert(`Request Quote for ${solution.title}\n\nSolution: ${solution.title}\nPricing: ${solution.pricing}\n\nContact us at +91-8068447416 for a detailed quote.`)}
            >
              <Mail className="w-4 h-4 mr-2" />
              Request Quote
            </Button>
          </div>
        </div>
      </div>
    </div>
  );
}