import React from "react";
import { Users, Target, Bell, Phone, Mail } from "lucide-react";
import { Button } from "../components/ui/button";

export function LeadsProspectsPage() {
  const solution = {
    title: "Leads & Prospects Management Suite",
    description:
      "Capture enquiries from multiple channels, organize prospects efficiently, and convert more opportunities into closed deals through a unified lead management platform.",
    features: [
      "Centralized dashboard to manage all enquiries and prospects in one place",
      "Lead capture from website forms, campaigns, walk-ins and referral sources",
      "Stage tracking from enquiry to closure with customizable lead pipelines",
      "Automatic reminders and follow-up scheduling to prevent missed opportunities",
      "Notes, activity timeline and interaction history for every prospect",
    ],
    benefits: [
      "Never lose a potential customer due to missed follow-ups",
      "Improve team productivity with structured workflows",
      "Gain clear visibility into hot, warm and cold leads",
      "Reduce manual tracking with automated alerts and statuses",
      "Increase conversion rates with focused and timely engagement",
    ],
    useCases: [
      "Sales teams managing large volumes of property enquiries",
      "Agents tracking interested buyers across multiple projects",
      "Builders monitoring booking interest and funnel movement",
      "Broker offices organizing daily inbound calls and walk-ins",
      "Marketing teams measuring enquiry quality and campaign performance",
    ],
  };

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <div className="text-white py-16" style={{ backgroundColor: "#1e40af" }}>
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <h1 className="text-4xl md:text-5xl font-bold mb-6">
              {solution.title}
            </h1>
            <p className="text-xl md:text-2xl text-amber-100 max-w-3xl mx-auto">
              {solution.description}
            </p>
          </div>
        </div>
      </div>

      {/* Solution Images */}
      <div className="bg-white py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="text-center">
              <img
                src="https://images.unsplash.com/photo-1556761175-b413da4baf72?w=400&h=300&fit=crop&crop=center"
                alt="Lead Capture"
                className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
              />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                Multi-Channel Lead Capture
              </h3>
              <p className="text-gray-600">
                Collect enquiries from web, calls, campaigns and walk-ins
              </p>
            </div>

            <div className="text-center">
              <img
                src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=400&h=300&fit=crop&crop=center"
                alt="Lead Tracking"
                className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
              />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                Lead & Prospect Tracking
              </h3>
              <p className="text-gray-600">
                Track progress from first enquiry to successful closure
              </p>
            </div>

            <div className="text-center">
              <img
                src="https://images.unsplash.com/photo-1611224923853-80b023f02d71?w=400&h=300&fit=crop&crop=center"
                alt="Follow Up Reminders"
                className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
              />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                Smart Follow-Up Reminders
              </h3>
              <p className="text-gray-600">
                Automated reminders ensure no prospect is forgotten
              </p>
            </div>
          </div>
        </div>
      </div>

      {/* Main Content */}
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-12">
          {/* Features */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">
              Key Features
            </h2>
            <ul className="space-y-4">
              {solution.features.map((feature, index) => (
                <li key={index} className="flex items-start gap-3">
                  <Users className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{feature}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Benefits */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">
              Business Benefits
            </h2>
            <ul className="space-y-4">
              {solution.benefits.map((benefit, index) => (
                <li key={index} className="flex items-start gap-3">
                  <Target className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{benefit}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Use Cases */}
          <div className="bg-white rounded-lg p-8 shadow-sm border border-gray-200">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Use Cases</h2>
            <ul className="space-y-4">
              {solution.useCases.map((useCase, index) => (
                <li key={index} className="flex items-start gap-3">
                  <Bell className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{useCase}</span>
                </li>
              ))}
            </ul>
          </div>
        </div>

        {/* CTA */}
        <div className="mt-16 bg-white rounded-lg p-8 shadow-sm border border-gray-200 text-center">
          <h2 className="text-3xl font-bold text-gray-900 mb-4">
            Start Managing Your Leads More Effectively
          </h2>

          <p className="text-gray-600 mb-8 max-w-2xl mx-auto">
            Experience a structured and efficient way to handle enquiries,
            nurture prospects, and close deals faster with a dedicated Leads &
            Prospects Management system.
          </p>

          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <Button className="bg-[#d97706] hover:bg-[#b45309] text-black px-8 py-3">
              <Phone className="w-4 h-4 mr-2" />
              +91-8068447416
            </Button>

            <Button
              variant="outline"
              className="border-[#d97706] text-[#d97706] hover:bg-[#d97706] hover:text-white px-8 py-3"
              onClick={() =>
                alert(
                  `Request more information about ${solution.title}\n\nWe will contact you shortly.\n\nCall us at +91-8068447416`
                )
              }
            >
              <Mail className="w-4 h-4 mr-2" />
              Request Information
            </Button>
          </div>

          <p className="text-xs text-gray-500 mt-6">
            Some features may be part of upcoming releases or available as
            add-ons based on plan selection.
          </p>
        </div>
      </div>
    </div>
  );
}
