import React from 'react';
import { ArrowLeft, Shield, FileText, Home, Smartphone, Map, Calendar, Zap, Target, Building2, Scale, Bot, BarChart3, MessageCircle, Phone, Trophy, Glasses, ShieldCheck, TrendingUp, Gavel, Globe, Mic, CreditCard, Bell, Sparkles, Plane } from 'lucide-react';
import { useNavigate } from 'react-router-dom';
import { Button } from '../components/ui/button';

export function NALStories() {
  const navigate = useNavigate();

  return (
    <div className="min-h-screen bg-gray-50 py-8">
      <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="mb-6">
          <Button
            variant="outline"
            onClick={() => navigate('/')}
            className="flex items-center gap-2"
          >
            <ArrowLeft className="w-4 h-4" />
            Back to Home
          </Button>
        </div>

        <div className="bg-white rounded-lg shadow-lg overflow-hidden">
          <div className="p-6 border-b">
            <h1 className="text-3xl font-bold text-gray-900">NAL Stories</h1>
            <p className="text-gray-600 mt-2">
              Discover the future of real estate with NAL AI technology
            </p>
          </div>

          <div className="p-6">
            <div className="aspect-video bg-black rounded-lg overflow-hidden mb-12">
              <video
                controls
                className="w-full h-full"
                poster="/api/placeholder/800/450"
              >
                <source src="/NAL AI VIDEO (v1).mp4" type="video/mp4" />
                Your browser does not support the video tag.
              </video>
            </div>


          </div>
        </div>
      </div>
    </div>
  );
}