import React, { useState } from 'react';
import { Check, Star, FileCheck, MapPin, Clock, Bell, BarChart3, MessageCircle, Search, Award, Building, Target, ChevronDown, ChevronUp, Users } from 'lucide-react';
import { Button } from '../components/ui/button';

const premiumBenefits = [
  {
    icon: FileCheck,
    title: 'Instant Document Verification Credits',
    description: 'Faster trust checks & legal clarity.'
  },
  {
    icon: MapPin,
    title: 'Exclusive Heatmap Insights',
    description: 'Demand, price, rental yield, urgent sale zones.'
  },
  {
    icon: Clock,
    title: 'Priority Access to New Listings',
    description: 'See properties 24 hrs before free users.'
  },
  {
    icon: Star,
    title: 'Featured Listing Credits',
    description: 'Get more visibility and faster leads.'
  },
  {
    icon: MessageCircle,
    title: 'Premium Support',
    description: 'Human + AI blended support.'
  },
  {
    icon: BarChart3,
    title: 'Advanced Financial Tools',
    description: 'EMI, affordability, cost breakdown.'
  },
  {
    icon: Bell,
    title: 'Smart Alerts & Personalization',
    description: 'Price drop, urgent sale, bidding reminders.'
  },
  {
    icon: Search,
    title: 'AI-Backed Property Comparison',
    description: 'Compare 2–4 properties side-by-side.'
  }
];

const buyerFeatures = [
  '5 free instant document verifications/month',
  'Urgent Sale alerts in chosen localities',
  '24-hour early access to new listings',
  'Unlimited Property Comparisons',
  'Premium Heatmap Insights (Demand, ROI, Urgency)',
  'Personalized alerts via WhatsApp',
  'AI property recommendations',
  'Faster booking confirmations'
];

const sellerFeatures = [
  '2 Featured listings every month',
  'Smart pricing tools (Fair Market Value + Urgent Sale Value)',
  'Buyer demand heatmap for pricing',
  'Verified leads only',
  'Auto-follow-up WhatsApp reminders',
  'Property promotion credits',
  'Higher ranking in search results'
];

const agentFeatures = [
  'Territory heatmap: weekly insights',
  'Auto-matching buyers with your listings',
  'SLA performance dashboard',
  'Verified Agent Badge',
  'Free Featured listings (1 per month)',
  'Auto WhatsApp follow-ups & lead responses',
  'High-quality lead filtering',
  'Priority support'
];

const businessFeatures = [
  'Unlimited listings',
  'Premium project banner placements',
  'Full campaign management',
  'Custom bidding setups',
  'Deep audience targeting',
  'Advanced analytics & reports'
];

const comparisonData = [
  { feature: 'Instant Doc Verifications', free: '✖', plus: '3/month', pro: '10/month', business: 'Unlimited' },
  { feature: 'Featured Listings', free: '✖', plus: '1/month', pro: '3/month', business: '10/month' },
  { feature: 'Heatmap Insights', free: 'Basic', plus: 'Advanced', pro: 'Advanced', business: 'Enterprise' },
  { feature: 'Early Access to Listings', free: '✖', plus: '✔', pro: '✔', business: '✔' },
  { feature: 'Premium Support', free: '✖', plus: '✔', pro: '✔ Priority', business: '24/7 Dedicated' },
  { feature: 'Advanced Comparison Tool', free: 'Limited', plus: 'Unlimited', pro: 'Unlimited', business: 'Unlimited' },
  { feature: 'Territory Insights', free: '✖', plus: '✖', pro: '✔', business: '✔' },
  { feature: 'Bidding Tools', free: 'Basic', plus: 'Standard', pro: 'Advanced', business: 'Enterprise' }
];

const faqs = [
  {
    question: 'What is included in NAL Premium?',
    answer: 'NAL Premium includes document verification credits, exclusive heatmap insights, priority access to listings, premium support, and advanced financial tools.'
  },
  {
    question: 'Is document verification included?',
    answer: 'Yes, Premium plans include monthly document verification credits ranging from 3-10 verifications depending on your plan.'
  },
  {
    question: 'Do agents get separate premium?',
    answer: 'Yes, we have specialized Premium plans for agents with territory insights, lead management tools, and verified agent badges.'
  },
  {
    question: 'Can sellers feature properties for free?',
    answer: 'Premium sellers get monthly featured listing credits included in their subscription at no extra cost.'
  },
  {
    question: 'Can I cancel anytime?',
    answer: 'Yes, you can cancel your Premium subscription anytime. No long-term commitments required.'
  }
];

export function PremiumPackages() {
  const [openFaq, setOpenFaq] = useState<number | null>(null);

  return (
    <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <section className="bg-white py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <div className="mb-8">
            <img src="/logo.png" alt="NAL Logo" className="h-12 mx-auto mb-8" />
          </div>
          <h1 className="text-4xl md:text-6xl font-bold text-gray-900 mb-6">
            NAL Premium – Smarter, Faster, Trust-First Real Estate
          </h1>
          <p className="text-xl text-gray-600 max-w-4xl mx-auto mb-8">
            Unlock advanced verification, premium visibility, AI insights, and priority support — 
            built for buyers, sellers, and agents who don't want to waste time.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button size="lg" className="bg-[#0056D2] hover:bg-[#0041a8] text-white px-8 py-4">
              Get Premium
            </Button>
            <Button size="lg" variant="ghost" className="text-[#0056D2] border border-[#0056D2] hover:bg-[#0056D2] hover:text-white px-8 py-4">
              Compare Plans
            </Button>
          </div>
        </div>
      </section>

      {/* Premium Benefits Summary */}
      <section className="py-16 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Why Upgrade to NAL Premium?
            </h2>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            {premiumBenefits.map((benefit, index) => (
              <div key={index} className="text-center p-6 bg-white rounded-lg shadow-sm hover:shadow-xl hover:scale-105 hover:-translate-y-2 transition-all duration-300 cursor-pointer group">
                <div className="w-16 h-16 bg-[#0056D2]/10 group-hover:bg-[#0056D2]/20 rounded-full flex items-center justify-center mx-auto mb-4 transition-colors duration-300">
                  <benefit.icon className="w-8 h-8 text-[#0056D2] group-hover:scale-110 transition-transform duration-300" />
                </div>
                <h3 className="text-lg font-semibold text-gray-900 mb-2 group-hover:text-[#0056D2] transition-colors duration-300">
                  {benefit.title}
                </h3>
                <p className="text-gray-600 text-sm">{benefit.description}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Buyer Premium Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="bg-gradient-to-br from-[#0056D2]/10 to-[#0056D2]/5 rounded-2xl p-8 flex items-center justify-center">
              <div className="text-center">
                <div className="w-32 h-32 bg-[#0056D2] rounded-full flex items-center justify-center mx-auto mb-4">
                  <Users className="w-16 h-16 text-white" />
                </div>
                <p className="text-[#0056D2] font-medium">Smart Buyer Analytics</p>
              </div>
            </div>
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-4">Premium for Buyers</h2>
              <p className="text-lg text-gray-600 mb-6">
                Make confident, faster property decisions with verified insights.
              </p>
              <ul className="space-y-3 mb-8">
                {buyerFeatures.map((feature, index) => (
                  <li key={index} className="flex items-start">
                    <Check className="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">{feature}</span>
                  </li>
                ))}
              </ul>
              <Button className="bg-[#0056D2] hover:bg-[#0041a8] text-white px-8 py-3">
                Get Premium Buyer Plan
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Seller Premium Section */}
      <section className="py-16 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-4">Premium for Sellers</h2>
              <p className="text-lg text-gray-600 mb-6">
                Get more visibility. Close deals faster. Build trust instantly.
              </p>
              <ul className="space-y-3 mb-8">
                {sellerFeatures.map((feature, index) => (
                  <li key={index} className="flex items-start">
                    <Check className="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">{feature}</span>
                  </li>
                ))}
              </ul>
              <Button className="bg-[#0056D2] hover:bg-[#0041a8] text-white px-8 py-3">
                Get Premium Seller Plan
              </Button>
            </div>
            <div className="bg-gradient-to-br from-[#0056D2]/10 to-[#0056D2]/5 rounded-2xl p-8 flex items-center justify-center">
              <div className="text-center">
                <div className="w-32 h-32 bg-[#0056D2] rounded-full flex items-center justify-center mx-auto mb-4">
                  <Building className="w-16 h-16 text-white" />
                </div>
                <p className="text-[#0056D2] font-medium">Smart Seller Tools</p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Agent Premium Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="bg-gradient-to-br from-[#0056D2]/10 to-[#0056D2]/5 rounded-2xl p-8 flex items-center justify-center">
              <div className="text-center">
                <div className="w-32 h-32 bg-[#0056D2] rounded-full flex items-center justify-center mx-auto mb-4">
                  <Award className="w-16 h-16 text-white" />
                </div>
                <p className="text-[#0056D2] font-medium">Agent Territory Management</p>
              </div>
            </div>
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-4">Premium for Agents</h2>
              <p className="text-lg text-gray-600 mb-6">
                Dominate your territory and unlock smarter lead management.
              </p>
              <ul className="space-y-3 mb-8">
                {agentFeatures.map((feature, index) => (
                  <li key={index} className="flex items-start">
                    <Check className="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">{feature}</span>
                  </li>
                ))}
              </ul>
              <Button className="bg-[#0056D2] hover:bg-[#0041a8] text-white px-8 py-3">
                Upgrade to Agent Premium
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Enterprise/Builder Premium Section */}
      <section className="py-16 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-4">NAL Business</h2>
              <p className="text-lg text-gray-600 mb-6">
                For Developers & Builders
              </p>
              <ul className="space-y-3 mb-8">
                {businessFeatures.map((feature, index) => (
                  <li key={index} className="flex items-start">
                    <Check className="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">{feature}</span>
                  </li>
                ))}
              </ul>
              <Button className="bg-[#0056D2] hover:bg-[#0041a8] text-white px-8 py-3">
                Get Business Plan
              </Button>
            </div>
            <div className="bg-gradient-to-br from-[#0056D2]/10 to-[#0056D2]/5 rounded-2xl p-8 flex items-center justify-center">
              <div className="text-center">
                <div className="w-32 h-32 bg-[#0056D2] rounded-full flex items-center justify-center mx-auto mb-4">
                  <Target className="w-16 h-16 text-white" />
                </div>
                <p className="text-[#0056D2] font-medium">Enterprise Solutions</p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Plan Comparison Table */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Compare Plans
            </h2>
            <p className="text-lg text-gray-600">
              Choose the plan that fits your needs
            </p>
          </div>
          <div className="overflow-x-auto">
            <table className="w-full bg-white rounded-lg shadow-lg overflow-hidden">
              <thead className="bg-[#0056D2] text-white">
                <tr>
                  <th className="px-6 py-4 text-left font-semibold">Feature</th>
                  <th className="px-6 py-4 text-center font-semibold">Free</th>
                  <th className="px-6 py-4 text-center font-semibold">NAL Plus</th>
                  <th className="px-6 py-4 text-center font-semibold">NAL Pro</th>
                  <th className="px-6 py-4 text-center font-semibold">NAL Business</th>
                </tr>
              </thead>
              <tbody>
                {comparisonData.map((row, index) => (
                  <tr key={index} className={index % 2 === 0 ? 'bg-gray-50' : 'bg-white'}>
                    <td className="px-6 py-4 font-medium text-gray-900">{row.feature}</td>
                    <td className="px-6 py-4 text-center text-gray-600">{row.free}</td>
                    <td className="px-6 py-4 text-center text-gray-600">{row.plus}</td>
                    <td className="px-6 py-4 text-center text-gray-600">{row.pro}</td>
                    <td className="px-6 py-4 text-center text-gray-600">{row.business}</td>
                  </tr>
                ))}
              </tbody>
            </table>
          </div>
        </div>
      </section>

      {/* FAQ Section */}
      <section className="py-16 bg-gray-50">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Frequently Asked Questions
            </h2>
            <p className="text-lg text-gray-600">
              Get answers to common questions about NAL Premium
            </p>
          </div>
          <div className="space-y-4">
            {faqs.map((faq, index) => (
              <div key={index} className="bg-white rounded-lg shadow-sm">
                <button
                  className="w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors"
                  onClick={() => setOpenFaq(openFaq === index ? null : index)}
                >
                  <span className="font-semibold text-gray-900">{faq.question}</span>
                  {openFaq === index ? (
                    <ChevronUp className="w-5 h-5 text-gray-500" />
                  ) : (
                    <ChevronDown className="w-5 h-5 text-gray-500" />
                  )}
                </button>
                {openFaq === index && (
                  <div className="px-6 pb-4">
                    <p className="text-gray-600">{faq.answer}</p>
                  </div>
                )}
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Final CTA Section */}
      <section className="py-16 bg-gradient-to-r from-[#0056D2] to-[#0041a8]">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl font-bold text-white mb-6">
            Ready to Experience Smarter Real Estate?
          </h2>
          <p className="text-xl text-white/90 mb-8">
            Upgrade to NAL Premium and unlock powerful tools built for trust and speed.
          </p>
          <Button size="lg" className="bg-white text-[#0056D2] hover:bg-gray-100 px-8 py-4">
            Upgrade Now
          </Button>
        </div>
      </section>
    </div>
  );
}