import React from 'react';
import { Shield, Eye, Lock, Users, FileText, Globe, Mail } from 'lucide-react';

export function PrivacyPolicy() {

  const sections = [
    {
      id: "scope",
      title: "Scope & Consent",
      icon: <Shield className="w-5 h-5" />,
      content: "By using or continuing to use the Platform, you consent to the collection, usage, disclosure and transfer of your personal data as described in this Privacy Policy. Where required, you will be asked to provide separate consent for processing sensitive or special categories of personal data."
    },
    {
      id: "collection",
      title: "Information We Collect",
      icon: <Eye className="w-5 h-5" />,
      content: [
        {
          subtitle: "A. Information you provide:",
          items: [
            "Personal information: name, contact number, email address, postal address, PIN/ZIP code, preferences.",
            "Property information: property type, location, area, dimensions, amenities, price, photographs, listing documents.",
            "Identification/KYC documents: AADHAAR, PAN, passport, driver's licence, voter ID – if required for verification.",
            "Payment/billing data:transaction IDs. (Via third-party payment processors; card details are not directly stored unless disclosed.)",
            "Communications: messages, feedback, calls, emails you send to us or via the Platform."
          ]
        },
        {
          subtitle: "B. Information collected automatically:",
          items: [
            "Log and device data: IP address, browser type, operating system, device identifiers, mobile carrier, clickstream data, search queries, time spent, referring URL.",
            "Location information: approximate city/region derived from IP or device location (if permitted).",
            "Cookies and similar technologies: for remembering preferences, analytics, advertising.",
            "App permissions (if mobile app): camera, photos/gallery, contacts, location, microphone — only with your permission."
          ]
        },
        {
          subtitle: "C. Information obtained from third parties:",
          items: [
            "Publicly available databases (e.g., RERA project information, property registration portals).",
            "Marketing/advertising/analytics partners."
          ]
        }
      ]
    },
    {
      id: "usage",
      title: "How We Use Your Information",
      icon: <Users className="w-5 h-5" />,
      content: [
        "Creating and managing your account, validating identity and managing access.",
        "Providing, operating and improving the Platform and Services (listing, search, matching, alerts).",
        "Verifying property ownership, KYC and preventing fraud or misuse.",
        "Enabling communication between buyers, sellers, brokers, builders and other users.",
        "Processing payments, subscriptions or premium features.",
        "Customising and personalising your experience (recommendations, saved searches) and targeted marketing (with your consent).",
        "Sending you transactional communications (service updates, notifications) and promotional offers (only if opted-in).",
        "Analytics and research: understanding how users use the Platform, improving features, detecting trends.",
        "Legal, regulatory and compliance obligations (RERA disclosures, audit, internal investigations, litigation).",
        "Engaging in corporate transactions (mergers, acquisition, sale of assets) where your data may be transferred as part of business assets."
      ]
    },
    {
      id: "disclosure",
      title: "Disclosure of Your Information",
      icon: <Globe className="w-5 h-5" />,
      content: [
        "Service providers and vendors (payment gateways, cloud hosting, analytics, KYC/verification agencies).",
        "Other users of the Platform: e.g., when you authorize contact between you and a seller, broker or agent, relevant contact details and listing info may be shared.",
        "Financial & banking partners: if you express interest in loans or other financial services.",
        "Legal/regulatory authorities: courts, RERA authorities, law enforcement, government agencies when required by law or to protect rights.",
        "Corporate affiliates / successors: in event of merger, acquisition or asset transfer."
      ]
    },
    {
      id: "cookies",
      title: "Cookies & Tracking Technologies",
      icon: <Globe className="w-5 h-5" />,
      content: [
        "Remember your login, preferences and settings.",
        "Provide personalised content and offers.",
        "Analyse usage patterns and improve our Platform.",
        "Enable advertising and promotions (if you have opted-in).",
        "You may manage or disable cookies via browser settings; however disabling cookies may impair full functionality."
      ]
    },
    {
      id: "security",
      title: "Data Storage, Security & Retention",
      icon: <Lock className="w-5 h-5" />,
      content: [
        "We store your personal data primarily on servers located in India. In some cases, your data may be transferred or stored in other jurisdictions (we will ensure appropriate security measures if so).",
        "We implement administrative, technical and physical safeguards to protect your data (encryption in transit, access controls, periodic audits).",
        "We retain your data as long as required for the purposes described or as mandated by legal or regulatory obligations.",
        "Once no longer required, we will delete or anonymize the data."
      ]
    },
    {
      id: "rights",
      title: "Your Rights",
      icon: <FileText className="w-5 h-5" />,
      content: [
        "Access your personal data held by us and obtain a copy.",
        "Request correction or updating of inaccurate or incomplete data.",
        "Request deletion of your account and associated personal data (subject to legal/contractual obligations).",
        "Withdraw your consent for marketing communications at any time.",
        "Object to or restrict processing of your data in certain circumstances."
      ]
    },
    {
      id: "thirdparty",
      title: "Third-Party Links and Services",
      icon: <Globe className="w-5 h-5" />,
      content: "Our Platform may contain links to third-party websites, apps or services (e.g., state RERA portals, financial institutions, payment gateways). We are not responsible for their privacy practices. Please review the privacy policy of each such service before proceeding."
    },
    {
      id: "children",
      title: "Children's Privacy",
      icon: <Shield className="w-5 h-5" />,
      content: "Our services are intended for individuals aged 18 years and above. We do not knowingly collect personal data from minors (under 18). If you become aware that a minor has provided us with data, please contact us and we will delete that data promptly."
    },
    {
      id: "updates",
      title: "Updates to this Privacy Policy",
      icon: <FileText className="w-5 h-5" />,
      content: "We may modify this Privacy Policy from time to time. The 'Last Updated' date will be displayed on this page. Continued use of the Platform after changes indicates your acceptance of the revised policy."
    }
  ];

  return (
    <div className="min-h-screen bg-gray-50 pt-20">
      {/* Header */}
      <div
        className="bg-gradient-to-r from-blue-500 to-blue-700"
        style={{
          background: "linear-gradient(90deg, #3B82F6 0%, #1D4ED8 100%)",
        }}
      >
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
          <div className="text-center">
            <h1
              className="text-4xl md:text-5xl font-bold mb-4"
              style={{ color: "#FFFFFF" }}
            >
              Privacy Policy
            </h1>
            <p
              className="text-xl max-w-3xl mx-auto"
              style={{ color: "#FFFFFF" }}
            >
              How we collect, use, and protect your personal information with
              complete transparency
            </p>
          </div>
        </div>
      </div>

      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        {/* Introduction */}
        <div className="bg-white rounded-lg shadow-sm border p-6 mb-8">
          <p className="text-gray-700 leading-relaxed">
            This policy is for <strong>NAL India Pvt Ltd.</strong> applies to
            the platform (website and/or mobile application) providing
            real-estate listing, search, buying, selling, renting, and related
            services (the "Platform").
          </p>
        </div>

        {/* Policy Sections */}
        <div className="space-y-8">
          {sections.map((section, index) => (
            <div
              key={section.id}
              className="bg-white rounded-lg shadow-sm border overflow-hidden"
            >
              <div className="p-6">
                <div className="flex items-center space-x-3 mb-4">
                  <div className="flex-shrink-0 p-2 bg-blue-100 rounded-lg text-blue-600">
                    {section.icon}
                  </div>
                  <h2 className="text-xl font-semibold text-gray-900">
                    {section.title}
                  </h2>
                </div>

                {typeof section.content === "string" ? (
                  <p className="text-gray-700 leading-relaxed">
                    {section.content}
                  </p>
                ) : Array.isArray(section.content) &&
                  typeof section.content[0] === "string" ? (
                  <ul className="space-y-2">
                    {section.content.map((item, idx) => (
                      <li key={idx} className="flex items-start space-x-2">
                        <div className="w-1.5 h-1.5 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                        <span className="text-gray-700">{item}</span>
                      </li>
                    ))}
                  </ul>
                ) : (
                  <div className="space-y-6">
                    {section.content.map((subsection, idx) => (
                      <div key={idx}>
                        <h3 className="font-medium text-gray-900 mb-3">
                          {subsection.subtitle}
                        </h3>
                        <ul className="space-y-2 ml-4">
                          {subsection.items.map((item, itemIdx) => (
                            <li
                              key={itemIdx}
                              className="flex items-start space-x-2"
                            >
                              <div className="w-1.5 h-1.5 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                              <span className="text-gray-700">{item}</span>
                            </li>
                          ))}
                        </ul>
                      </div>
                    ))}
                  </div>
                )}
              </div>
            </div>
          ))}
        </div>

        {/* Important Notes */}
        <div className="mt-8 space-y-6">
          <div className="bg-red-50 border border-red-200 rounded-lg p-6">
            <h3 className="text-lg font-semibold text-red-900 mb-2">
              Important Notice
            </h3>
            <p className="text-red-800">
              We do not sell or rent your personal data for marketing purposes
              without your explicit consent.
            </p>
          </div>

          <div className="bg-green-50 border border-green-200 rounded-lg p-6">
            <h3 className="text-lg font-semibold text-green-900 mb-2">
              Grievance Redressal
            </h3>
            <div className="text-green-800 space-y-2">
              <p>
                <strong>Grievance Officer:</strong> NAL India Support Team
              </p>
              <div className="flex items-center space-x-2">
                <Mail className="w-4 h-4" />
                <span>Email:info@newagelandindia.com</span>
              </div>
              <p>
                <strong>Address:</strong> NAL India Pvt Ltd. #28, Third Floor,
                MCHS Layout KV Jayaram Road, Jakkur, Bengaluru, India
              </p>
              <p>
                <strong>Phone:</strong> +91-8068447416
              </p>
              <p className="text-sm">
                We endeavour to respond to your complaint within 30 business
                days.
              </p>
            </div>
          </div>
        </div>

        {/* Contact Information */}
        <div className="mt-8 bg-gray-900 text-white rounded-lg p-6">
          <h3 className="text-lg font-semibold mb-4">Contact Us</h3>
          <p className="text-gray-300 mb-4">
            To exercise your rights or for any privacy-related queries, contact
            us at:
          </p>
          <div className="space-y-3 text-gray-300">
            <div className="flex items-center space-x-2">
              <Mail className="w-4 h-4" />
              <span>info@newagelandindia.com</span>
            </div>
            <div className="text-center space-y-1">
              <p>
                <strong>NAL India Pvt Ltd.</strong>
              </p>
              <p>#28, Third Floor, MCHS Layout KV Jayaram Road, Jakkur</p>
              <p>Bengaluru, India</p>
              <p>Phone: +91-8068447416</p>
            </div>
            <p className="text-sm">
              <strong>Effective Date:</strong> November 30, 2025
            </p>
          </div>
        </div>
      </div>
    </div>
  );
}