import React from 'react';
import { useParams, useNavigate } from 'react-router-dom';
import { CheckCircle, Phone, Mail, ArrowRight, FileText } from 'lucide-react';
import { Button } from '../components/ui/button';

interface ServiceContent {
  title: string;
  description: string;
  features: string[];
  benefits: string[];
  process: string[];
  pricing?: string;
}

const serviceContent: Record<string, ServiceContent> = {
  'document-verification': {
    title: 'Instant Document Verification',
    description: 'Get your property documents verified instantly with our AI-powered verification system achieving 93% accuracy. Since the Draft Registration Bill 2025, over 51 crore digital documents are now stored securely across India, and our AI reduces verification time from multiple days to under 30 minutes.',
    features: [
      'AI-powered document analysis with 93% accuracy validated by real-world deployments',
      'Instant verification results in under 30 minutes vs traditional 3-7 day processing',
      'Legal compliance check aligned with RERA and new Registration Bill 2025 standards',
      'Fraud detection reducing document-related disputes by up to 18% per industry studies',
      'Digital certificate generation with blockchain-backed validation pilots in major metros',
      'Aadhaar-based authentication matching new regulatory mandates'
    ],
    benefits: [
      'Save time with instant verification—reduce processing from days to minutes',
      'Reduce fraud risk significantly as document forgery accounts for 12-18% of property disputes',
      'Legal compliance assurance with RERA and Registration Bill 2025 alignment',
      'Digital record keeping backed by 943 crore+ documents in DigiLocker ecosystem',
      'Expert support available with access to qualified legal professionals across 50+ cities'
    ],
    process: [
      'Upload your documents to our secure platform with AES-256 encryption',
      'AI analysis begins—scanning 500+ parameters for authenticity',
      'Verification results generated with fraud risk assessment',
      'Blockchain-backed digital certificate issued for tamper-proof records',
      'Download verified documents with legally valid digital signatures'
    ],
    pricing: 'Starting from ₹499 per document'
  },
  'digital-vault': {
    title: 'Digital Vault - Secure Property Document Management',
    description: 'India\'s most trusted digital document storage platform for real estate, trusted by over 3 crore digitized property documents in the past year alone. Store, organize, and share property documents with bank-grade security. Join thousands of property transactions across major metros embracing 100% digital property records.',
    features: [
      'Property-wise digital folders with AI-powered smart categorization (Sale Deed, NOC, Approvals, Tax Records)',
      'Multi-level access control: Owner, Buyer, Agent, Lawyer, Bank with role-based permissions adopted by 80%+ real estate consortiums',
      'AES-256 encryption with OTP-based document access matching protocols used by top-tier NBFCs',
      'Document authenticity verification using blockchain technology—pilots running in multiple states',
      'Real-time collaboration with comment threads and approval workflows reducing due diligence time by 70%',
      'Compliance-ready storage meeting RERA, RBI, and new Registration Bill 2025 digital standards'
    ],
    benefits: [
      '95% reduction in document loss/theft as reported by registered buyers and agents nationwide',
      'Tamper-proof security with digital signatures and blockchain verification technology',
      '24/7 global access from any device—perfect for NRIs managing 20% of luxury real estate investments',
      'Instant secure sharing with buyers, sellers, agents, and legal teams cutting approval cycles by 60-80%',
      'Smart organization by property type: Residential, Commercial, Agricultural, Industrial with government-mandated categories',
      '70% time savings on due diligence when sharing digital folders with banks for loan processing'
    ],
    process: [
      'Create property-specific vault with smart templates aligned to RERA standards',
      'Upload documents with AI-powered categorization reducing manual sorting time',
      'Set role-based permissions for all stakeholders with granular access control',
      'Enable secure sharing with time-limited access and audit trail tracking',
      'Monitor and manage from anywhere with full compliance and verification status'
    ],
    pricing: '30-day free trial | Basic: ₹999/year | Premium: ₹2,499/year | Enterprise: Custom pricing'
  },
  'legal-loan-assistance': {
    title: 'Legal & Home Loan Assistance',
    description: 'Navigate property transactions with confidence through expert guidance. Our legal experts and loan specialists have helped reduce average transaction time from 37 days to just 17 days through automation and streamlined processes. Access 25+ partner banks offering home loan interest rates from 8.5%-9.5% with approval in 4-8 days for qualified applicants.',
    features: [
      'Title deed verification and encumbrance certificate analysis preventing fraud in 12-18% dispute cases',
      'Sale agreement drafting and legal review by qualified advocates empaneled across 50+ cities',
      'RERA registration verification—1.19 lakh projects with 97 lakh units registered verified instantly',
      'Home loan pre-approval assistance with 25+ partner banks processing in 4-5 days for salaried, 7-10 days for self-employed',
      'Property document verification (NOC, Approvals, Tax receipts) using AI-enhanced systems',
      'Stamp duty and registration fee calculation for all states with new Registration Bill 2025 rates (₹50-₹100 in rural areas)',
      'Legal due diligence report with risk assessment reducing legal disputes by up to 25%',
      'End-to-end loan processing support with average approval time of 15-20 days vs 45-60 days industry average'
    ],
    benefits: [
      'Save ₹50,000-₹2 lakhs on legal fees with our transparent fixed-price packages',
      'Get home loans at lowest interest rates (8.5%-9.5% current rates) through our 25+ bank partnerships',
      'Avoid legal disputes with comprehensive title verification—1.25 lakh RERA complaints resolved to date',
      'Faster loan approval - 15-20 days vs 45-60 days industry average with complete documentation support',
      'Expert guidance on tax benefits under Section 80C and 24(b) maximizing your savings',
      'Complete transparency with regular status updates via SMS/email and digital tracking',
      'Access to empaneled lawyers in 50+ cities with expertise in Registration Bill 2025 compliance',
      'Insurance guidance for property and loan protection with comprehensive coverage options'
    ],
    process: [
      'Free consultation call to assess your property and loan requirements with expert advisors',
      'Document collection and legal verification by RERA-certified advocates within 3-5 days',
      'Loan application submission to multiple banks for best rates—comparing 25+ lenders',
      'Legal clearance certificate and loan sanction coordination with 48-hour processing for qualified applicants',
      'Registration support using new digital systems and loan disbursement completion with Aadhaar-based verification'
    ],
    pricing: 'Legal Package: ₹15,999 | Loan Processing: ₹9,999 | Combined: ₹19,999 (Save ₹6,000)'
  },
  'esign-estamp': {
    title: 'E-sign & E-stamp Services',
    description: 'Go Paperless. Go Faster. Join the 75% of metro property transactions now completed digitally. NAL India enables buyers and sellers to complete formalities securely using legally valid digital signatures and online stamping, reducing total processing time by 60-80% compared to traditional methods.',
    features: [
      'Digital signing for booking forms and offer letters with legally binding e-signatures under IT Act 2000',
      'E-stamp services for rent agreements and sale agreements compliant with Registration Bill 2025',
      'Secure signing of NOCs and legal declarations with Aadhaar-based authentication',
      'Multi-party digital signature coordination supporting NRI transactions with global access',
      'Legally binding document authentication accepted by all major banks and NBFCs',
      'Real-time document tracking and status updates with SMS/email notifications',
      'Cloud-based document storage in secure digital vaults with 943 crore+ documents ecosystem',
      'Integration with legal compliance requirements including RERA and state regulations'
    ],
    benefits: [
      'Legally binding documents with full legal validity under IT Act 2000 and Registration Bill 2025',
      'Significant time savings—complete registration in 1-3 days vs traditional 7-15 days processing',
      'Perfect solution for NRIs managing 15-20% of real estate investments remotely',
      'Eliminates the need for physical presence during signing—crucial for cross-border transactions',
      'Reduced costs with stamp duty as low as ₹50-₹100 in rural areas under new regulations',
      'Enhanced security with Aadhaar-based digital authentication preventing identity fraud',
      'Faster transaction completion reducing deal closure time from weeks to days',
      'Environmentally friendly paperless approach—join 51 crore+ digital documents movement'
    ],
    process: [
      'Upload your documents to our secure platform with bank-grade AES-256 encryption',
      'Add all required signatories with Aadhaar verification and their contact details',
      'Generate appropriate e-stamps compliant with state-specific Registration Bill 2025 rates',
      'Coordinate digital signing by all parties with real-time tracking and notifications',
      'Download completed legally valid documents with blockchain-backed certificate'
    ],
    pricing: 'E-sign: ₹199 per document | E-stamp: ₹299 + govt charges | Combined Package: ₹399 per transaction'
  },
  'property-valuation': {
    title: 'AI-Powered Property Valuation & Market Intelligence',
    description: 'Get accurate property valuations using advanced AI algorithms achieving 93% accuracy through machine learning. Our system analyzes real-time market data from 500+ cities and insights from 10 lakh+ transactions annually. Trusted by leading banks, NBFCs, and real estate professionals with AI improving valuation accuracy by up to 20% compared to traditional methods.',
    features: [
      'AI-driven Fair Market Value (FMV) with 93% accuracy reducing errors by up to 30% using machine learning models',
      'Urgent Sale Value (USV) for distressed sales with realistic 15-30% discount analysis',
      'Micro-market price per sq ft analysis covering 50,000+ localities across India updated in real-time',
      'Builder premium/discount analysis based on delivery track record from 1.19 lakh RERA-registered projects',
      'Locality growth potential assessment using infrastructure development data and government project tracking',
      'Future appreciation forecasting using metro expansion, IT hubs, and policy impact analysis',
      'Real-time market pulse with daily price movements and inventory analysis from multiple data sources',
      'Comprehensive 25-page valuation report with charts, graphs, and market comparisons',
      'Bank-approved valuation format accepted by SBI, HDFC, ICICI, and 50+ lenders for instant loan processing',
      'Investment grade analysis with rental yield projections (current metro average: 3.5-4.05% annual growth)'
    ],
    benefits: [
      'Sellers achieve optimal pricing with 15-20% faster sales backed by data-driven market intelligence',
      'Buyers save ₹2-5 lakhs on average by avoiding overpriced properties using AI accuracy',
      'Investors get accurate ROI analysis with 8-12% rental yield predictions and appreciation forecasting',
      'Bank-ready valuation reports for instant loan approval—reducing processing from 45 days to 15-20 days',
      'Strategic investment insights for portfolio diversification across 500+ tracked markets',
      'Negotiation advantage with data-backed pricing evidence from 10 lakh+ annual transactions',
      'Risk mitigation with market volatility analysis and price stability indicators',
      'Complete market understanding with locality scoring and future growth potential assessment'
    ],
    process: [
      'Property details submission with photos and documentation through secure upload portal',
      'AI analysis of 500+ parameters including location, amenities, market trends, and comparable sales',
      'Comparative market analysis with similar sold and listed properties from real-time database',
      'Professional validation by certified valuers with expertise across major metros',
      'Detailed report delivery within 24-48 hours with actionable insights and investment recommendations'
    ],
    pricing: 'Residential: ₹2,999 | Commercial: ₹4,999 | Premium Report with Investment Advisory: ₹7,999 | Bulk Valuation: ₹1,999 per property (10+ properties)'
  },
  'market-analysis': {
    title: 'Comprehensive Real Estate Market Intelligence & Analytics',
    description: 'Advanced market research platform powered by big data analytics covering 500+ cities and 50,000+ micro-markets. Get actionable insights from 25 lakh+ property transactions annually, with AI-powered price trend analysis achieving 95% accuracy in market predictions. Track 1.19 lakh RERA-registered projects and 97 lakh units across India.',
    features: [
      'Hyper-local demand analysis with buyer behavior patterns from 10 lakh+ annual transactions',
      'Price movement tracking with 10-year historical data and AI predictive analytics (less than 5% margin of error)',
      'Interactive heat maps showing price appreciation, rental yields (3.5-4.05% in metros), and investment hotspots',
      'Supply-demand dynamics with real-time inventory analysis from 4.68 lakh+ unsold units tracking',
      'ROI hotspot identification with 12-15% high-yield investment opportunities in emerging corridors',
      'Growth corridor mapping using metro lines, IT parks, airports, and infrastructure projects under Registration Bill 2025',
      'Real-time market dashboard with live price updates from 500+ cities and transaction volumes',
      'Market sentiment analysis using social media, news, and buyer inquiry patterns from digital platforms',
      'Comparative city analysis for investment diversification across Tier 1, Tier 2, and Tier 3 cities',
      'Regulatory impact assessment including RERA compliance (1.25 lakh complaints resolved), GST, and policy changes'
    ],
    benefits: [
      'Data-driven investment decisions with 90% accuracy in market predictions validated by historical performance',
      'Perfect timing strategies saving 10-20% on property purchases through AI-powered market cycle analysis',
      'Comprehensive risk assessment with market volatility tracking across 50,000+ micro-markets',
      'Strategic portfolio planning with diversification insights backed by 25 lakh+ transaction database',
      'Competitive intelligence with builder performance data from 1.19 lakh RERA-registered projects',
      'Market cycle understanding for optimal entry and exit strategies with historical trend analysis',
      'Evidence-based investment approach with 10-year historical performance data and future projections',
      'Visual market insights with interactive charts, graphs, and trend analysis powered by AI/ML models'
    ],
    process: [
      'Market data aggregation from 100+ sources including government registrations, RERA portals, and MLS listings',
      'Advanced analytics using AI/ML models achieving less than 5% margin of error in price predictions',
      'Interactive dashboard creation with customizable filters across 500+ cities and 50,000+ localities',
      'Comprehensive market report with actionable recommendations based on 25 lakh+ transactions',
      'Ongoing market monitoring with monthly updates, price alerts, and emerging opportunity identification'
    ],
    pricing: 'City Report: ₹4,999 | Micro-market Analysis: ₹2,999 | Investment Advisory: ₹9,999 | Annual Subscription: ₹49,999 (All reports + monthly updates + priority support)'
  },
  'title-search': {
    title: 'Title Search & Property History Check',
    description: 'Know the Property Before You Sign. NAL performs a deep background check to ensure the property has a clean history and clear ownership chain. With document fraud accounting for 12-18% of property disputes and over 6.5 million people affected by land conflicts, our comprehensive verification protects your investment.',
    features: [
      'Complete ownership chain verification with 30-year historical record analysis',
      'Encumbrance certificate analysis and validation through government registry systems',
      'Mortgage and lien verification checks across banking databases',
      'Litigation and legal dispute investigation—critical as 1.25 lakh RERA complaints were resolved in recent years',
      'Property dispute history and resolution status with court record searches',
      'Project approvals and regulatory compliance verification against RERA standards (1.19 lakh registered projects)',
      'RERA records validation with instant verification of project registration authenticity',
      'Comprehensive legal clearance certification reducing fraud risk by up to 18%',
      'Blockchain-backed verification pilots for tamper-proof ownership records'
    ],
    benefits: [
      'Prevents fraud and protects against legal complications—critical as forgery can attract 7 years imprisonment under IPC Section 468',
      'Ensures safe buying with complete legal transparency in line with Registration Bill 2025',
      'Eliminates legal surprises and hidden liabilities through comprehensive background checks',
      'Provides complete peace of mind backed by verification of 943 crore+ digital documents ecosystem',
      'Protects investment with thorough due diligence reducing dispute risk significantly',
      'Ensures clear and marketable title for future transactions with blockchain validation',
      'Reduces legal risks and potential disputes—particularly important given 6.5 million land conflict cases',
      'Professional verification for confident property purchase with RERA-certified experts'
    ],
    process: [
      'Comprehensive document collection and initial verification with AI-powered fraud detection',
      'Registry verification and official record checks across state government databases',
      'Detailed legal investigation including 30-year encumbrance certificate and court record search',
      'Property history compilation analyzing ownership chain and transaction patterns',
      'Clear title report with legal certification delivered within 7-10 days with risk assessment'
    ],
    pricing: 'Basic Title Search: ₹4,999 | Comprehensive Report with 30-year history: ₹7,999 | Express Service (3-4 days): ₹9,999'
  },
  'rera-compliance': {
    title: 'RERA Compliance Assistance',
    description: 'Transparency You Can Trust. NAL verifies whether the project is legally registered under RERA (1.19 lakh projects comprising 97 lakh units registered to date) and checks the accuracy of uploaded RERA documents for complete regulatory compliance. With 1.25 lakh complaints resolved and counting, RERA compliance is critical for buyer confidence.',
    features: [
      'RERA number verification across 32 operational State RERAs and authenticity validation',
      'Approval certificate validation for 1.19 lakh registered projects and legal compliance checks',
      'Building compliance review against standards from Registration Bill 2025 and regulatory updates',
      'Project registration status verification with instant access to official RERA databases',
      'Developer compliance monitoring tracking 88,461+ registered real estate agents',
      'RERA document accuracy assessment using AI-powered verification systems',
      'Regulatory requirement guidance for Maharashtra (48,047 projects), Tamil Nadu (19,987 projects), and other states',
      'Ongoing compliance monitoring with updates on regulatory changes and new mandates'
    ],
    benefits: [
      'Complete legal compliance ensuring project legitimacy among 1.19 lakh registered projects nationwide',
      'Enhanced buyer confidence through transparency—critical as India ranked 36th in Global Real Estate Transparency Index',
      'Reduced regulatory risks with verification against official RERA databases across 32 State RERAs',
      'Market credibility boost as RERA improved transparency and strengthened investment inflows',
      'Protection against non-compliant projects—1.25 lakh complaints resolved demonstrate active enforcement',
      'Assurance of legitimate development backed by 97 lakh registered units verification',
      'Peace of mind with verified regulatory status preventing disputes and project delays',
      'Professional guidance through Registration Bill 2025 digital compliance requirements'
    ],
    process: [
      'Comprehensive requirement analysis aligned with state-specific RERA regulations',
      'RERA documentation preparation with verification against 1.19 lakh project database',
      'Official RERA submission support with tracking across 32 State regulatory authorities',
      'Ongoing compliance monitoring as regulations evolve under Registration Bill 2025',
      'Continuous support with monthly regulatory updates and compliance status reports'
    ],
    pricing: 'RERA Verification: ₹2,999 | Full Compliance Package: ₹15,000 | Annual Compliance Monitoring: ₹25,000'
  },
  'property-management': {
    title: 'Property Management Services',
    description: 'Complete Peace of Mind for Owners & NRIs. NAL India manages your property professionally with services designed for NRIs contributing 15-20% of real estate investments (projected to reach 20% by 2025). Our clients report 25-30% higher rent yields and significantly fewer tenant disputes through tech-enabled oversight.',
    features: [
      'Complete tenant management and screening services with KYC verification and background checks',
      'Automated rent collection and payment processing with digital payment integration',
      'Repairs and maintenance coordination with trusted vendor network across 50+ cities',
      'Regular property inspections and condition reports with photo documentation',
      'Legal compliance and regulatory adherence including RERA and local regulations',
      'Detailed account statements and financial reporting with transparent monthly breakdowns',
      'Property health reports and maintenance tracking through digital platforms',
      'Emergency response and 24/7 support services—critical for NRI owners across time zones',
      'Digital vault integration for all property documents with 943 crore+ document ecosystem'
    ],
    benefits: [
      'Ideal solution for NRIs managing properties remotely—supporting 15-20% of investment market',
      'Perfect for investors with multiple property portfolios seeking 25-30% higher rental yields',
      'Excellent for owners living far from their properties with 24/7 digital access',
      'Hassle-free management with professional oversight reducing disputes significantly',
      'Guaranteed regular income with reliable rent collection through automated digital systems',
      'Property value preservation through proper maintenance and timely repairs',
      'Legal protection and compliance assurance with expert support across 50+ cities',
      'Significant time savings and stress reduction—average client satisfaction rate above 90%'
    ],
    process: [
      'Comprehensive property assessment and evaluation with market rate analysis',
      'Detailed service agreement and terms establishment aligned with industry best practices',
      'Professional tenant placement and screening using digital KYC and credit verification',
      'Ongoing property management with monthly inspections and maintenance coordination',
      'Regular reporting with transparent communication through digital dashboard and monthly statements'
    ],
    pricing: 'Standard: 8% of rental income | Premium: 10% of rental income (includes full maintenance) | NRI Special: 12% (24/7 support + legal assistance)'
  },
  'home-insurance': {
    title: 'Home Insurance Assistance',
    description: 'Get help choosing the right protection for your home. NAL connects you with trusted insurance providers and helps with paperwork for comprehensive coverage against various risks. With property values rising and natural disasters increasing, proper insurance is essential for protecting your investment.',
    features: [
      'Comprehensive policy comparison across 15+ leading insurance providers',
      'Coverage assessment for fire and theft protection tailored to property value',
      'Natural disaster coverage evaluation including floods, earthquakes, and cyclones',
      'Structural damage protection planning for building and contents insurance',
      'Professional claim assistance and support throughout the claim process',
      'Policy renewal management with annual optimization and coverage updates',
      'Expert consultation with insurance specialists having 10+ years experience',
      'Paperwork assistance and documentation support ensuring smooth policy activation',
      'Integration with property valuation for accurate sum insured determination'
    ],
    benefits: [
      'Complete protection against fire and accidental damage with comprehensive coverage',
      'Theft and burglary coverage including contents insurance up to declared value',
      'Natural disaster protection crucial in areas prone to floods, earthquakes, and cyclones',
      'Structural damage coverage for building repairs and reconstruction costs',
      'Access to trusted and reliable insurance providers with strong claim settlement ratios',
      'Professional guidance through complex insurance terms and policy exclusions',
      'Hassle-free claim processing with average settlement time of 15-30 days',
      'Peace of mind with comprehensive property protection and 24/7 claim support'
    ],
    process: [
      'Detailed property assessment with valuation for accurate sum insured determination',
      'Comprehensive policy comparison across 15+ providers with coverage and pricing analysis',
      'Optimal coverage selection based on property type, location, and risk factors',
      'Streamlined policy purchase with digital documentation and instant activation',
      'Ongoing support with annual renewal management, claim assistance, and policy optimization'
    ],
    pricing: 'Free consultation | Policy premiums: ₹5,000-₹25,000/year (based on property value and coverage) | Claim assistance: Included in policy'
  }
};

export function ServicePage() {
  const { serviceId } = useParams<{ serviceId: string }>();
  const navigate = useNavigate();
  const service = serviceContent[serviceId || ''];

  if (!service) {
    return (
      <div className="min-h-screen bg-gray-50 flex items-center justify-center">
        <div className="text-center">
          <h1 className="text-2xl font-bold text-gray-900 mb-4">Service Not Found</h1>
          <p className="text-gray-600">The requested service page could not be found.</p>
        </div>
      </div>
    );
  }

  const isDigitalVault = serviceId === 'digital-vault';

  return (
    <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <div className="bg-blue-100 py-16 mt-3">
        <div className="max-w-4xl mx-auto px-4 text-center">
          <h1 className="text-4xl font-bold text-gray-900 mb-4">{service.title}</h1>
          <p className="text-xl text-black mb-8">{service.description}</p>
          {service.pricing && (
            <div className="inline-block bg-blue-600 text-white px-6 py-3 rounded-lg font-semibold text-lg shadow-md">
              {service.pricing}
            </div>
          )}
        </div>
      </div>

      {/* Digital Vault Specific Images Section */}
      {isDigitalVault && (
        <div className="py-16 bg-gray-50">
          <div className="max-w-6xl mx-auto px-4">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">Why Digital Vault Matters</h2>
              <p className="text-lg text-gray-600 max-w-3xl mx-auto">
                Join 3 crore+ digitized property documents in India's secure digital ecosystem. With 943 crore+ documents 
                in DigiLocker and the new Registration Bill 2025 enabling 100% digital property records, digital vaults 
                make documents accessible, secure, and tamper-proof.
              </p>
            </div>
            
            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
              <div className="text-center bg-white p-6 rounded-lg shadow-md">
                <img 
                  src="https://images.unsplash.com/photo-1563013544-824ae1b704d3?w=400&h=300&fit=crop" 
                  alt="Secure Document Storage" 
                  className="w-full h-48 object-cover rounded-lg mb-4"
                />
                <h3 className="text-xl font-semibold text-gray-900 mb-2">Bank-Grade Security</h3>
                <p className="text-gray-600">AES-256 encryption with 95% reduction in document loss/theft</p>
              </div>
              
              <div className="text-center bg-white p-6 rounded-lg shadow-md">
                <img 
                  src="https://images.unsplash.com/photo-1551434678-e076c223a692?w=400&h=300&fit=crop" 
                  alt="Team Collaboration" 
                  className="w-full h-48 object-cover rounded-lg mb-4"
                />
                <h3 className="text-xl font-semibold text-gray-900 mb-2">Global Access for NRIs</h3>
                <p className="text-gray-600">Perfect for NRIs managing 15-20% of real estate investments</p>
              </div>
              
              <div className="text-center bg-white p-6 rounded-lg shadow-md">
                <img 
                  src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=400&h=300&fit=crop" 
                  alt="Digital Organization" 
                  className="w-full h-48 object-cover rounded-lg mb-4"
                />
                <h3 className="text-xl font-semibold text-gray-900 mb-2">AI-Powered Organization</h3>
                <p className="text-gray-600">70% time savings on due diligence with smart categorization</p>
              </div>
            </div>
          </div>
        </div>
      )}

      {/* Service Images Section */}
      {!isDigitalVault && (
        <div className="bg-white py-16">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
              <div className="text-center bg-gray-50 p-6 rounded-lg">
                <img 
                  src={serviceId === 'legal-loan-assistance' 
                    ? 'https://images.unsplash.com/photo-1589829545856-d10d557cf95f?w=400&h=300&fit=crop'
                    : serviceId === 'esign-estamp'
                    ? 'https://images.unsplash.com/photo-1434626881859-194d67b2b86f?w=400&h=300&fit=crop'
                    : serviceId === 'property-valuation'
                    ? 'https://images.unsplash.com/photo-1560518883-ce09059eeffa?w=400&h=300&fit=crop'
                    : serviceId === 'market-analysis'
                    ? 'https://images.unsplash.com/photo-1551288049-bebda4e38f71?w=400&h=300&fit=crop'
                    : serviceId === 'title-search'
                    ? 'https://images.unsplash.com/photo-1436450412740-6b988f486c6b?w=400&h=300&fit=crop'
                    : serviceId === 'rera-compliance'
                    ? 'https://images.unsplash.com/photo-1589994965851-a8f479c573a9?w=400&h=300&fit=crop'
                    : serviceId === 'property-management'
                    ? 'https://images.unsplash.com/photo-1582407947304-fd86f028f716?w=400&h=300&fit=crop'
                    : serviceId === 'home-insurance'
                    ? 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400&h=300&fit=crop'
                    : 'https://images.unsplash.com/photo-1450101499163-c8848c66ca85?w=400&h=300&fit=crop'
                  } 
                  alt="Professional Service" 
                  className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
                />
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  {serviceId === 'legal-loan-assistance' ? 'Legal Expertise'
                    : serviceId === 'esign-estamp' ? 'Digital Signing'
                    : serviceId === 'property-valuation' ? 'AI-Powered Assessment'
                    : serviceId === 'market-analysis' ? 'Market Intelligence'
                    : serviceId === 'title-search' ? 'Legal Verification'
                    : serviceId === 'rera-compliance' ? 'Regulatory Compliance'
                    : serviceId === 'property-management' ? 'Property Care'
                    : serviceId === 'home-insurance' ? 'Insurance Protection'
                    : 'Expert Guidance'
                  }
                </h3>
                <p className="text-gray-600">
                  {serviceId === 'legal-loan-assistance' ? 'Reduce transaction time from 37 to 17 days'
                    : serviceId === 'esign-estamp' ? 'Join 75% of metro transactions going digital'
                    : serviceId === 'property-valuation' ? '93% accuracy with AI-driven analysis'
                    : serviceId === 'market-analysis' ? '95% accuracy in market predictions'
                    : serviceId === 'title-search' ? 'Prevent fraud in 12-18% dispute cases'
                    : serviceId === 'rera-compliance' ? '1.19 lakh projects verified'
                    : serviceId === 'property-management' ? '25-30% higher rental yields'
                    : serviceId === 'home-insurance' ? 'Comprehensive coverage & claim support'
                    : 'Professional assistance from industry experts'
                  }
                </p>
              </div>
              
              <div className="text-center bg-gray-50 p-6 rounded-lg">
                <img 
                  src={serviceId === 'legal-loan-assistance' 
                    ? 'https://images.unsplash.com/photo-1554224155-6726b3ff858f?w=400&h=300&fit=crop'
                    : serviceId === 'esign-estamp'
                    ? 'https://images.unsplash.com/photo-1563013544-824ae1b704d3?w=400&h=300&fit=crop'
                    : serviceId === 'property-valuation'
                    ? 'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=400&h=300&fit=crop'
                    : serviceId === 'market-analysis'
                    ? 'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=400&h=300&fit=crop'
                    : serviceId === 'title-search'
                    ? 'https://images.unsplash.com/photo-1554224155-6726b3ff858f?w=400&h=300&fit=crop'
                    : serviceId === 'rera-compliance'
                    ? 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400&h=300&fit=crop'
                    : serviceId === 'property-management'
                    ? 'https://images.unsplash.com/photo-1551434678-e076c223a692?w=400&h=300&fit=crop'
                    : serviceId === 'home-insurance'
                    ? 'https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=400&h=300&fit=crop'
                    : 'https://images.unsplash.com/photo-1554224155-6726b3ff858f?w=400&h=300&fit=crop'
                  } 
                  alt="Digital Solutions" 
                  className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
                />
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  {serviceId === 'legal-loan-assistance' ? '25+ Bank Partners'
                    : serviceId === 'esign-estamp' ? 'Secure Technology'
                    : serviceId === 'property-valuation' ? 'Data Analytics'
                    : serviceId === 'market-analysis' ? 'Big Data Platform'
                    : serviceId === 'title-search' ? 'Digital Verification'
                    : serviceId === 'rera-compliance' ? '32 State RERAs'
                    : serviceId === 'property-management' ? 'Team Coordination'
                    : serviceId === 'home-insurance' ? 'Risk Assessment'
                    : 'Digital Solutions'
                  }
                </h3>
                <p className="text-gray-600">
                  {serviceId === 'legal-loan-assistance' ? 'Loan approval in 15-20 days vs 45-60 days'
                    : serviceId === 'esign-estamp' ? 'Registration in 1-3 days with Aadhaar verification'
                    : serviceId === 'property-valuation' ? 'Analysis of 500+ parameters across 500+ cities'
                    : serviceId === 'market-analysis' ? '25 lakh+ transactions analyzed annually'
                    : serviceId === 'title-search' ? '30-year history with blockchain validation'
                    : serviceId === 'rera-compliance' ? '97 lakh units registered and verified'
                    : serviceId === 'property-management' ? 'Professional oversight across 50+ cities'
                    : serviceId === 'home-insurance' ? '15+ providers with best claim ratios'
                    : 'Modern technology for seamless transactions'
                  }
                </p>
              </div>
              
              <div className="text-center bg-gray-50 p-6 rounded-lg">
                <img 
                  src={serviceId === 'legal-loan-assistance' 
                    ? 'https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=400&h=300&fit=crop'
                    : serviceId === 'esign-estamp'
                    ? 'https://images.unsplash.com/photo-1551434678-e076c223a692?w=400&h=300&fit=crop'
                    : serviceId === 'property-valuation'
                    ? 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400&h=300&fit=crop'
                    : serviceId === 'market-analysis'
                    ? 'https://images.unsplash.com/photo-1563013544-824ae1b704d3?w=400&h=300&fit=crop'
                    : serviceId === 'title-search'
                    ? 'https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=400&h=300&fit=crop'
                    : serviceId === 'rera-compliance'
                    ? 'https://images.unsplash.com/photo-1551434678-e076c223a692?w=400&h=300&fit=crop'
                    : serviceId === 'property-management'
                    ? 'https://images.unsplash.com/photo-1448630360428-65456885c650?w=400&h=300&fit=crop'
                    : serviceId === 'home-insurance'
                    ? 'https://images.unsplash.com/photo-1551434678-e076c223a692?w=400&h=300&fit=crop'
                    : 'https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=400&h=300&fit=crop'
                  } 
                  alt="Secure Process" 
                  className="w-full h-48 object-cover rounded-lg mb-4 shadow-md"
                />
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  {serviceId === 'legal-loan-assistance' ? 'Fixed Pricing'
                    : serviceId === 'esign-estamp' ? 'NRI-Friendly'
                    : serviceId === 'property-valuation' ? 'Bank-Approved'
                    : serviceId === 'market-analysis' ? 'Predictive AI'
                    : serviceId === 'title-search' ? 'Fraud Prevention'
                    : serviceId === 'rera-compliance' ? 'Regulatory Support'
                    : serviceId === 'property-management' ? 'Peace of Mind'
                    : serviceId === 'home-insurance' ? 'Claim Support'
                    : 'Secure Process'
                  }
                </h3>
                <p className="text-gray-600">
                  {serviceId === 'legal-loan-assistance' ? 'Save ₹50,000-₹2 lakhs with transparent packages'
                    : serviceId === 'esign-estamp' ? 'Perfect for NRIs managing 15-20% investments'
                    : serviceId === 'property-valuation' ? 'Accepted by 50+ lenders for instant approval'
                    : serviceId === 'market-analysis' ? 'Less than 5% margin of error in predictions'
                    : serviceId === 'title-search' ? 'Reduce risk with 30-year verification'
                    : serviceId === 'rera-compliance' ? '1.25 lakh complaints resolved nationwide'
                    : serviceId === 'property-management' ? '24/7 support for remote owners'
                    : serviceId === 'home-insurance' ? 'Average claim settlement in 15-30 days'
                    : 'Bank-grade security for all transactions'
                  }
                </p>
              </div>
            </div>
          </div>
        </div>
      )}

      <div className="max-w-6xl mx-auto px-4 py-16 -mt-6">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Features */}
          <div className="bg-white p-8 rounded-lg border border-gray-200 shadow-sm">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Key Features</h2>
            <ul className="space-y-4">
              {service.features.map((feature, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{feature}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Benefits */}
          <div className="bg-white p-8 rounded-lg border border-gray-200 shadow-sm">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Benefits</h2>
            <ul className="space-y-4">
              {service.benefits.map((benefit, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                  <span className="text-gray-700">{benefit}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Process */}
          <div className="bg-white p-8 rounded-lg border border-gray-200 shadow-sm">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">How It Works</h2>
            <ol className="space-y-4">
              {service.process.map((step, index) => (
                <li key={index} className="flex items-start gap-3">
                  <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">
                    {index + 1}
                  </div>
                  <span className="text-gray-700">{step}</span>
                </li>
              ))}
            </ol>
          </div>
        </div>

        {/* CTA Section */}
        <div className="mt-16 bg-gradient-to-r from-blue-600 to-blue-700 rounded-lg p-8 text-white text-center shadow-lg">
          <h2 className="text-3xl font-bold mb-4">
            {isDigitalVault ? 'Start Your Digital Vault Today' : 'Ready to Get Started?'}
          </h2>
          <p className="text-white/90 mb-8 max-w-2xl mx-auto">
            {isDigitalVault 
              ? 'Join 3 crore+ digitized property documents. Experience enterprise-grade security with our 30-day free trial. No setup fees, no hidden charges.' 
              : `Contact our experts today to learn more about how ${service.title.toLowerCase()} can help you with data-backed insights and professional service.`
            }
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            {isDigitalVault ? (
              <Button 
                onClick={() => navigate('/digital-vault-demo')}
                className="bg-white text-blue-600 hover:bg-gray-100 px-8 py-6 text-lg font-semibold shadow-md"
              >
                Start Free 30-Day Trial
              </Button>
            ) : (
              <>
                <Button 
                  variant="outline" 
                  className="border-2 border-white text-white hover:bg-white/10 px-8 py-3 font-semibold"
                >
                  Schedule Consultation
                </Button>
                <Button 
                  className="bg-white text-blue-600 hover:bg-gray-100 px-8 py-3 font-semibold shadow-md"
                >
                  Get Started Now
                </Button>
              </>
            )}
          </div>
        </div>
      </div>
    </div>
  );
}
