import React from 'react';
import { useParams } from 'react-router-dom';
import { AssetManagementPage } from './AssetManagementPage';
import { SmartLandMapsPage } from './SmartLandMapsPage';
import { ValuationReportsPage } from './ValuationReportsPage';
import { MarketingServicesPage } from './MarketingServicesPage';
import { LeadsProspectsPage } from './LeadsProspectsPage';
import { InvestorsPage } from './InvestorsPage';

export function SolutionsPage() {
  const { solutionId } = useParams<{ solutionId: string }>();

  switch (solutionId) {
    case 'asset-management':
      return <AssetManagementPage />;
    case 'smart-land-maps':
      return <SmartLandMapsPage />;
    case 'valuation-reports':
      return <ValuationReportsPage />;
    case 'marketing-services':
      return <MarketingServicesPage />;
    case 'leads-prospects':
      return <LeadsProspectsPage />;
    case 'investors':
      return <InvestorsPage />;
    default:
      return (
        <div className="min-h-screen bg-gray-50 flex items-center justify-center">
          <div className="text-center">
            <h1 className="text-2xl font-bold text-gray-900 mb-4">Solution Not Found</h1>
            <p className="text-gray-600">The requested solution could not be found.</p>
          </div>
        </div>
      );
  }
}