import React from 'react';
import { BuyerMarketSnapshot } from '../components/buyer-dashboard/BuyerMarketSnapshot';

export const TestBuyerMarketSnapshot: React.FC = () => {
  return (
    <div className="p-8 bg-gray-50 min-h-screen">
      <h1 className="text-2xl font-bold mb-8">Test Buyer Market Snapshot</h1>
      
      {/* Test Full Variant */}
      <div className="mb-8">
        <h2 className="text-lg font-semibold mb-4">Full Variant (for Property Detail Page)</h2>
        <BuyerMarketSnapshot 
          propertyPrice={7500000}
          locality="Whitefield"
          city="Bangalore"
          variant="full"
        />
      </div>

      {/* Test Summary Variant */}
      <div className="mb-8">
        <h2 className="text-lg font-semibold mb-4">Summary Variant (for Dashboard)</h2>
        <BuyerMarketSnapshot 
          propertyPrice={5000000}
          locality="Koramangala"
          city="Bangalore"
          variant="summary"
        />
      </div>

      {/* Test Different Localities */}
      <div className="mb-8">
        <h2 className="text-lg font-semibold mb-4">Different Localities Test</h2>
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
          <BuyerMarketSnapshot 
            propertyPrice={12000000}
            locality="Indiranagar"
            variant="full"
          />
          <BuyerMarketSnapshot 
            propertyPrice={3500000}
            locality="Electronic City"
            variant="full"
          />
        </div>
      </div>
    </div>
  );
};