import React from 'react';
import { Check, Circle } from 'lucide-react';

interface Step {
  id: number;
  title: string;
  description: string;
}

interface StepperProps {
  steps: Step[];
  currentStep: number;
  completedSteps: number[];
  onStepClick?: (stepId: number) => void;
}

export function Stepper({ steps, currentStep, completedSteps, onStepClick }: StepperProps) {
  return (
    <div className="w-full py-6">
      <div className="flex items-center justify-between">
        {steps.map((step, index) => (
          <div key={step.id} className="flex items-center">
            {/* Step Circle */}
            <div className="flex flex-col items-center">
              <div
                className={`w-10 h-10 rounded-full flex items-center justify-center border-2 transition-all duration-200 cursor-pointer hover:scale-110 hover:shadow-lg ${
                  completedSteps.includes(step.id)
                    ? 'bg-green-500 border-green-500 text-white'
                    : currentStep === step.id
                    ? 'bg-[#0056D2] border-[#0056D2] text-white'
                    : 'bg-white border-gray-300 text-gray-400 hover:border-[#0056D2] hover:text-[#0056D2]'
                }`}
                onClick={() => onStepClick && onStepClick(step.id)}
              >
                {completedSteps.includes(step.id) ? (
                  <Check className="w-5 h-5" />
                ) : (
                  <Circle className="w-5 h-5" />
                )}
              </div>
              
              {/* Step Info */}
              <div className="mt-2 text-center">
                <div
                  className={`text-sm font-medium cursor-pointer hover:text-[#0056D2] transition-colors ${
                    currentStep === step.id || completedSteps.includes(step.id)
                      ? 'text-gray-900'
                      : 'text-gray-500'
                  }`}
                  onClick={() => onStepClick && onStepClick(step.id)}
                >
                  {step.title}
                </div>
                <div className="text-xs text-gray-400 mt-1 max-w-24">
                  {step.description}
                </div>
              </div>
            </div>
            
            {/* Connector Line */}
            {index < steps.length - 1 && (
              <div
                className={`flex-1 h-0.5 mx-4 transition-colors ${
                  completedSteps.includes(step.id) && completedSteps.includes(steps[index + 1].id)
                    ? 'bg-green-500'
                    : completedSteps.includes(step.id)
                    ? 'bg-[#0056D2]'
                    : 'bg-gray-300'
                }`}
              />
            )}
          </div>
        ))}
      </div>
    </div>
  );
}