import React from 'react';
import { ContractManagementPage } from './ContractManagement';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { 
  FileText, 
  CheckCircle, 
  Users, 
  Download, 
  Shield,
  ArrowRight,
  Star
} from 'lucide-react';

export const ContractManagementDemo: React.FC = () => {
  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <div className="bg-gradient-to-r from-blue-600 to-blue-800 text-white py-12">
        <div className="max-w-7xl mx-auto px-6">
          <div className="text-center">
            <h1 className="text-4xl font-bold mb-4">
              Digital Contract Management System
            </h1>
            <p className="text-xl text-blue-100 mb-8">
              Complete contract lifecycle management with authentic e-stamp paper generation
            </p>
            <div className="flex justify-center gap-4 flex-wrap">
              <Badge className="bg-white text-blue-800 px-4 py-2 text-sm">
                <CheckCircle className="w-4 h-4 mr-2" />
                Digital Signatures
              </Badge>
              <Badge className="bg-white text-blue-800 px-4 py-2 text-sm">
                <FileText className="w-4 h-4 mr-2" />
                E-Stamp Papers
              </Badge>
              <Badge className="bg-white text-blue-800 px-4 py-2 text-sm">
                <Shield className="w-4 h-4 mr-2" />
                Legal Compliance
              </Badge>
            </div>
          </div>
        </div>
      </div>

      {/* Features Overview */}
      <div className="py-12 bg-white">
        <div className="max-w-7xl mx-auto px-6">
          <h2 className="text-3xl font-bold text-center text-gray-900 mb-12">
            How It Works
          </h2>
          
          <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
            <div className="text-center">
              <div className="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <FileText className="w-8 h-8 text-blue-600" />
              </div>
              <h3 className="text-lg font-semibold mb-2">1. Create Contract</h3>
              <p className="text-gray-600">Draft your property sale agreement with all necessary details</p>
            </div>
            
            <div className="text-center">
              <div className="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <Users className="w-8 h-8 text-yellow-600" />
              </div>
              <h3 className="text-lg font-semibold mb-2">2. Digital Signing</h3>
              <p className="text-gray-600">Both buyer and seller sign digitally using e-signature pad</p>
            </div>
            
            <div className="text-center">
              <div className="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <Shield className="w-8 h-8 text-green-600" />
              </div>
              <h3 className="text-lg font-semibold mb-2">3. Stamp Paper Generation</h3>
              <p className="text-gray-600">Authentic Indian e-stamp paper is automatically generated</p>
            </div>
            
            <div className="text-center">
              <div className="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <Download className="w-8 h-8 text-purple-600" />
              </div>
              <h3 className="text-lg font-semibold mb-2">4. Download & Use</h3>
              <p className="text-gray-600">Download the legally valid stamp paper for your records</p>
            </div>
          </div>
        </div>
      </div>

      {/* Sample Contract Status */}
      <div className="py-12 bg-gray-50">
        <div className="max-w-4xl mx-auto px-6">
          <h2 className="text-2xl font-bold text-center text-gray-900 mb-8">
            Sample Contract Journey
          </h2>
          
          <div className="space-y-4">
            <Card className="border-l-4 border-l-blue-500">
              <CardContent className="p-6">
                <div className="flex items-center justify-between">
                  <div>
                    <h3 className="font-semibold text-gray-900">Property sale agreement</h3>
                    <p className="text-sm text-gray-600">Contract ID: 6 • Created: Jan 9, 2026</p>
                  </div>
                  <Badge className="bg-green-100 text-green-800">
                    <CheckCircle className="w-4 h-4 mr-1" />
                    Contract signed by all parties
                  </Badge>
                </div>
                <div className="mt-4 flex gap-2">
                  <Badge variant="outline">Property Sale</Badge>
                  <Badge variant="outline">2BHK</Badge>
                  <Badge variant="outline">₹45,00,000</Badge>
                </div>
              </CardContent>
            </Card>

            <div className="flex justify-center">
              <ArrowRight className="w-6 h-6 text-gray-400" />
            </div>

            <Card className="border-l-4 border-l-green-500 bg-green-50">
              <CardContent className="p-6">
                <div className="flex items-center gap-3 mb-4">
                  <Shield className="w-6 h-6 text-green-600" />
                  <h3 className="font-semibold text-green-900">E-Stamp Paper Generated</h3>
                  <Badge className="bg-green-600 text-white">
                    <Star className="w-3 h-3 mr-1" />
                    Ready
                  </Badge>
                </div>
                <div className="grid grid-cols-2 gap-4 text-sm">
                  <div>
                    <span className="font-medium">Certificate Number:</span>
                    <p className="text-gray-700">EST-KA-20260109-000006</p>
                  </div>
                  <div>
                    <span className="font-medium">Stamp Duty:</span>
                    <p className="text-gray-700">₹22,500.00</p>
                  </div>
                </div>
                <div className="mt-4 flex gap-2">
                  <button className="px-4 py-2 bg-green-600 text-white rounded-md text-sm hover:bg-green-700 flex items-center gap-2">
                    <Download className="w-4 h-4" />
                    Download Stamp Paper
                  </button>
                  <button className="px-4 py-2 border border-green-600 text-green-600 rounded-md text-sm hover:bg-green-50">
                    View Details
                  </button>
                </div>
              </CardContent>
            </Card>
          </div>
        </div>
      </div>

      {/* Main Contract Management Interface */}
      <ContractManagementPage />

      {/* Footer */}
      <div className="bg-gray-900 text-white py-8">
        <div className="max-w-7xl mx-auto px-6 text-center">
          <p className="text-gray-400">
            © 2025 NAL India - Digital Contract Management System with E-Stamp Integration
          </p>
          <p className="text-sm text-gray-500 mt-2">
            All e-stamp papers are generated in compliance with Indian Stamp Act and have full legal validity
          </p>
        </div>
      </div>
    </div>
  );
};