import React from 'react';
import { useNavigate } from 'react-router-dom';
import { CheckCircle, Megaphone, Target, BarChart2, Users, Video, Globe } from 'lucide-react';
import { Button } from '../../components/ui/button';

export function DigitalMarketingServices() {
  const navigate = useNavigate();

  return (
    <>
      <style>{`
        .digital-marketing-hero {
          background: linear-gradient(135deg, #0f172a 0%, #0b4d4d 55%, #0f766e 100%) !important;
          padding: 6rem 0 !important;
          color: white !important;
          text-align: center !important;
        }
        .digital-marketing-hero h1 {
          font-size: 3.4rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.25rem !important;
          letter-spacing: -0.03em !important;
        }
        .digital-marketing-hero p {
          font-size: 1.2rem !important;
          margin-bottom: 2.25rem !important;
          color: #dbeafe !important;
          max-width: 56rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
          line-height: 1.7 !important;
        }
        .digital-marketing-pill {
          background: rgba(255, 255, 255, 0.15) !important;
          border: 1px solid rgba(255, 255, 255, 0.2) !important;
          padding: 0.75rem 1.5rem !important;
          border-radius: 999px !important;
          display: inline-block !important;
          font-weight: 600 !important;
          letter-spacing: 0.02em !important;
        }
        .digital-marketing-section {
          padding: 4.5rem 1rem !important;
          background: #ffffff !important;
        }
        .digital-marketing-section.alt {
          background: #f8fafc !important;
        }
        .digital-marketing-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)) !important;
          gap: 1.75rem !important;
          max-width: 80rem !important;
          margin: 0 auto !important;
        }
        .digital-marketing-card {
          background: #ffffff !important;
          border-radius: 0.9rem !important;
          padding: 2rem !important;
          border: 1px solid #e2e8f0 !important;
          box-shadow: 0 10px 20px rgba(15, 23, 42, 0.04) !important;
          transition: transform 0.25s ease, box-shadow 0.25s ease !important;
        }
        .digital-marketing-card:hover {
          transform: translateY(-4px) !important;
          box-shadow: 0 18px 30px rgba(15, 23, 42, 0.1) !important;
        }
        .digital-marketing-card h3 {
          font-size: 1.2rem !important;
          font-weight: 700 !important;
          margin-bottom: 0.6rem !important;
          color: #0f172a !important;
        }
        .digital-marketing-card p {
          color: #475569 !important;
          line-height: 1.6 !important;
        }
        .digital-marketing-icon {
          width: 3rem !important;
          height: 3rem !important;
          border-radius: 0.75rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
          margin-bottom: 1rem !important;
          background: #e0f2fe !important;
          color: #0ea5e9 !important;
        }
        .digital-marketing-logo-wrap {
          width: 3rem !important;
          height: 3rem !important;
          border-radius: 0.75rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
          margin-bottom: 1rem !important;
          background: #ffffff !important;
          border: 1px solid #e2e8f0 !important;
        }
        .digital-marketing-logo {
          width: 2.25rem !important;
          height: 2.25rem !important;
          object-fit: contain !important;
        }
        .digital-marketing-section h2 {
          font-size: 2.4rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 2.5rem !important;
          color: #0f172a !important;
          letter-spacing: -0.02em !important;
        }
        .digital-marketing-list {
          max-width: 70rem !important;
          margin: 0 auto !important;
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)) !important;
          gap: 1.5rem !important;
        }
        .digital-marketing-list li {
          display: flex !important;
          align-items: flex-start !important;
          gap: 0.75rem !important;
          color: #1e293b !important;
          font-size: 1rem !important;
          line-height: 1.6 !important;
        }
        .digital-marketing-cta {
          background: #0f172a !important;
          color: white !important;
          padding: 4rem 1rem !important;
          text-align: center !important;
        }
        .digital-marketing-cta h2 {
          font-size: 2.2rem !important;
          font-weight: 700 !important;
          margin-bottom: 1rem !important;
        }
        .digital-marketing-cta p {
          max-width: 48rem !important;
          margin: 0 auto 2rem auto !important;
          color: #cbd5f5 !important;
        }
      `}</style>

      <section className="digital-marketing-hero">
        <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="digital-marketing-pill">Digital Marketing Services</div>
          <h1>Promote Seller & Agent Listings Across Google, Meta, Instagram, and More</h1>
          <p>
            Drive qualified leads for property listings with high-intent search ads, social campaigns,
            and performance creative built for real estate. We design, run, and optimize campaigns that
            convert interest into site visits and calls.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button
              className="bg-white text-slate-900 hover:bg-slate-100 px-8 py-3"
              onClick={() => navigate('/solutions/marketing-services')}
            >
              Request Campaign Plan
            </Button>
            <Button
              variant="outline"
              className="border-white text-white hover:bg-white hover:text-slate-900 px-8 py-3"
              onClick={() => navigate('/contact')}
            >
              Talk to an Expert
            </Button>
          </div>
        </div>
      </section>

      <section className="digital-marketing-section" style={{ paddingBottom: '2.25rem' }}>
        <h2>Channels We Activate</h2>
        <div className="digital-marketing-grid gap-10">
          <div className="digital-marketing-card">
            <div className="digital-marketing-icon"><Globe className="w-6 h-6" /></div>
            <h3>Google Search & Display</h3>
            <p>High-intent search ads and remarketing to capture buyers actively exploring listings.</p>
          </div>
          <div className="digital-marketing-card">
            <div className="digital-marketing-icon"><Users className="w-6 h-6" /></div>
            <h3>Meta (Facebook + Instagram)</h3>
            <p>Audience targeting by location, interest, income bands, and lookalike buyers.</p>
          </div>
          <div className="digital-marketing-card">
            <div className="digital-marketing-icon"><Video className="w-6 h-6" /></div>
            <h3>Reels & Video Ads</h3>
            <p>Short-form video creatives that showcase listings, amenities, and neighborhood highlights.</p>
          </div>
          <div className="digital-marketing-card">
            <div className="digital-marketing-icon"><Megaphone className="w-6 h-6" /></div>
            <h3>Lead Generation Forms</h3>
            <p>Instant lead capture with pre-filled forms and WhatsApp/call-to-lead routing.</p>
          </div>
        </div>
      </section>

      <section className="digital-marketing-section alt">
        <h2>What Sellers & Agents Get</h2>
        <ul className="digital-marketing-list">
          <li><CheckCircle className="w-5 h-5 text-emerald-500 mt-1" />Dedicated campaigns for each listing with custom creatives and targeting.</li>
          <li><CheckCircle className="w-5 h-5 text-emerald-500 mt-1" />Ad budgets optimized daily to reduce cost per lead and improve lead quality.</li>
          <li><CheckCircle className="w-5 h-5 text-emerald-500 mt-1" />Landing pages with property highlights, inquiry forms, and call-to-action.</li>
          <li><CheckCircle className="w-5 h-5 text-emerald-500 mt-1" />Lead routing to WhatsApp, call center, or agent CRM in real time.</li>
          <li><CheckCircle className="w-5 h-5 text-emerald-500 mt-1" />Weekly performance reports: CPL, CTR, leads/day, and conversion rates.</li>
          <li><CheckCircle className="w-5 h-5 text-emerald-500 mt-1" />Audience retargeting to re-engage visitors and boost site visits.</li>
        </ul>
      </section>

      <section className="digital-marketing-section">
        <h2>Quick Links</h2>
        <div className="digital-marketing-grid">
          <a
            className="digital-marketing-card"
            href="https://ads.google.com/"
            target="_blank"
            rel="noreferrer"
          >
            <div className="digital-marketing-logo-wrap">
              <img
                className="digital-marketing-logo"
                src="https://cdn.simpleicons.org/googleads"
                alt="Google Ads logo"
              />
            </div>
            <h3>Google Ads</h3>
            <p>Launch search and display campaigns for high-intent property buyers.</p>
          </a>
          <a
            className="digital-marketing-card"
            href="https://www.facebook.com/business/ads"
            target="_blank"
            rel="noreferrer"
          >
            <div className="digital-marketing-logo-wrap">
              <img
                className="digital-marketing-logo"
                src="https://cdn.simpleicons.org/meta"
                alt="Meta logo"
              />
            </div>
            <h3>Meta Ads (Facebook/Instagram)</h3>
            <p>Create lead campaigns and retarget visitors on Facebook and Instagram.</p>
          </a>
          <a
            className="digital-marketing-card"
            href="https://advertising.amazon.com/"
            target="_blank"
            rel="noreferrer"
          >
            <div className="digital-marketing-logo-wrap">
              <img
                className="digital-marketing-logo"
                src="https://images.seeklogo.com/logo-png/48/1/amazon-ads-logo-png_seeklogo-485907.png"
                alt="Amazon Ads logo"
              />
            </div>
            <h3>Amazon Ads</h3>
            <p>Expand reach with Amazon DSP and display ads for brand visibility.</p>
          </a>
          <a
            className="digital-marketing-card"
            href="https://www.instagram.com/"
            target="_blank"
            rel="noreferrer"
          >
            <div className="digital-marketing-logo-wrap">
              <img
                className="digital-marketing-logo"
                src="https://cdn.simpleicons.org/instagram"
                alt="Instagram logo"
              />
            </div>
            <h3>Instagram</h3>
            <p>Showcase listings with reels, stories, and high-quality visuals.</p>
          </a>
          <a
            className="digital-marketing-card"
            href="https://www.facebook.com/"
            target="_blank"
            rel="noreferrer"
          >
            <div className="digital-marketing-logo-wrap">
              <img
                className="digital-marketing-logo"
                src="https://cdn.simpleicons.org/facebook"
                alt="Facebook logo"
              />
            </div>
            <h3>Facebook</h3>
            <p>Build neighborhood-level audiences and capture qualified leads.</p>
          </a>
          <a
            className="digital-marketing-card"
            href="https://www.youtube.com/"
            target="_blank"
            rel="noreferrer"
          >
            <div className="digital-marketing-logo-wrap">
              <img
                className="digital-marketing-logo"
                src="https://cdn.simpleicons.org/youtube"
                alt="YouTube logo"
              />
            </div>
            <h3>YouTube</h3>
            <p>Run video tours and discovery ads to boost listing visibility.</p>
          </a>
          <a
            className="digital-marketing-card"
            href="https://www.linkedin.com/"
            target="_blank"
            rel="noreferrer"
          >
            <div className="digital-marketing-logo-wrap">
              <img
                className="digital-marketing-logo"
                src="https://logo.svgcdn.com/logos/linkedin.png"
                alt="LinkedIn logo"
              />
            </div>
            <h3>LinkedIn</h3>
            <p>Reach working professionals and investors with targeted campaigns.</p>
          </a>
          <a
            className="digital-marketing-card"
            href="https://twitter.com/"
            target="_blank"
            rel="noreferrer"
          >
            <div className="digital-marketing-logo-wrap">
              <img
                className="digital-marketing-logo"
                src="https://cdn.simpleicons.org/x"
                alt="X (Twitter) logo"
              />
            </div>
            <h3>X (Twitter)</h3>
            <p>Share listings fast with real-time updates and community reach.</p>
          </a>
        </div>
        <div className="mt-12 mb-0 flex justify-center">
          <Button
            className="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-base font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg]:size-5 [&_svg]:shrink-0 h-12 px-6 py-3 bg-[#0056D2] hover:bg-[#0056D2]/90 text-white min-w-[280px]"
            onClick={() => {
              const links = [
                'https://ads.google.com/',
                'https://www.facebook.com/business/ads',
                'https://advertising.amazon.com/',
                'https://www.instagram.com/',
                'https://www.facebook.com/',
                'https://www.youtube.com/',
                'https://www.linkedin.com/',
                'https://twitter.com/',
              ];
              links.forEach((link) => window.open(link, '_blank', 'noopener,noreferrer'));
            }}
          >
            Post Now
          </Button>
        </div>
      </section>

      <section className="digital-marketing-section">
        <h2>Campaign Objectives</h2>
        <div className="digital-marketing-grid">
          <div className="digital-marketing-card">
            <div className="digital-marketing-icon"><Target className="w-6 h-6" /></div>
            <h3>Lead Generation</h3>
            <p>Capture buyer inquiries for ready-to-move, resale, and new launches.</p>
          </div>
          <div className="digital-marketing-card">
            <div className="digital-marketing-icon"><BarChart2 className="w-6 h-6" /></div>
            <h3>Visibility & Awareness</h3>
            <p>Increase listing views, brand recall, and local market visibility.</p>
          </div>
          <div className="digital-marketing-card">
            <div className="digital-marketing-icon"><Megaphone className="w-6 h-6" /></div>
            <h3>Open House Promotions</h3>
            <p>Drive walk-ins for site visits and scheduled open house events.</p>
          </div>
        </div>
      </section>

      <section className="digital-marketing-cta">
        <h2>Launch Your Next Property Campaign</h2>
        <p>
          Tell us the listing details, location, and budget. We’ll build a targeted campaign plan across
          Google, Meta, and Instagram with creatives designed to convert.
        </p>
        <Button
          className="bg-white text-slate-900 hover:bg-slate-100 px-8 py-3"
          onClick={() => navigate('/solutions/marketing-services')}
        >
          Get a Custom Quote
        </Button>
      </section>
    </>
  );
}
