import React from 'react';
import { useNavigate } from 'react-router-dom';
import { CheckCircle, FileText, Shield, Globe, Clock, Users } from 'lucide-react';
import { Button } from '../../components/ui/button';

export function ESignEStamp() {
  const navigate = useNavigate();

  return (
    <>
      <style>{`
        .esign-hero {
          background: linear-gradient(135deg, #1e293b 0%, #334155 100%) !important;
          padding: 6rem 0 !important;
          color: white !important;
          text-align: center !important;
        }
        .esign-hero h1 {
          font-size: 3.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .esign-hero p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          max-width: 50rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
          line-height: 1.7 !important;
        }
        .esign-pricing {
          background: rgba(255, 255, 255, 0.95) !important;
          color: #1e293b !important;
          padding: 1.25rem 2.5rem !important;
          border-radius: 0.75rem !important;
          font-weight: 600 !important;
          font-size: 1rem !important;
          display: inline-block !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
        }
        .esign-stats {
          padding: 4rem 1rem !important;
          background: white !important;
        }
        .esign-stat-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .esign-stat-card {
          background: #f8fafc !important;
          padding: 2.5rem !important;
          border-radius: 0.75rem !important;
          text-align: center !important;
          border: 1px solid #e2e8f0 !important;
          transition: all 0.3s ease !important;
        }
        .esign-stat-card:hover {
          transform: translateY(-0.125rem) !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1) !important;
        }
        .esign-stat-card h3 {
          font-size: 1.375rem !important;
          font-weight: 600 !important;
          margin-bottom: 1rem !important;
          color: #1e293b !important;
        }
        .esign-stat-card p {
          color: #64748b !important;
        }
        .esign-content {
          padding: 5rem 1rem !important;
          background: #f8fafc !important;
        }
        .esign-content h2 {
          font-size: 2.5rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .esign-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 80rem !important;
          margin: 0 auto !important;
        }
        .esign-card {
          background: white !important;
          padding: 2.5rem !important;
          border-radius: 0.75rem !important;
          box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important;
          border: 1px solid #e2e8f0 !important;
          transition: all 0.3s ease !important;
        }
        .esign-card:hover {
          transform: translateY(-0.125rem) !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1) !important;
        }
        .esign-card h2 {
          font-size: 1.5rem !important;
          font-weight: 600 !important;
          margin-bottom: 1.5rem !important;
          color: #1e293b !important;
        }
        .esign-list {
          list-style: none !important;
          padding: 0 !important;
        }
        .esign-list li {
          display: flex !important;
          align-items: flex-start !important;
          gap: 0.75rem !important;
          margin-bottom: 1rem !important;
        }
        .esign-check {
          background: #dcfce7 !important;
          border-radius: 50% !important;
          padding: 0.25rem !important;
          width: 1.5rem !important;
          height: 1.5rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
          flex-shrink: 0 !important;
          margin-top: 0.125rem !important;
        }
        .esign-check::after {
          content: '✓' !important;
          color: #059669 !important;
          font-weight: bold !important;
          font-size: 0.75rem !important;
        }
        .esign-text {
          color: #475569 !important;
          line-height: 1.6 !important;
        }
        .esign-cta {
          padding: 5rem 1rem !important;
          background: #1e293b !important;
          color: white !important;
          text-align: center !important;
        }
        .esign-cta-card {
          background: #334155 !important;
          border-radius: 1rem !important;
          padding: 4rem !important;
          max-width: 50rem !important;
          margin: 0 auto !important;
        }
        .esign-cta h2 {
          font-size: 2.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .esign-cta p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          line-height: 1.6 !important;
        }
        .esign-buttons {
          display: flex !important;
          flex-direction: column !important;
          gap: 1rem !important;
          align-items: center !important;
        }
        @media (min-width: 640px) {
          .esign-buttons {
            flex-direction: row !important;
            justify-content: center !important;
          }
        }
        .esign-btn-primary {
          background: white !important;
          color: #1e293b !important;
          padding: 1rem 2.5rem !important;
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          border-radius: 0.5rem !important;
          box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1) !important;
          transition: all 0.3s ease !important;
          border: none !important;
          cursor: pointer !important;
        }
        .esign-btn-primary:hover {
          transform: translateY(-0.125rem) !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
        }
        .esign-btn-secondary {
          background: transparent !important;
          color: white !important;
          padding: 1rem 2.5rem !important;
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          border-radius: 0.5rem !important;
          border: 2px solid white !important;
          transition: all 0.3s ease !important;
          cursor: pointer !important;
        }
        .esign-btn-secondary:hover {
          background: white !important;
          color: #1e293b !important;
        }
      `}</style>
      <div className="min-h-screen bg-slate-50">
      {/* Hero Section */}
      <div className="esign-hero">
        <div style={{ maxWidth: '64rem', margin: '0 auto', padding: '0 1rem' }}>
          <h1>
            E-sign & E-stamp Services
          </h1>
          <p>
            Go Paperless. Go Faster. Join the 75% of metro property transactions now completed digitally. 
            NAL India enables secure, legally valid digital signatures and online stamping, reducing 
            processing time by 60-80%.
          </p>
          <div className="esign-pricing">
            E-sign: ₹199 per document | E-stamp: ₹299 + govt charges | Combined: ₹399
          </div>
        </div>
      </div>

      {/* Stats Section */}
      <div className="esign-stats">
        <div className="esign-stat-grid">
          <div className="esign-stat-card">
            <h3>Digital Signing</h3>
            <p>Join 75% of metro transactions going digital with legally binding e-signatures</p>
          </div>
          <div className="esign-stat-card">
            <h3>Secure Technology</h3>
            <p>Registration in 1-3 days with Aadhaar verification and bank-grade security</p>
          </div>
          <div className="esign-stat-card">
            <h3>NRI-Friendly</h3>
            <p>Perfect for NRIs managing 15-20% of real estate investments remotely</p>
          </div>
        </div>
      </div>

      {/* Content Section */}
      <div className="esign-content">
        <h2>Complete Digital Solution</h2>
        <div className="esign-grid">
          {/* Features */}
          <div className="esign-card">
            <h2>Key Features</h2>
            <ul className="esign-list">
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">Digital signing for booking forms and offer letters with legally binding e-signatures under IT Act 2000</span>
              </li>
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">E-stamp services for rent agreements and sale agreements compliant with Registration Bill 2025</span>
              </li>
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">Secure signing of NOCs and legal declarations with Aadhaar-based authentication</span>
              </li>
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">Multi-party digital signature coordination supporting NRI transactions with global access</span>
              </li>
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">Legally binding document authentication accepted by all major banks and NBFCs</span>
              </li>
            </ul>
          </div>

          {/* Benefits */}
          <div className="esign-card">
            <h2>Benefits</h2>
            <ul className="esign-list">
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">Legally binding documents with full legal validity under IT Act 2000 and Registration Bill 2025</span>
              </li>
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">Significant time savings—complete registration in 1-3 days vs traditional 7-15 days processing</span>
              </li>
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">Perfect solution for NRIs managing 15-20% of real estate investments remotely</span>
              </li>
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">Eliminates the need for physical presence during signing—crucial for cross-border transactions</span>
              </li>
              <li>
                <div className="esign-check"></div>
                <span className="esign-text">Enhanced security with Aadhaar-based digital authentication preventing identity fraud</span>
              </li>
            </ul>
          </div>

          {/* Process */}
          <div className="esign-card">
            <h2>How It Works</h2>
            <ul className="esign-list">
              <li>
                <div style={{ background: '#1e293b', color: 'white', borderRadius: '0.5rem', width: '2rem', height: '2rem', display: 'flex', alignItems: 'center', justifyContent: 'center', fontWeight: 'bold', fontSize: '0.875rem', flexShrink: 0, marginTop: '0.125rem' }}>1</div>
                <span className="esign-text">Upload your documents to our secure platform with bank-grade AES-256 encryption</span>
              </li>
              <li>
                <div style={{ background: '#1e293b', color: 'white', borderRadius: '0.5rem', width: '2rem', height: '2rem', display: 'flex', alignItems: 'center', justifyContent: 'center', fontWeight: 'bold', fontSize: '0.875rem', flexShrink: 0, marginTop: '0.125rem' }}>2</div>
                <span className="esign-text">Add all required signatories with Aadhaar verification and their contact details</span>
              </li>
              <li>
                <div style={{ background: '#1e293b', color: 'white', borderRadius: '0.5rem', width: '2rem', height: '2rem', display: 'flex', alignItems: 'center', justifyContent: 'center', fontWeight: 'bold', fontSize: '0.875rem', flexShrink: 0, marginTop: '0.125rem' }}>3</div>
                <span className="esign-text">Generate appropriate e-stamps compliant with state-specific Registration Bill 2025 rates</span>
              </li>
              <li>
                <div style={{ background: '#1e293b', color: 'white', borderRadius: '0.5rem', width: '2rem', height: '2rem', display: 'flex', alignItems: 'center', justifyContent: 'center', fontWeight: 'bold', fontSize: '0.875rem', flexShrink: 0, marginTop: '0.125rem' }}>4</div>
                <span className="esign-text">Coordinate digital signing by all parties with real-time tracking and notifications</span>
              </li>
              <li>
                <div style={{ background: '#1e293b', color: 'white', borderRadius: '0.5rem', width: '2rem', height: '2rem', display: 'flex', alignItems: 'center', justifyContent: 'center', fontWeight: 'bold', fontSize: '0.875rem', flexShrink: 0, marginTop: '0.125rem' }}>5</div>
                <span className="esign-text">Download completed legally valid documents with blockchain-backed certificate</span>
              </li>
            </ul>
          </div>
        </div>
      </div>

      {/* CTA Section */}
      <div className="esign-cta">
        <div className="esign-cta-card">
          <h2>Ready to Go Digital?</h2>
          <p>
            Join thousands of property owners who have streamlined their transactions with our secure 
            e-sign and e-stamp services. Get started today with expert guidance.
          </p>
          <div className="esign-buttons">
            <Button className="esign-btn-secondary">
              Schedule Consultation
            </Button>
            <Button className="esign-btn-primary">
              Get Started Now
            </Button>
          </div>
        </div>
      </div>
      </div>
    </>
  );
}