import React from 'react';
import { FileSignature, Shield, Clock, ArrowRight } from 'lucide-react';
import { Button } from '../../components/ui/button';
import { useNavigate } from 'react-router-dom';

export function ESignEStampServices() {
  const navigate = useNavigate();

  return (
    <>
      <style>{`
        .esign-hero {
          background: linear-gradient(rgba(30, 41, 59, 0.9), rgba(30, 41, 59, 0.8)), url('https://images.unsplash.com/photo-1450101499163-c8848c66ca85?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80') !important;
          background-size: cover !important;
          background-position: center !important;
          padding: 8rem 0 !important;
          color: white !important;
          text-align: center !important;
        }
        .esign-hero h1 {
          font-size: 3.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .esign-hero p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          max-width: 50rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
          line-height: 1.7 !important;
        }
        .esign-pricing {
          background: rgba(255, 255, 255, 0.95) !important;
          color: #1e293b !important;
          padding: 1.5rem 3rem !important;
          border-radius: 1rem !important;
          font-weight: 600 !important;
          font-size: 1.1rem !important;
          display: inline-block !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1) !important;
          backdrop-filter: blur(10px) !important;
        }
        .esign-features {
          padding: 6rem 2rem !important;
          background: #f8fafc !important;
        }
        .esign-features h2 {
          font-size: 2.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .esign-feature-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .esign-feature-card {
          background: white !important;
          padding: 0 !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          text-align: center !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
          overflow: hidden !important;
        }
        .esign-feature-image {
          width: 100% !important;
          height: 200px !important;
          object-fit: cover !important;
        }
        .esign-feature-content {
          padding: 2rem !important;
        }
        .esign-feature-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
          border-color: #cbd5e1 !important;
        }
        .esign-feature-card h3 {
          font-size: 1.5rem !important;
          font-weight: 600 !important;
          margin-bottom: 1rem !important;
          color: #1e293b !important;
        }
        .esign-feature-card p {
          color: #64748b !important;
          line-height: 1.7 !important;
          font-size: 1rem !important;
        }
        .esign-benefits {
          padding: 6rem 2rem !important;
          background: white !important;
        }
        .esign-benefits h2 {
          font-size: 2.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .esign-benefit-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .esign-benefit-card {
          background: #f8fafc !important;
          padding: 3rem !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
        }
        .esign-benefit-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
        }
        .esign-benefit-card h3 {
          font-size: 1.625rem !important;
          font-weight: 600 !important;
          margin-bottom: 1.5rem !important;
          color: #1e293b !important;
        }
        .esign-benefit-list {
          list-style: none !important;
          padding: 0 !important;
        }
        .esign-benefit-item {
          display: flex !important;
          align-items: center !important;
          gap: 0.75rem !important;
          margin-bottom: 0.75rem !important;
        }
        .esign-benefit-icon {
          background: #dcfce7 !important;
          border-radius: 50% !important;
          padding: 0.25rem !important;
          width: 1.5rem !important;
          height: 1.5rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
        }
        .esign-benefit-icon::after {
          content: '✓' !important;
          color: #059669 !important;
          font-weight: bold !important;
          font-size: 0.75rem !important;
        }
        .esign-benefit-text {
          color: #475569 !important;
          line-height: 1.7 !important;
          font-size: 1rem !important;
        }
        .esign-cta {
          padding: 8rem 2rem !important;
          background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #334155 100%) !important;
          color: white !important;
          text-align: center !important;
          position: relative !important;
          overflow: hidden !important;
        }
        .esign-cta::before {
          content: '' !important;
          position: absolute !important;
          top: 0 !important;
          left: 0 !important;
          right: 0 !important;
          bottom: 0 !important;
          background: radial-gradient(circle at 30% 20%, rgba(59, 130, 246, 0.1) 0%, transparent 50%), radial-gradient(circle at 70% 80%, rgba(16, 185, 129, 0.1) 0%, transparent 50%) !important;
        }
        .esign-cta-card {
          background: rgba(255, 255, 255, 0.05) !important;
          backdrop-filter: blur(20px) !important;
          border: 1px solid rgba(255, 255, 255, 0.1) !important;
          border-radius: 2rem !important;
          padding: 4rem !important;
          max-width: 50rem !important;
          margin: 0 auto !important;
          position: relative !important;
          box-shadow: 0 25px 50px rgba(0, 0, 0, 0.25) !important;
        }
        .esign-cta h2 {
          font-size: 2.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .esign-cta p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          line-height: 1.6 !important;
        }
        .esign-cta-button {
          background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%) !important;
          color: white !important;
          padding: 1.25rem 3rem !important;
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          border-radius: 12px !important;
          box-shadow: 0 8px 25px rgba(30, 41, 59, 0.25) !important;
          transition: all 0.3s ease !important;
          border: none !important;
          cursor: pointer !important;
          position: relative !important;
          overflow: hidden !important;
        }
        .esign-cta-button:hover {
          transform: translateY(-2px) !important;
          box-shadow: 0 12px 35px rgba(30, 41, 59, 0.35) !important;
          background: linear-gradient(135deg, #334155 0%, #1e293b 100%) !important;
        }
        .esign-cta-button::before {
          content: '' !important;
          position: absolute !important;
          top: 0 !important;
          left: -100% !important;
          width: 100% !important;
          height: 100% !important;
          background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent) !important;
          transition: left 0.5s !important;
        }
        .esign-cta-button:hover::before {
          left: 100% !important;
        }
        .esign-integration {
          padding: 6rem 2rem !important;
          background: white !important;
        }
        .esign-integration h2 {
          font-size: 2.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .esign-integration-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .esign-integration-card {
          background: #f8fafc !important;
          padding: 3rem !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
        }
        .esign-integration-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
        }
        .esign-integration-card h3 {
          font-size: 1.625rem !important;
          font-weight: 600 !important;
          margin-bottom: 1.5rem !important;
          color: #1e293b !important;
        }
        .esign-integration-list {
          list-style: none !important;
          padding: 0 !important;
        }
        .esign-integration-item {
          display: flex !important;
          align-items: center !important;
          gap: 0.75rem !important;
          margin-bottom: 0.75rem !important;
        }
        .esign-integration-icon {
          background: #dbeafe !important;
          border-radius: 50% !important;
          padding: 0.25rem !important;
          width: 1.5rem !important;
          height: 1.5rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
        }
        .esign-integration-icon::after {
          content: '✓' !important;
          color: #2563eb !important;
          font-weight: bold !important;
          font-size: 0.75rem !important;
        }
        .esign-integration-text {
          color: #475569 !important;
          line-height: 1.7 !important;
          font-size: 1rem !important;
        }
      `}</style>
      <div className="min-h-screen bg-white">
        {/* Hero Section */}
        <header className="esign-hero">
          <div>
            <h1>E-sign & E-stamp Services</h1>
            <p>
              Complete digital signing and stamping solutions for property transactions. ISO 27001 certified platform with legally valid, secure, and instant processing capabilities.
            </p>
            <div className="esign-pricing">
              E-sign: ₹149/document | E-stamp: ₹299/document | Combo Package: ₹399 (Save ₹49) | Enterprise: Custom pricing
            </div>
          </div>
        </header>

        {/* Benefits Section */}
        <section className="esign-benefits">
          <h2>Why Choose Our E-Services</h2>
          <div className="esign-benefit-grid">
            <div className="esign-benefit-card">
              <h3>Speed & Efficiency</h3>
              <ul className="esign-benefit-list">
                <li className="esign-benefit-item">
                  <div className="esign-benefit-icon"></div>
                  <span className="esign-benefit-text">Average document processing time reduced from 5-7 business days to under 15 minutes for Indian regulatory compliance</span>
                </li>
                <li className="esign-benefit-item">
                  <div className="esign-benefit-icon"></div>
                  <span className="esign-benefit-text">Digital stamp duty payment integrated with state treasuries across Karnataka, Tamil Nadu, and Maharashtra</span>
                </li>
                <li className="esign-benefit-item">
                  <div className="esign-benefit-icon"></div>
                  <span className="esign-benefit-text">Round-the-clock service with 99.8% uptime guarantee and dedicated Indian customer support</span>
                </li>
              </ul>
            </div>
            <div className="esign-benefit-card">
              <h3>Legal Compliance</h3>
              <ul className="esign-benefit-list">
                <li className="esign-benefit-item">
                  <div className="esign-benefit-icon"></div>
                  <span className="esign-benefit-text">Fully compliant with IT Act 2000, Information Technology (Amendment) Act 2008, and Indian Stamp Act</span>
                </li>
                <li className="esign-benefit-item">
                  <div className="esign-benefit-icon"></div>
                  <span className="esign-benefit-text">Legally valid documents admissible in all Indian courts, High Courts, and Supreme Court proceedings</span>
                </li>
                <li className="esign-benefit-item">
                  <div className="esign-benefit-icon"></div>
                  <span className="esign-benefit-text">Certified by Controller of Certifying Authorities (CCA) and empaneled with SHCIL for e-stamping services</span>
                </li>
              </ul>
            </div>
          </div>
        </section>

        {/* Features Section */}
        <section className="esign-features">
          <h2>Advanced Digital Solutions</h2>
          <div className="esign-feature-grid">
            <div className="esign-feature-card">
              <img 
                src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                alt="Digital Signatures" 
                className="esign-feature-image"
              />
              <div className="esign-feature-content">
                <h3>Digital Signatures</h3>
                <p>Aadhaar-based DSC with 2048-bit encryption, biometric authentication via UIDAI, and OTP verification</p>
              </div>
            </div>
            <div className="esign-feature-card">
              <img 
                src="https://images.unsplash.com/photo-1618044733300-9472054094ee?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                alt="Secure E-stamps" 
                className="esign-feature-image"
              />
              <div className="esign-feature-content">
                <h3>Secure E-stamps</h3>
                <p>SHCIL-authorized digital stamp papers with blockchain verification and state treasury integration</p>
              </div>
            </div>
            <div className="esign-feature-card">
              <img 
                src="https://images.unsplash.com/photo-1611224923853-80b023f02d71?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                alt="Instant Processing" 
                className="esign-feature-image"
              />
              <div className="esign-feature-content">
                <h3>Instant Processing</h3>
                <p>Instant processing with RFC 3161 timestamp authority and SHA-256 hash integrity verification</p>
              </div>
            </div>
          </div>
        </section>

        {/* Integration Section */}
        <section className="esign-integration">
          <h2>Government & Enterprise Integration</h2>
          <div className="esign-integration-grid">
            <div className="esign-integration-card">
              <h3>State Treasury Integration</h3>
              <ul className="esign-integration-list">
                <li className="esign-integration-item">
                  <div className="esign-integration-icon"></div>
                  <span className="esign-integration-text">Direct integration with Karnataka State Treasury for instant stamp duty payment and certificate generation</span>
                </li>
                <li className="esign-integration-item">
                  <div className="esign-integration-icon"></div>
                  <span className="esign-integration-text">Tamil Nadu Treasury portal connectivity for real-time stamp paper procurement and validation</span>
                </li>
                <li className="esign-integration-item">
                  <div className="esign-integration-icon"></div>
                  <span className="esign-integration-text">Maharashtra e-Stamping system integration with automated duty calculation and payment processing</span>
                </li>
              </ul>
            </div>
            <div className="esign-integration-card">
              <h3>Banking & Financial Integration</h3>
              <ul className="esign-integration-list">
                <li className="esign-integration-item">
                  <div className="esign-integration-icon"></div>
                  <span className="esign-integration-text">Seamless integration with major Indian banks for loan agreement e-signing and documentation</span>
                </li>
                <li className="esign-integration-item">
                  <div className="esign-integration-icon"></div>
                  <span className="esign-integration-text">NPCI UPI integration for instant stamp duty payments and transaction confirmations</span>
                </li>
                <li className="esign-integration-item">
                  <div className="esign-integration-icon"></div>
                  <span className="esign-integration-text">RBI-compliant digital signature workflows for financial institutions and NBFCs</span>
                </li>
              </ul>
            </div>
            <div className="esign-integration-card">
              <h3>Legal & Regulatory Integration</h3>
              <ul className="esign-integration-list">
                <li className="esign-integration-item">
                  <div className="esign-integration-icon"></div>
                  <span className="esign-integration-text">Integration with Bar Council of India for advocate digital signature verification and authentication</span>
                </li>
                <li className="esign-integration-item">
                  <div className="esign-integration-icon"></div>
                  <span className="esign-integration-text">RERA portal connectivity for project agreement e-signing and regulatory compliance documentation</span>
                </li>
                <li className="esign-integration-item">
                  <div className="esign-integration-icon"></div>
                  <span className="esign-integration-text">High Court and District Court e-filing system integration for legal document submission</span>
                </li>
              </ul>
            </div>
          </div>
        </section>

        {/* CTA Section */}
        <section className="esign-cta">
          <div className="esign-cta-card">
            <h2>Go Digital Today</h2>
            <p>
              Transform your property transactions with our digital solutions
            </p>
            <Button className="esign-cta-button">
              Start Digital Signing
              <ArrowRight className="w-5 h-5 ml-2" />
            </Button>
          </div>
        </section>
      </div>
    </>
  );
}