import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import { FileText, Shield, Calculator, CheckCircle, Download, CreditCard } from 'lucide-react';
import { Button } from '../../components/ui/button';
import { EStampCalculator } from '../../components/contracts/EStampCalculator';

export function EStampPage() {
  const navigate = useNavigate();
  const [showCalculator, setShowCalculator] = useState(false);

  return (
    <>
      <style>{`
        .estamp-hero {
          background: linear-gradient(135deg, #0f172a 0%, #1e3a8a 100%) !important;
          padding: 6rem 0 !important;
          color: white !important;
          text-align: center !important;
        }
        .estamp-hero h1 {
          font-size: 3.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
        }
        .estamp-hero p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          max-width: 50rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
        }
        .estamp-pricing {
          background: rgba(255, 255, 255, 0.95) !important;
          color: #1e293b !important;
          padding: 1.25rem 2.5rem !important;
          border-radius: 0.75rem !important;
          font-weight: 600 !important;
          display: inline-block !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
        }
        .estamp-content {
          padding: 5rem 1rem !important;
          background: #f8fafc !important;
        }
        .estamp-content h2 {
          font-size: 2.5rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
        }
        .estamp-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 80rem !important;
          margin: 0 auto !important;
        }
        .estamp-card {
          background: white !important;
          padding: 2.5rem !important;
          border-radius: 0.75rem !important;
          box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important;
          border: 1px solid #e2e8f0 !important;
          transition: all 0.3s ease !important;
        }
        .estamp-card:hover {
          transform: translateY(-0.125rem) !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1) !important;
        }
        .estamp-card h3 {
          font-size: 1.5rem !important;
          font-weight: 600 !important;
          margin-bottom: 1.5rem !important;
          color: #1e293b !important;
        }
        .estamp-list {
          list-style: none !important;
          padding: 0 !important;
        }
        .estamp-list li {
          display: flex !important;
          align-items: flex-start !important;
          gap: 0.75rem !important;
          margin-bottom: 1rem !important;
        }
        .estamp-check {
          background: #dcfce7 !important;
          border-radius: 50% !important;
          padding: 0.25rem !important;
          width: 1.5rem !important;
          height: 1.5rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
          flex-shrink: 0 !important;
          margin-top: 0.125rem !important;
        }
        .estamp-check::after {
          content: '✓' !important;
          color: #059669 !important;
          font-weight: bold !important;
          font-size: 0.75rem !important;
        }
        .estamp-text {
          color: #475569 !important;
          line-height: 1.6 !important;
        }
        .estamp-calculator-section {
          padding: 5rem 1rem !important;
          background: white !important;
        }
        .estamp-cta {
          padding: 5rem 1rem !important;
          background: #1e293b !important;
          color: white !important;
          text-align: center !important;
        }
      `}</style>
      
      <div className="min-h-screen bg-slate-50">
        {/* Hero Section */}
        <div className="estamp-hero">
          <div style={{ maxWidth: '64rem', margin: '0 auto', padding: '0 1rem' }}>
            <h1>E-Stamp Services</h1>
            <p>
              Digital stamp paper generation for property documents. Instant processing with 
              state treasury integration. Legally valid across all Indian states.
            </p>
            <div className="estamp-pricing">
              E-stamp: ₹299 + govt charges | Bulk: Custom pricing
            </div>
          </div>
        </div>

        {/* Features Section */}
        <div className="estamp-content">
          <h2>E-Stamp Features</h2>
          <div className="estamp-grid">
            <div className="estamp-card">
              <div className="flex items-center gap-3 mb-4">
                <Calculator className="w-8 h-8 text-blue-600" />
                <h3>Instant Calculation</h3>
              </div>
              <ul className="estamp-list">
                <li>
                  <div className="estamp-check"></div>
                  <span className="estamp-text">State-wise stamp duty calculator with real-time rates</span>
                </li>
                <li>
                  <div className="estamp-check"></div>
                  <span className="estamp-text">Automatic calculation based on property value and type</span>
                </li>
                <li>
                  <div className="estamp-check"></div>
                  <span className="estamp-text">Support for all document types - sale deed, rent, lease</span>
                </li>
              </ul>
            </div>

            <div className="estamp-card">
              <div className="flex items-center gap-3 mb-4">
                <Shield className="w-8 h-8 text-green-600" />
                <h3>Secure & Legal</h3>
              </div>
              <ul className="estamp-list">
                <li>
                  <div className="estamp-check"></div>
                  <span className="estamp-text">SHCIL authorized digital stamp papers</span>
                </li>
                <li>
                  <div className="estamp-check"></div>
                  <span className="estamp-text">Blockchain verification for authenticity</span>
                </li>
                <li>
                  <div className="estamp-check"></div>
                  <span className="estamp-text">Legally valid under Indian Stamp Act</span>
                </li>
              </ul>
            </div>

            <div className="estamp-card">
              <div className="flex items-center gap-3 mb-4">
                <CreditCard className="w-8 h-8 text-purple-600" />
                <h3>Easy Payment</h3>
              </div>
              <ul className="estamp-list">
                <li>
                  <div className="estamp-check"></div>
                  <span className="estamp-text">UPI, Net Banking, and Card payment options</span>
                </li>
                <li>
                  <div className="estamp-check"></div>
                  <span className="estamp-text">Direct state treasury integration</span>
                </li>
                <li>
                  <div className="estamp-check"></div>
                  <span className="estamp-text">Instant certificate generation after payment</span>
                </li>
              </ul>
            </div>
          </div>
        </div>

        {/* Calculator Section */}
        <div className="estamp-calculator-section">
          <div style={{ maxWidth: '80rem', margin: '0 auto' }}>
            <h2 className="text-3xl font-bold text-center mb-8">Calculate & Generate E-Stamp</h2>
            <EStampCalculator />
          </div>
        </div>

        {/* Process Section */}
        <div className="estamp-content">
          <h2>How It Works</h2>
          <div className="estamp-grid">
            <div className="estamp-card">
              <div className="flex items-center gap-3 mb-4">
                <div style={{ background: '#1e293b', color: 'white', borderRadius: '0.5rem', width: '2.5rem', height: '2.5rem', display: 'flex', alignItems: 'center', justifyContent: 'center', fontWeight: 'bold', fontSize: '1.25rem' }}>1</div>
                <h3>Calculate Duty</h3>
              </div>
              <p className="estamp-text">
                Enter property details and get instant stamp duty calculation based on state rates
              </p>
            </div>

            <div className="estamp-card">
              <div className="flex items-center gap-3 mb-4">
                <div style={{ background: '#1e293b', color: 'white', borderRadius: '0.5rem', width: '2.5rem', height: '2.5rem', display: 'flex', alignItems: 'center', justifyContent: 'center', fontWeight: 'bold', fontSize: '1.25rem' }}>2</div>
                <h3>Make Payment</h3>
              </div>
              <p className="estamp-text">
                Pay stamp duty securely through UPI, Net Banking, or Card with state treasury integration
              </p>
            </div>

            <div className="estamp-card">
              <div className="flex items-center gap-3 mb-4">
                <div style={{ background: '#1e293b', color: 'white', borderRadius: '0.5rem', width: '2.5rem', height: '2.5rem', display: 'flex', alignItems: 'center', justifyContent: 'center', fontWeight: 'bold', fontSize: '1.25rem' }}>3</div>
                <h3>Get Certificate</h3>
              </div>
              <p className="estamp-text">
                Download your legally valid e-stamp certificate instantly with unique verification number
              </p>
            </div>
          </div>
        </div>

        {/* CTA Section */}
        <div className="estamp-cta">
          <div style={{ maxWidth: '50rem', margin: '0 auto' }}>
            <h2 className="text-3xl font-bold mb-4">Ready to Generate E-Stamp?</h2>
            <p className="text-lg mb-6">
              Get your digital stamp paper in minutes with our secure and legally compliant platform
            </p>
            <Button 
              onClick={() => setShowCalculator(true)}
              className="bg-white text-slate-900 hover:bg-gray-100 px-8 py-3 text-lg"
            >
              Start Now
            </Button>
          </div>
        </div>
      </div>
    </>
  );
}
