import React from "react";
import { Users, ArrowLeft, Phone, Home, Shield, AlertTriangle, CheckCircle, FileText, Calendar } from "lucide-react";
import { useNavigate } from "react-router-dom";
import { Button } from "../../components/ui/button";

export function FirstTimeBuyersGuidance() {
  const navigate = useNavigate();

  const handleGetAssistance = () => {
    window.location.href = "tel:+911234567890";
  };

  return (
    <>
      <style>{`
        .buyers-hero {
          background: linear-gradient(135deg, #0056D2 0%, #004bb5 100%);
          padding: 3rem 1rem;
          text-align: center;
          color: white;
        }
        .buyers-hero h1 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 1rem;
          color: white;
        }
        .buyers-hero p {
          font-size: 1.125rem;
          color: #e0f2fe;
          max-width: 48rem;
          margin: 0 auto;
        }
        .buyers-section {
          padding: 3rem 1rem;
          background: #f9fafb;
        }
        .buyers-section.with-bg {
          background: white;
          position: relative;
        }
        .buyers-section h2 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 2rem;
          color: #111827;
          text-align: center;
        }
        .tip-card {
          background: linear-gradient(135deg, #eff6ff 0%, #ecfeff 100%);
          padding: 2rem;
          border-radius: 1rem;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
          border: 1px solid #a5b4fc;
          transition: all 0.3s ease;
          text-align: center;
          cursor: pointer;
        }
        .tip-card:hover {
          background: linear-gradient(135deg, #dbeafe 0%, #cffafe 100%);
          transform: translateY(-4px);
          box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
          border-color: #0056D2;
        }
      `}</style>
      
      <div className="min-h-screen bg-white">
        <div className="p-4">
          <button
            onClick={() => navigate(-1)}
            className="flex items-center gap-2 text-[#0056D2] hover:text-[#003d99] transition-colors"
          >
            <ArrowLeft className="w-5 h-5" />
            <span className="font-medium">Back</span>
          </button>
        </div>

        <section className="buyers-hero">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1>Home Insurance Guidance for First-Time Buyers</h1>
            <p>
              Simple and clear insurance guidance for your first home purchase. Learn the basics and avoid common mistakes.
            </p>
          </div>
        </section>

        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Why Insurance Matters for First-Time Buyers</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
              <div className="tip-card">
                <AlertTriangle className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Can Be Confusing
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Insurance can be confusing for first-time buyers, but it's essential protection for your investment.
                </p>
              </div>
              <div className="tip-card">
                <FileText className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Loan Requirement
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Often required as part of the loan approval process by banks and financial institutions.
                </p>
              </div>
              <div className="tip-card">
                <Shield className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Risk Reduction
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Helps reduce long-term financial risk and protects your biggest investment.
                </p>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>When Insurance Is Usually Required</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl border border-blue-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-blue-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <Calendar className="w-5 h-5 text-blue-600" />
                  During Loan Process
                </h3>
                <ul className="space-y-3 text-sm text-gray-700">
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Before your home loan is approved and disbursed</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>During property registration and documentation</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>As part of your overall home buying checklist</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl border border-blue-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-blue-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <Home className="w-5 h-5 text-blue-600" />
                  Before Possession
                </h3>
                <ul className="space-y-3 text-sm text-gray-700">
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Before you take possession of your new home</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>To ensure continuous protection from day one</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Before moving in and starting to live there</span>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Common Questions from First-Time Buyers</h2>
            <div className="max-w-4xl mx-auto">
              <div className="space-y-6">
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: What exactly is home insurance and why do I need it?
                  </h3>
                  <p className="text-gray-600">
                    A: Home insurance protects your home and belongings against damage from fire, theft, natural disasters, and other covered risks, providing financial security.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: Is insurance mandatory for all home loans?
                  </h3>
                  <p className="text-gray-600">
                    A: Usually yes, most banks require home insurance as a condition for loan approval to protect their investment in your property.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: When should I take insurance during the buying process?
                  </h3>
                  <p className="text-gray-600">
                    A: Ideally before loan approval and definitely before taking possession of your property to ensure continuous protection.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: How do I choose the right insurance provider?
                  </h3>
                  <p className="text-gray-600">
                    A: Compare coverage options, claim settlement ratios, customer service, and premium rates from multiple providers before deciding.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: What should I look for in an insurance policy?
                  </h3>
                  <p className="text-gray-600">
                    A: Key factors include adequate coverage amount, comprehensive risk coverage, reasonable premium, good claim settlement record, and clear policy terms.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section" style={{ background: "white" }}>
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="bg-blue-50 border-l-4 border-blue-400 p-6 rounded-lg">
              <div className="flex items-start gap-3">
                <Phone className="w-6 h-6 text-blue-600 mt-1" />
                <div>
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    How Our Assistance Helps First-Time Buyers
                  </h3>
                  <ul className="space-y-2 text-sm text-gray-700">
                    <li>• Provide simple explanations in easy-to-understand language</li>
                    <li>• Offer step-by-step guidance through the insurance process</li>
                    <li>• Connect you with trusted and reliable insurance providers</li>
                    <li>• Help you understand what to expect during the application process</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 className="text-base">Ready to Get Started?</h2>
            <div className="flex justify-center">
              <Button
                className="bg-blue-600 hover:bg-blue-700 text-white p-4 h-auto flex items-center gap-2"
                style={{ backgroundColor: "#0056D2", color: "white" }}
                onClick={handleGetAssistance}
              >
                <Phone className="w-5 h-5" />
                <span>Get Insurance Assistance</span>
              </Button>
            </div>
            <p className="text-center text-sm text-gray-500 mt-4 italic">
              We do not provide insurance directly. Our role is limited to assistance and guidance only.
            </p>
          </div>
        </section>
      </div>
    </>
  );
}