import React from "react";
import { Home, ArrowLeft, Phone, Shield, AlertTriangle, CheckCircle, FileText, Calendar } from "lucide-react";
import { useNavigate } from "react-router-dom";
import { Button } from "../../components/ui/button";

export function HomeBuyersGuidance() {
  const navigate = useNavigate();

  const handleGetAssistance = () => {
    window.location.href = "tel:+911234567890";
  };

  return (
    <>
      <style>{`
        .buyers-hero {
          background: linear-gradient(135deg, #0056D2 0%, #004bb5 100%);
          padding: 3rem 1rem;
          text-align: center;
          color: white;
        }
        .buyers-hero h1 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 1rem;
          color: white;
        }
        .buyers-hero p {
          font-size: 1.125rem;
          color: #e0f2fe;
          max-width: 48rem;
          margin: 0 auto;
        }
        .buyers-section {
          padding: 3rem 1rem;
          background: #f9fafb;
        }
        .buyers-section.with-bg {
          background: white;
          position: relative;
        }
        .buyers-section h2 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 2rem;
          color: #111827;
          text-align: center;
        }
        .tip-card {
          background: linear-gradient(135deg, #eff6ff 0%, #ecfeff 100%);
          padding: 2rem;
          border-radius: 1rem;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
          border: 1px solid #a5b4fc;
          transition: all 0.3s ease;
          text-align: center;
          cursor: pointer;
        }
        .tip-card:hover {
          background: linear-gradient(135deg, #dbeafe 0%, #cffafe 100%);
          transform: translateY(-4px);
          box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
          border-color: #0056D2;
        }
      `}</style>
      
      <div className="min-h-screen bg-white">
        <div className="p-4">
          <button
            onClick={() => navigate(-1)}
            className="flex items-center gap-2 text-[#0056D2] hover:text-[#003d99] transition-colors"
          >
            <ArrowLeft className="w-5 h-5" />
            <span className="font-medium">Back</span>
          </button>
        </div>

        <section className="buyers-hero">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1>Home Insurance Guidance for Home Buyers</h1>
            <p>
              Essential insurance guidance for those purchasing their new home. Learn about requirements, documentation, and protection.
            </p>
          </div>
        </section>

        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Why Insurance Matters for Home Buyers</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
              <div className="tip-card">
                <Shield className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Loan Requirement
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Insurance is often mandatory when applying for a home loan from banks and financial institutions.
                </p>
              </div>
              <div className="tip-card">
                <AlertTriangle className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Financial Protection
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Helps protect against unexpected financial losses from natural disasters, fire, and theft.
                </p>
              </div>
              <div className="tip-card">
                <Home className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Investment Security
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Protects your biggest investment and provides peace of mind during the home buying process.
                </p>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Insurance Requirements Timeline</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl border border-blue-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-blue-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <Calendar className="w-5 h-5 text-blue-600" />
                  Before Loan Approval
                </h3>
                <ul className="space-y-3 text-sm text-gray-700">
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Insurance often required before loan disbursement</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Banks may ask for insurance proof during loan processing</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Required during property registration process</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl border border-blue-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-blue-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <FileText className="w-5 h-5 text-blue-600" />
                  After Purchase
                </h3>
                <ul className="space-y-3 text-sm text-gray-700">
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Before taking possession of the property</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Ensure continuous coverage throughout loan tenure</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Regular renewal as per policy terms</span>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Common Questions from Home Buyers</h2>
            <div className="max-w-4xl mx-auto">
              <div className="space-y-6">
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: Do I need insurance before property registration?
                  </h3>
                  <p className="text-gray-600">
                    A: Usually yes, as most banks require insurance proof as part of loan requirements before disbursement and registration.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: Is insurance required by the bank for home loans?
                  </h3>
                  <p className="text-gray-600">
                    A: Yes, most banks and financial institutions mandate home insurance as a condition for loan approval and disbursement.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: What documents are usually asked for insurance?
                  </h3>
                  <p className="text-gray-600">
                    A: Typically property papers, loan documents, identity proofs, property valuation certificate, and bank account details.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: Can I choose my own insurance provider?
                  </h3>
                  <p className="text-gray-600">
                    A: Yes, you can select from approved providers, though some banks may have preferred partners with special rates.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: How much coverage do I need for my new home?
                  </h3>
                  <p className="text-gray-600">
                    A: Coverage should typically match your property's reconstruction value, not market value. Consult with experts for accurate assessment.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section" style={{ background: "white" }}>
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="bg-blue-50 border-l-4 border-blue-400 p-6 rounded-lg">
              <div className="flex items-start gap-3">
                <Phone className="w-6 h-6 text-blue-600 mt-1" />
                <div>
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    How Our Assistance Helps Home Buyers
                  </h3>
                  <ul className="space-y-2 text-sm text-gray-700">
                    <li>• Explain insurance requirements clearly in simple terms</li>
                    <li>• Guide you through the documentation process step by step</li>
                    <li>• Connect you with trusted and reliable insurance providers</li>
                    <li>• Help you understand what coverage options are available</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 className="text-base">Ready to Get Started?</h2>
            <div className="flex justify-center">
              <Button
                className="bg-blue-600 hover:bg-blue-700 text-white p-4 h-auto flex items-center gap-2"
                style={{ backgroundColor: "#0056D2", color: "white" }}
                onClick={handleGetAssistance}
              >
                <Phone className="w-5 h-5" />
                <span>Get Insurance Assistance</span>
              </Button>
            </div>
            <p className="text-center text-sm text-gray-500 mt-4 italic">
              We do not provide insurance directly. Our role is limited to assistance and guidance only.
            </p>
          </div>
        </section>
      </div>
    </>
  );
}