import React from "react";
import { useNavigate } from "react-router-dom";
import { CheckCircle, Shield, FileText, Phone } from "lucide-react";
import { Button } from "../../components/ui/button";

export function HomeInsurance() {
  const navigate = useNavigate();

  return (
    <>
      <style>{`
        .insurance-hero {
          background: linear-gradient(135deg, #1e293b 0%, #334155 100%) !important;
          padding: 6rem 0 !important;
          color: white !important;
          text-align: center !important;
        }
        .insurance-hero h1 {
          font-size: 3.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .insurance-hero p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          max-width: 50rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
          line-height: 1.7 !important;
        }
        .insurance-pricing {
          background: rgba(255, 255, 255, 0.95) !important;
          color: #1e293b !important;
          padding: 1.25rem 2.5rem !important;
          border-radius: 0.75rem !important;
          font-weight: 600 !important;
          font-size: 1rem !important;
          display: inline-block !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
        }
        .insurance-services {
          padding: 5rem 1rem !important;
          background: white !important;
        }
        .insurance-services-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 80rem !important;
          margin: 0 auto !important;
        }
        .insurance-service-card {
          background: #f8fafc !important;
          padding: 2.5rem !important;
          border-radius: 0.75rem !important;
          text-align: center !important;
          border: 1px solid #e2e8f0 !important;
          transition: all 0.3s ease !important;
        }
        .insurance-service-card:hover {
          transform: translateY(-0.125rem) !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1) !important;
          border-color: #cbd5e1 !important;
        }
        .insurance-service-card img {
          width: 100% !important;
          height: 12rem !important;
          object-fit: cover !important;
          border-radius: 0.5rem !important;
          margin-bottom: 1.5rem !important;
        }
        .insurance-service-card h3 {
          font-size: 1.375rem !important;
          font-weight: 600 !important;
          margin-bottom: 1rem !important;
          color: #1e293b !important;
        }
        .insurance-service-card p {
          color: #64748b !important;
        }
        .insurance-content {
          padding: 5rem 1rem !important;
          background: #f8fafc !important;
        }
        .insurance-content h2 {
          font-size: 2.5rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .insurance-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .insurance-card {
          background: white !important;
          padding: 2.5rem !important;
          border-radius: 0.75rem !important;
          box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important;
          border: 1px solid #e2e8f0 !important;
          transition: all 0.3s ease !important;
        }
        .insurance-card:hover {
          transform: translateY(-0.125rem) !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1) !important;
        }
        .insurance-card h2 {
          font-size: 1.5rem !important;
          font-weight: 600 !important;
          margin-bottom: 1.5rem !important;
          color: #1e293b !important;
        }
        .insurance-list {
          list-style: none !important;
          padding: 0 !important;
        }
        .insurance-list li {
          display: flex !important;
          align-items: flex-start !important;
          gap: 0.75rem !important;
          margin-bottom: 1rem !important;
        }
        .insurance-check {
          background: #dcfce7 !important;
          border-radius: 50% !important;
          padding: 0.25rem !important;
          width: 1.5rem !important;
          height: 1.5rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
          flex-shrink: 0 !important;
          margin-top: 0.125rem !important;
        }
        .insurance-check::after {
          content: '✓' !important;
          color: #059669 !important;
          font-weight: bold !important;
          font-size: 0.75rem !important;
        }
        .insurance-text {
          color: #475569 !important;
          line-height: 1.6 !important;
        }
        .insurance-cta {
          padding: 5rem 1rem !important;
          background: #1e293b !important;
          color: white !important;
          text-align: center !important;
        }
        .insurance-cta-card {
          background: #334155 !important;
          border-radius: 1rem !important;
          padding: 4rem !important;
          max-width: 50rem !important;
          margin: 0 auto !important;
        }
        .insurance-cta h2 {
          font-size: 2.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .insurance-cta p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          line-height: 1.6 !important;
        }
        .insurance-buttons {
          display: flex !important;
          flex-direction: column !important;
          gap: 1rem !important;
          align-items: center !important;
        }
        @media (min-width: 640px) {
          .insurance-buttons {
            flex-direction: row !important;
            justify-content: center !important;
          }
        }
        .insurance-btn-primary {
          background: white !important;
          color: #1e293b !important;
          padding: 1rem 2.5rem !important;
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          border-radius: 0.5rem !important;
          box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1) !important;
          transition: all 0.3s ease !important;
          border: none !important;
          cursor: pointer !important;
        }
        .insurance-btn-primary:hover {
          transform: translateY(-0.125rem) !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
        }
        .insurance-btn-secondary {
          background: transparent !important;
          color: white !important;
          padding: 1rem 2.5rem !important;
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          border-radius: 0.5rem !important;
          border: 2px solid white !important;
          transition: all 0.3s ease !important;
          cursor: pointer !important;
        }
        .insurance-btn-secondary:hover {
          background: white !important;
          color: #1e293b !important;
        }
      `}</style>
      <div className="min-h-screen bg-white">
        {/* Hero Section */}
        <div className="insurance-hero">
          <div
            style={{ maxWidth: "64rem", margin: "0 auto", padding: "0 1rem" }}
          >
            <h1>Home Insurance </h1>
            <p>
              Get help choosing the right protection for your home. NAL connects
              you with trusted insurance providers and helps with paperwork for
              comprehensive coverage against various risks. With property values
              rising and natural disasters increasing, proper insurance is
              essential for protecting your investment.
            </p>
            <div className="insurance-pricing">
              Free consultation | Policy premiums: ₹5,000-₹25,000/year
            </div>
          </div>
        </div>

        {/* Service Images Section */}
        <div className="insurance-services">
          <div className="insurance-services-grid">
            <div className="insurance-service-card">
              <img
                src="https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=400&h=300&fit=crop"
                alt="Insurance Protection"
              />
              <h3>Insurance Protection</h3>
              <p>Comprehensive coverage & claim support</p>
            </div>
            <div className="insurance-service-card">
              <img
                src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=400&h=300&fit=crop"
                alt="Risk Assessment"
              />
              <h3>Risk Assessment</h3>
              <p>15+ providers with best claim ratios</p>
            </div>
            <div className="insurance-service-card">
              <img
                src="https://images.unsplash.com/photo-1551434678-e076c223a692?w=400&h=300&fit=crop"
                alt="Claim Support"
              />
              <h3>Claim Support</h3>
              <p>Average claim settlement in 15-30 days</p>
            </div>
          </div>
        </div>

        <div className="max-w-6xl mx-auto px-4 py-16 -mt-6">
          {/* Content Section */}
          <div className="insurance-content">
            <h2>Comprehensive Insurance Solutions</h2>
            <div className="insurance-grid">
              {/* Features */}
              <div className="insurance-card">
                <h2>Key Features</h2>
                <ul className="insurance-list">
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Comprehensive policy comparison across 15+ leading
                      insurance providers
                    </span>
                  </li>
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Coverage assessment for fire and theft protection tailored
                      to property value
                    </span>
                  </li>
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Natural disaster coverage evaluation including floods,
                      earthquakes, and cyclones
                    </span>
                  </li>
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Professional claim assistance and support throughout the
                      claim process
                    </span>
                  </li>
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Integration with property valuation for accurate sum
                      insured determination
                    </span>
                  </li>
                </ul>
              </div>

              {/* Benefits */}
              <div className="insurance-card">
                <h2>Benefits</h2>
                <ul className="insurance-list">
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Complete protection against fire and accidental damage
                      with comprehensive coverage
                    </span>
                  </li>
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Theft and burglary coverage including contents insurance
                      up to declared value
                    </span>
                  </li>
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Natural disaster protection crucial in areas prone to
                      floods, earthquakes, and cyclones
                    </span>
                  </li>
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Access to trusted and reliable insurance providers with
                      strong claim settlement ratios
                    </span>
                  </li>
                  <li>
                    <div className="insurance-check"></div>
                    <span className="insurance-text">
                      Peace of mind with comprehensive property protection and
                      24/7 claim support
                    </span>
                  </li>
                </ul>
              </div>

              {/* Process */}
              <div className="insurance-card">
                <h2>How It Works</h2>
                <ul className="insurance-list">
                  <li>
                    <div
                      style={{
                        background: "#1e293b",
                        color: "white",
                        borderRadius: "50%",
                        width: "1.5rem",
                        height: "1.5rem",
                        display: "flex",
                        alignItems: "center",
                        justifyContent: "center",
                        fontWeight: "bold",
                        fontSize: "0.875rem",
                        flexShrink: 0,
                        marginTop: "0.125rem",
                      }}
                    >
                      1
                    </div>
                    <span className="insurance-text">
                      Detailed property assessment with valuation for accurate
                      sum insured determination
                    </span>
                  </li>
                  <li>
                    <div
                      style={{
                        background: "#1e293b",
                        color: "white",
                        borderRadius: "50%",
                        width: "1.5rem",
                        height: "1.5rem",
                        display: "flex",
                        alignItems: "center",
                        justifyContent: "center",
                        fontWeight: "bold",
                        fontSize: "0.875rem",
                        flexShrink: 0,
                        marginTop: "0.125rem",
                      }}
                    >
                      2
                    </div>
                    <span className="insurance-text">
                      Comprehensive policy comparison across 15+ providers with
                      coverage and pricing analysis
                    </span>
                  </li>
                  <li>
                    <div
                      style={{
                        background: "#1e293b",
                        color: "white",
                        borderRadius: "50%",
                        width: "1.5rem",
                        height: "1.5rem",
                        display: "flex",
                        alignItems: "center",
                        justifyContent: "center",
                        fontWeight: "bold",
                        fontSize: "0.875rem",
                        flexShrink: 0,
                        marginTop: "0.125rem",
                      }}
                    >
                      3
                    </div>
                    <span className="insurance-text">
                      Optimal coverage selection based on property type,
                      location, and risk factors
                    </span>
                  </li>
                  <li>
                    <div
                      style={{
                        background: "#1e293b",
                        color: "white",
                        borderRadius: "50%",
                        width: "1.5rem",
                        height: "1.5rem",
                        display: "flex",
                        alignItems: "center",
                        justifyContent: "center",
                        fontWeight: "bold",
                        fontSize: "0.875rem",
                        flexShrink: 0,
                        marginTop: "0.125rem",
                      }}
                    >
                      4
                    </div>
                    <span className="insurance-text">
                      Streamlined policy purchase with digital documentation and
                      instant activation
                    </span>
                  </li>
                  <li>
                    <div
                      style={{
                        background: "#1e293b",
                        color: "white",
                        borderRadius: "50%",
                        width: "1.5rem",
                        height: "1.5rem",
                        display: "flex",
                        alignItems: "center",
                        justifyContent: "center",
                        fontWeight: "bold",
                        fontSize: "0.875rem",
                        flexShrink: 0,
                        marginTop: "0.125rem",
                      }}
                    >
                      5
                    </div>
                    <span className="insurance-text">
                      Ongoing support with annual renewal management, claim
                      assistance, and policy optimization
                    </span>
                  </li>
                </ul>
              </div>
            </div>
          </div>

          {/* CTA Section */}
          <div className="insurance-cta">
            <div className="insurance-cta-card">
              <h2>Ready to Get Started?</h2>
              <p>
                Contact our experts today to learn more about how home insurance
                assistance can help you with data-backed insights and
                professional service.
              </p>
              <div className="insurance-buttons">
                <Button className="insurance-btn-secondary">
                  Schedule Consultation
                </Button>
                <Button className="insurance-btn-primary">
                  Get Started Now
                </Button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}
