import React from "react";
import {
  Shield,
  Home,
  Users,
  ArrowRight,
  ArrowLeft,
  Phone,
} from "lucide-react";
import { Button } from "../../components/ui/button";
import { useNavigate } from "react-router-dom";

export function HomeInsuranceAssistance() {
  const navigate = useNavigate();

  const handleGetAssistance = () => {
    window.location.href = "tel:+911234567890";
  };

  return (
    <>
      <style>{`
        .insurance-hero {
          background: #0056D2 !important;
          color: white !important;
          padding: 4rem 1rem !important;
          text-align: center !important;
        }
        .insurance-hero h1 {
          font-size: 3rem !important;
          font-weight: 700 !important;
          margin-bottom: 1rem !important;
          color: white !important;
        }
        .insurance-hero p {
          font-size: 1.125rem !important;
          margin-bottom: 0 !important;
          color: #e0f2fe !important;
          max-width: 48rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
        }
        .insurance-intro {
          background: white !important;
          color: #111827 !important;
          padding: 3rem 1rem !important;
          text-align: center !important;
        }
        .insurance-intro h2 {
          font-size: 2rem !important;
          font-weight: 700 !important;
          margin-bottom: 1rem !important;
          color: #111827 !important;
        }
        .insurance-intro p {
          font-size: 1rem !important;
          color: #4b5563 !important;
          max-width: 48rem !important;
          margin: 0 auto !important;
        }
        /* Who Is This Service For */}
        .insurance-section {
          padding: 4rem 1rem !important;
          background: #f8fafc !important;
        }
        .insurance-section h2 {
          font-size: 1.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 2rem !important;
          color: #111827 !important;
        }
        .insurance-cards-grid {
          display: grid !important;
          grid-template-columns: repeat(3, 1fr) !important;
          gap: 2rem !important;
          max-width: 80rem !important;
          margin: 0 auto !important;
        }
        .insurance-service-card {
          background: white !important;
          padding: 0 !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          text-align: center !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
          overflow: hidden !important;
          cursor: pointer !important;
        }
        .insurance-service-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
          border-color: #0056D2 !important;
        }
        .insurance-service-image {
          width: 100% !important;
          height: 150px !important;
          object-fit: cover !important;
        }
        .insurance-service-content {
          padding: 1.5rem !important;
        }
        .insurance-service-icon {
          background: #e0f2fe !important;
          border-radius: 50% !important;
          padding: 1rem !important;
          width: 4rem !important;
          height: 4rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
          margin: 0 auto 1.5rem auto !important;
          color: #0056D2 !important;
        }
        .insurance-service-card h3 {
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          margin-bottom: 0.75rem !important;
          color: #111827 !important;
        }
        .insurance-service-card p {
          color: #4b5563 !important;
          line-height: 1.5 !important;
          font-size: 0.875rem !important;
        }
        /* Benefits Section */
        .insurance-benefits {
          padding: 4rem 1rem !important;
          background: white !important;
        }
        .insurance-benefits h2 {
          font-size: 1.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 2rem !important;
          color: #111827 !important;
        }
        .insurance-content {
          max-width: 48rem !important;
          margin: 0 auto !important;
          text-align: center !important;
        }
        .insurance-content ul {
          text-align: left !important;
          max-width: 32rem !important;
          margin: 0 auto 2rem auto !important;
        }
        .insurance-content li {
          font-size: 1rem !important;
          color: #4b5563 !important;
          margin-bottom: 0.75rem !important;
          display: flex !important;
          align-items: center !important;
          gap: 0.75rem !important;
        }
        .insurance-benefit-icon {
          background: #e0f2fe !important;
          border-radius: 50% !important;
          padding: 0.25rem !important;
          width: 1.5rem !important;
          height: 1.5rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
          flex-shrink: 0 !important;
        }
        .insurance-benefit-icon::after {
          content: '✓' !important;
          color: #0056D2 !important;
          font-weight: bold !important;
          font-size: 0.75rem !important;
        }
        .insurance-steps {
          padding: 4rem 1rem !important;
          background: #f8fafc !important;
        }
        .insurance-steps h2 {
          font-size: 1.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 2rem !important;
          color: #111827 !important;
        }
        .insurance-steps-grid {
          display: grid !important;
          grid-template-columns: repeat(3, 1fr) !important;
          gap: 3rem !important;
          max-width: 90rem !important;
          margin: 0 auto !important;
        }
        .insurance-step-card {
          background: white !important;
          padding: 2rem !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          text-align: center !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
          position: relative !important;
          overflow: hidden !important;
          height: 280px !important;
          display: flex !important;
          flex-direction: column !important;
          justify-content: center !important;
        }
        .insurance-step-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
          border-color: #0056D2 !important;
        }
        .insurance-step-image {
          width: 100% !important;
          height: 180px !important;
          object-fit: cover !important;
        }
        .insurance-step-content {
          padding: 0 !important;
          flex: 1 !important;
          display: flex !important;
          flex-direction: column !important;
          justify-content: center !important;
        }
        .insurance-step-number {
          background: #0056D2 !important;
          color: white !important;
          width: 2.5rem !important;
          height: 2.5rem !important;
          border-radius: 50% !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
          font-weight: 700 !important;
          font-size: 1.125rem !important;
          margin: 0 auto 1rem auto !important;
        }
        .insurance-step-card h3 {
          font-size: 1.25rem !important;
          font-weight: 600 !important;
          margin-bottom: 1rem !important;
          color: #111827 !important;
        }
        .insurance-step-card p {
          color: #4b5563 !important;
          line-height: 1.6 !important;
        }
        .insurance-cta {
          padding: 2rem 0.5rem !important;
          background: white !important;
          color: #111827 !important;
          text-align: center !important;
        }
        .insurance-cta h2 {
          font-size: 2rem !important;
          font-weight: 700 !important;
          margin-bottom: 1rem !important;
          color: #111827 !important;
        }
        .insurance-cta p {
          font-size: 1.125rem !important;
          margin-bottom: 2rem !important;
          color: #4b5563 !important;
          max-width: 48rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
          margin-bottom: 2rem !important;
        }
        .insurance-cta-button {
          background: #0056D2 !important;
          color: white !important;
          padding: 1rem 2rem !important;
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          border-radius: 0.5rem !important;
          border: none !important;
          cursor: pointer !important;
          transition: all 0.3s ease !important;
          display: inline-flex !important;
          align-items: center !important;
          gap: 0.5rem !important;
        }
        .insurance-cta-button:hover {
          background: #003d99 !important;
          transform: translateY(-2px) !important;
          box-shadow: 0 8px 25px rgba(0, 86, 210, 0.3) !important;
        }
        .insurance-disclaimer {
          padding: 2rem 1rem !important;
          background: #f9fafb !important;
          border-top: 1px solid #e5e7eb !important;
          text-align: center !important;
        }
        .insurance-disclaimer p {
          font-size: 0.875rem !important;
          color: #6b7280 !important;
          max-width: 48rem !important;
          margin: 0 auto !important;
          font-style: italic !important;
        }
      `}</style>

      <div className="min-h-screen bg-white">
        {/* Back Button */}
        <div className="p-4">
          <button
            onClick={() => navigate(-1)}
            className="flex items-center gap-2 text-[#0056D2] hover:text-[#003d99] transition-colors"
          >
            <ArrowLeft className="w-5 h-5" />
            <span className="font-medium">Back</span>
          </button>
        </div>

        {/* Hero Section */}
        <section className="insurance-hero">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1>Home Insurance Assistance</h1>
            <p>
              Get guidance on protecting your home and connect with trusted
              insurance providers.
            </p>
          </div>
        </section>

        {/* What Is Home Insurance */}
        <section className="insurance-intro">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>What Is Home Insurance?</h2>
            <p>
              Home insurance is a comprehensive protection plan that safeguards
              your property against various risks including fire, natural
              disasters, theft, and accidental damage. It provides financial
              security for one of your most valuable investments - your home.
            </p>
          </div>
        </section>

        {/* Types of Home Insurance Coverage */}
        <section className="insurance-steps">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Types of Home Insurance Coverage</h2>
            <div className="insurance-steps-grid">
              <div className="insurance-step-card">
                <div className="insurance-step-number">1</div>
                <h3>Assess Your Needs</h3>
                <p>
                  Evaluate your property value, location risks, and coverage
                  requirements to determine the right insurance amount.
                </p>
              </div>
              <div className="insurance-step-card">
                <div className="insurance-step-number">2</div>
                <h3>Compare Options</h3>
                <p>
                  Research different insurance providers, compare coverage
                  options, and understand policy terms and conditions.
                </p>
              </div>
              <div className="insurance-step-card">
                <div className="insurance-step-number">3</div>
                <h3>Get Expert Guidance</h3>
                <p>
                  Consult with insurance experts to understand the best policy
                  options for your specific needs and budget.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* What Does Home Insurance Cover */}
        <section className="insurance-benefits">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>What Does Home Insurance Typically Cover?</h2>
            <div className="insurance-content">
              <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 transition-all duration-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg">
                  <h3 className="text-lg font-semibold mb-3 text-[#0056D2]">
                    Natural Disasters
                  </h3>
                  <ul>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Fire and lightning damage</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Earthquake and flood damage</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Storm and cyclone damage</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Landslide and rockslide</span>
                    </li>
                  </ul>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 transition-all duration-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg">
                  <h3 className="text-lg font-semibold mb-3 text-[#0056D2]">
                    Man-Made Risks
                  </h3>
                  <ul>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Theft and burglary</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Vandalism and malicious damage</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Riots and strikes</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Terrorist activities</span>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Why Home Insurance is Important */}
        <section className="insurance-steps">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Why Home Insurance is Important</h2>
            <div className="insurance-steps-grid">
              <div className="insurance-step-card">
                <Shield className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
                <h3>Financial Protection</h3>
                <p>
                  Protects you from significant financial losses due to property
                  damage, ensuring you don't have to bear the entire cost of
                  repairs or rebuilding.
                </p>
              </div>
              <div className="insurance-step-card">
                <Home className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
                <h3>Loan Requirement</h3>
                <p>
                  Most banks and financial institutions require home insurance
                  as a condition for approving home loans, making it essential
                  for property purchase.
                </p>
              </div>
              <div className="insurance-step-card">
                <Users className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
                <h3>Peace of Mind</h3>
                <p>
                  Provides mental peace knowing that your home and belongings
                  are protected against unforeseen circumstances and natural
                  disasters.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Factors Affecting Home Insurance */}
        <section className="insurance-benefits">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Factors That Affect Home Insurance</h2>
            <div className="insurance-content">
              <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
                <div>
                  <h3 className="text-lg font-semibold mb-3 text-[#0056D2]">
                    Property Factors
                  </h3>
                  <ul>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Location and area risk profile</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Age and construction type of property</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Property value and sum insured</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Security measures in place</span>
                    </li>
                  </ul>
                </div>
                <div>
                  <h3 className="text-lg font-semibold mb-3 text-[#0056D2]">
                    Coverage Factors
                  </h3>
                  <ul>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Type and extent of coverage chosen</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Deductible amount selected</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Additional riders and add-ons</span>
                    </li>
                    <li>
                      <div className="insurance-benefit-icon"></div>
                      <span>Insurance company and policy terms</span>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Home Insurance Assistance and Guidance */}
        <section className="insurance-section">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Home Insurance Assistance and Guidance</h2>
            <div className="insurance-cards-grid">
              <div
                className="insurance-service-card"
                onClick={() => navigate("/services/home-insurance/home-buyers")}
              >
                <img
                  src="https://images.unsplash.com/photo-1560518883-ce09059eeffa?w=400&h=200&fit=crop"
                  alt="Home Buyers"
                  className="insurance-service-image"
                />
                <div className="insurance-service-content">
                  <div className="insurance-service-icon">
                    <Home className="w-6 h-6" />
                  </div>
                  <h3>Home Buyers</h3>
                  <p>
                    Looking to protect their investment with comprehensive home
                    insurance coverage
                  </p>
                </div>
              </div>

              <div
                className="insurance-service-card"
                onClick={() =>
                  navigate("/services/home-insurance/property-owners")
                }
              >
                <img
                  src="https://images.unsplash.com/photo-1570129477492-45c003edd2be?w=400&h=200&fit=crop"
                  alt="Property Owners"
                  className="insurance-service-image"
                />
                <div className="insurance-service-content">
                  <div className="insurance-service-icon">
                    <Shield className="w-6 h-6" />
                  </div>
                  <h3>Property Owners</h3>
                  <p>
                    Seeking comprehensive coverage for their existing properties
                    and assets
                  </p>
                </div>
              </div>

              <div
                className="insurance-service-card"
                onClick={() =>
                  navigate("/services/home-insurance/first-time-buyers")
                }
              >
                <img
                  src="https://images.unsplash.com/photo-1521791136064-7986c2920216?w=400&h=200&fit=crop"
                  alt="First-time Buyers"
                  className="insurance-service-image"
                />
                <div className="insurance-service-content">
                  <div className="insurance-service-icon">
                    <Users className="w-6 h-6" />
                  </div>
                  <h3>First-time Buyers</h3>
                  <p>
                    Needing guidance on insurance options and requirements for
                    their first home purchase
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* How Our Assistance Works */}
        <section className="insurance-steps">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>How to Choose the Right Home Insurance</h2>
            <div className="insurance-steps-grid">
              <div className="insurance-step-card">
                <div className="insurance-step-number">1</div>
                <h3>Assess Your Needs</h3>
                <p>
                  Evaluate your property value, location risks, and coverage
                  requirements to determine the right insurance amount.
                </p>
              </div>
              <div className="insurance-step-card">
                <div className="insurance-step-number">2</div>
                <h3>Compare Options</h3>
                <p>
                  Research different insurance providers, compare coverage
                  options, and understand policy terms and conditions.
                </p>
              </div>
              <div className="insurance-step-card">
                <div className="insurance-step-number">3</div>
                <h3>Get Expert Guidance</h3>
                <p>
                  Consult with insurance experts to understand the best policy
                  options for your specific needs and budget.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Common Mistakes to Avoid */}
        <section className="insurance-benefits">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Common Home Insurance Mistakes to Avoid</h2>
            <div className="insurance-content">
              <div className="bg-red-50 border-l-4 border-red-400 p-6 rounded-lg mb-6">
                <div className="max-w-md mx-auto">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2 flex items-center gap-2">
                    <span className="text-red-600">⚠️</span>
                    Avoid These Common Mistakes
                  </h3>
                  <ul className="space-y-2 text-sm text-gray-700">
                    <li>• Under-insuring your property value</li>
                    <li>• Not updating coverage after renovations</li>
                    <li>• Ignoring policy exclusions and limitations</li>
                    <li>
                      • Choosing the cheapest option without comparing coverage
                    </li>
                    <li>• Not maintaining proper documentation</li>
                    <li>• Delaying claims reporting after incidents</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Benefits */}
        <section className="insurance-benefits">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>How Our Assistance Helps You</h2>
            <div className="insurance-content">
              <ul>
                <li>
                  <div className="insurance-benefit-icon"></div>
                  <span>
                    Help you understand different types of home insurance
                    coverage available
                  </span>
                </li>
                <li>
                  <div className="insurance-benefit-icon"></div>
                  <span>
                    Guide you through the documentation and application process
                  </span>
                </li>
                <li>
                  <div className="insurance-benefit-icon"></div>
                  <span>
                    Connect you with trusted and reliable insurance providers
                  </span>
                </li>
                <li>
                  <div className="insurance-benefit-icon"></div>
                  <span>
                    Explain policy terms, conditions, and exclusions clearly
                  </span>
                </li>
                <li>
                  <div className="insurance-benefit-icon"></div>
                  <span>
                    Help you avoid common mistakes when choosing home insurance
                  </span>
                </li>
                <li>
                  <div className="insurance-benefit-icon"></div>
                  <span>
                    Provide guidance on claim procedures and requirements
                  </span>
                </li>
              </ul>
            </div>
          </div>
        </section>

        {/* CTA Section */}
        <section className="insurance-cta">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Ready to Get Started?</h2>
            <p>
              Connect with our insurance assistance team to get the guidance you
              need for protecting your home.
            </p>
            <button
              onClick={handleGetAssistance}
              className="insurance-cta-button"
            >
              <Phone className="w-5 h-5" />
              Get Insurance Assistance
            </button>
          </div>
        </section>

        {/* Disclaimer */}
        <section className="insurance-disclaimer">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <p>
              We do not provide insurance directly. Insurance services are
              offered by third-party providers. Our role is limited to
              assistance and guidance only.
            </p>
          </div>
        </section>
      </div>
    </>
  );
}
