import React from 'react';
import { Shield, Umbrella, Heart, ArrowRight } from 'lucide-react';
import { Button } from '../../components/ui/button';
import { useNavigate } from 'react-router-dom';

export function HomeInsurancePremium() {
  const navigate = useNavigate();

  return (
    <>
      <style>{`
        .insurance-hero {
          background: linear-gradient(rgba(30, 41, 59, 0.9), rgba(30, 41, 59, 0.8)), url('https://images.unsplash.com/photo-1582407947304-fd86f028f716?ixlib=rb-4.0.3&auto=format&fit=crop&w=2096&q=80') !important;
          background-size: cover !important;
          background-position: center !important;
          padding: 8rem 0 !important;
          color: white !important;
          text-align: center !important;
        }
        .insurance-hero h1 {
          font-size: 3.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .insurance-hero p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          max-width: 50rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
          line-height: 1.7 !important;
        }
        .insurance-pricing {
          background: rgba(255, 255, 255, 0.95) !important;
          color: #1e293b !important;
          padding: 1.5rem 3rem !important;
          border-radius: 1rem !important;
          font-weight: 600 !important;
          font-size: 1.1rem !important;
          display: inline-block !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1) !important;
          backdrop-filter: blur(10px) !important;
        }
        .insurance-features {
          padding: 6rem 2rem !important;
          background: #f8fafc !important;
        }
        .insurance-features h2 {
          font-size: 2.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .insurance-feature-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .insurance-feature-card {
          background: white !important;
          padding: 0 !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          text-align: center !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
          overflow: hidden !important;
        }
        .insurance-feature-image {
          width: 100% !important;
          height: 200px !important;
          object-fit: cover !important;
        }
        .insurance-feature-content {
          padding: 2rem !important;
        }
        .insurance-feature-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
          border-color: #cbd5e1 !important;
        }
        .insurance-feature-card h3 {
          font-size: 1.5rem !important;
          font-weight: 600 !important;
          margin-bottom: 1rem !important;
          color: #1e293b !important;
        }
        .insurance-feature-card p {
          color: #64748b !important;
          line-height: 1.7 !important;
          font-size: 1rem !important;
        }
        .insurance-benefits {
          padding: 6rem 2rem !important;
          background: white !important;
        }
        .insurance-benefits h2 {
          font-size: 2.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .insurance-benefit-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .insurance-benefit-card {
          background: #f8fafc !important;
          padding: 3rem !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
        }
        .insurance-benefit-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
        }
        .insurance-benefit-card h3 {
          font-size: 1.625rem !important;
          font-weight: 600 !important;
          margin-bottom: 1.5rem !important;
          color: #1e293b !important;
        }
        .insurance-benefit-list {
          list-style: none !important;
          padding: 0 !important;
        }
        .insurance-benefit-item {
          display: flex !important;
          align-items: center !important;
          gap: 0.75rem !important;
          margin-bottom: 0.75rem !important;
        }
        .insurance-benefit-icon {
          background: #dcfce7 !important;
          border-radius: 50% !important;
          padding: 0.25rem !important;
          width: 1.5rem !important;
          height: 1.5rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
        }
        .insurance-benefit-icon::after {
          content: '✓' !important;
          color: #059669 !important;
          font-weight: bold !important;
          font-size: 0.75rem !important;
        }
        .insurance-benefit-text {
          color: #475569 !important;
          line-height: 1.7 !important;
          font-size: 1rem !important;
        }
        .insurance-cta {
          padding: 8rem 2rem !important;
          background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #334155 100%) !important;
          color: white !important;
          text-align: center !important;
          position: relative !important;
          overflow: hidden !important;
        }
        .insurance-cta::before {
          content: '' !important;
          position: absolute !important;
          top: 0 !important;
          left: 0 !important;
          right: 0 !important;
          bottom: 0 !important;
          background: radial-gradient(circle at 30% 20%, rgba(59, 130, 246, 0.1) 0%, transparent 50%), radial-gradient(circle at 70% 80%, rgba(37, 99, 235, 0.1) 0%, transparent 50%) !important;
        }
        .insurance-cta-card {
          background: rgba(255, 255, 255, 0.05) !important;
          backdrop-filter: blur(20px) !important;
          border: 1px solid rgba(255, 255, 255, 0.1) !important;
          border-radius: 2rem !important;
          padding: 4rem !important;
          max-width: 50rem !important;
          margin: 0 auto !important;
          position: relative !important;
          box-shadow: 0 25px 50px rgba(0, 0, 0, 0.25) !important;
        }
        .insurance-cta h2 {
          font-size: 2.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .insurance-cta p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          line-height: 1.6 !important;
        }
        .insurance-cta-button {
          background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%) !important;
          color: white !important;
          padding: 1.25rem 3rem !important;
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          border-radius: 12px !important;
          box-shadow: 0 8px 25px rgba(30, 41, 59, 0.25) !important;
          transition: all 0.3s ease !important;
          border: none !important;
          cursor: pointer !important;
          position: relative !important;
          overflow: hidden !important;
        }
        .insurance-cta-button:hover {
          transform: translateY(-2px) !important;
          box-shadow: 0 12px 35px rgba(30, 41, 59, 0.35) !important;
          background: linear-gradient(135deg, #334155 0%, #1e293b 100%) !important;
        }
        .insurance-cta-button::before {
          content: '' !important;
          position: absolute !important;
          top: 0 !important;
          left: -100% !important;
          width: 100% !important;
          height: 100% !important;
          background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent) !important;
          transition: left 0.5s !important;
        }
        .insurance-cta-button:hover::before {
          left: 100% !important;
        }
      `}</style>
      <div className="min-h-screen bg-white">
        {/* Hero Section */}
        <header className="insurance-hero">
          <div>
            <h1>Home Insurance Assistance</h1>
            <p>
              Comprehensive home insurance solutions to protect your property investment. Compare plans from top insurers.
            </p>
            <div className="insurance-pricing">
              Basic Coverage: ₹12,999/year | Comprehensive: ₹22,999/year | Premium: ₹35,999/year | Ultra Premium: ₹55,999/year
            </div>
          </div>
        </header>

        {/* Benefits Section */}
        <section className="insurance-benefits">
          <h2>Complete Protection for Your Home</h2>
          <div className="insurance-benefit-grid">
            <div className="insurance-benefit-card">
              <h3>Property Protection</h3>
              <ul className="insurance-benefit-list">
                <li className="insurance-benefit-item">
                  <div className="insurance-benefit-icon"></div>
                  <span className="insurance-benefit-text">Comprehensive coverage up to ₹5 crores for structure and ₹50 lakhs for contents</span>
                </li>
                <li className="insurance-benefit-item">
                  <div className="insurance-benefit-icon"></div>
                  <span className="insurance-benefit-text">Complete protection against earthquakes, floods, cyclones, and fire damage</span>
                </li>
                <li className="insurance-benefit-item">
                  <div className="insurance-benefit-icon"></div>
                  <span className="insurance-benefit-text">Comprehensive theft protection including jewelry, electronics, and valuable documents</span>
                </li>
              </ul>
            </div>
            <div className="insurance-benefit-card">
              <h3>Quick Claims</h3>
              <ul className="insurance-benefit-list">
                <li className="insurance-benefit-item">
                  <div className="insurance-benefit-icon"></div>
                  <span className="insurance-benefit-text">Dedicated claim support with average settlement time of 7-10 business days</span>
                </li>
                <li className="insurance-benefit-item">
                  <div className="insurance-benefit-icon"></div>
                  <span className="insurance-benefit-text">Digital claim processing with AI-powered damage assessment and instant approvals up to ₹2 lakhs</span>
                </li>
                <li className="insurance-benefit-item">
                  <div className="insurance-benefit-icon"></div>
                  <span className="insurance-benefit-text">Pan-India network of 2,500+ authorized repair centers with cashless settlement facility</span>
                </li>
              </ul>
            </div>
          </div>
        </section>

        {/* Features Section */}
        <section className="insurance-features">
          <h2>Comprehensive Insurance Solutions</h2>
          <div className="insurance-feature-grid">
            <div className="insurance-feature-card">
              <img 
                src="https://images.unsplash.com/photo-1558618666-fcd25c85cd64?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                alt="Property Coverage" 
                className="insurance-feature-image"
              />
              <div className="insurance-feature-content">
                <h3>Property Coverage</h3>
                <p>Complete protection for your home structure and belongings</p>
              </div>
            </div>
            <div className="insurance-feature-card">
              <img 
                src="https://images.unsplash.com/photo-1450101499163-c8848c66ca85?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                alt="Liability Protection" 
                className="insurance-feature-image"
              />
              <div className="insurance-feature-content">
                <h3>Liability Protection</h3>
                <p>Coverage for third-party injuries and property damage</p>
              </div>
            </div>
            <div className="insurance-feature-card">
              <img 
                src="https://images.unsplash.com/photo-1600880292203-757bb62b4baf?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                alt="Personal Support" 
                className="insurance-feature-image"
              />
              <div className="insurance-feature-content">
                <h3>Personal Support</h3>
                <p>Dedicated insurance advisor and claim assistance</p>
              </div>
            </div>
          </div>
        </section>

        {/* CTA Section */}
        <section className="insurance-cta">
          <div className="insurance-cta-card">
            <h2>Protect Your Home Today</h2>
            <p>
              Get instant quotes from top insurance providers
            </p>
            <Button className="insurance-cta-button">
              Get Insurance Quote
              <ArrowRight className="w-5 h-5 ml-2" />
            </Button>
          </div>
        </section>
      </div>
    </>
  );
}