import React, { useEffect } from 'react';
import { useNavigate } from 'react-router-dom';
import { CheckCircle, Phone, Mail, Shield, Clock, Users, TrendingUp, Award, FileText } from 'lucide-react';
import { Button } from '../../components/ui/button';

export function LegalLoanAssistance() {
  const navigate = useNavigate();

  useEffect(() => {
    window.scrollTo(0, 0);
  }, []);

  return (
    <>
      <style>{`
        .legal-hero {
          background: linear-gradient(135deg, #1e293b 0%, #334155 100%) !important;
          padding: 6rem 0 !important;
          color: white !important;
          text-align: center !important;
        }
        .legal-hero h1 {
          font-size: 3.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .legal-hero p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          max-width: 50rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
          line-height: 1.7 !important;
        }
        .legal-pricing {
          background: rgba(255, 255, 255, 0.95) !important;
          color: #1e293b !important;
          padding: 1.25rem 2.5rem !important;
          border-radius: 0.75rem !important;
          font-weight: 600 !important;
          font-size: 1rem !important;
          display: inline-block !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
        }
        .legal-stats {
          padding: 5rem 1rem !important;
          background: white !important;
        }
        .legal-stat-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .legal-stat-card {
          background: #f8fafc !important;
          padding: 2.5rem !important;
          border-radius: 0.75rem !important;
          text-align: center !important;
          border: 1px solid #e2e8f0 !important;
          transition: all 0.3s ease !important;
        }
        .legal-stat-card:hover {
          transform: translateY(-0.125rem) !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1) !important;
        }
        .legal-stat-card h3 {
          font-size: 2rem !important;
          font-weight: 700 !important;
          margin-bottom: 0.5rem !important;
          color: #1e293b !important;
        }
        .legal-stat-card p {
          color: #64748b !important;
          font-weight: 500 !important;
        }
        .legal-content {
          padding: 5rem 1rem !important;
          background: #f8fafc !important;
        }
        .legal-content h2 {
          font-size: 2.5rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .legal-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 80rem !important;
          margin: 0 auto !important;
        }
        .legal-card {
          background: white !important;
          padding: 2.5rem !important;
          border-radius: 0.75rem !important;
          box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important;
          border: 1px solid #e2e8f0 !important;
          transition: all 0.3s ease !important;
        }
        .legal-card:hover {
          transform: translateY(-0.125rem) !important;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1) !important;
        }
        .legal-card h2 {
          font-size: 1.5rem !important;
          font-weight: 600 !important;
          margin-bottom: 1.5rem !important;
          color: #1e293b !important;
        }
        .legal-list {
          list-style: none !important;
          padding: 0 !important;
        }
        .legal-list li {
          display: flex !important;
          align-items: flex-start !important;
          gap: 0.75rem !important;
          margin-bottom: 1rem !important;
        }
        .legal-check {
          background: #dcfce7 !important;
          border-radius: 50% !important;
          padding: 0.25rem !important;
          width: 1.5rem !important;
          height: 1.5rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
          flex-shrink: 0 !important;
          margin-top: 0.125rem !important;
        }
        .legal-check::after {
          content: '✓' !important;
          color: #059669 !important;
          font-weight: bold !important;
          font-size: 0.75rem !important;
        }
        .legal-text {
          color: #475569 !important;
          line-height: 1.6 !important;
        }

      `}</style>
      <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <div className="legal-hero">
        <div className="max-w-5xl mx-auto px-4">
          <h1 className="legal-hero h1">Legal & Home Loan Assistance</h1>
          <p className="legal-hero p">
            Navigate property transactions with confidence through expert guidance. Our legal experts and loan specialists have helped reduce average transaction time from 37 days to just 17 days through automation and streamlined processes. Access 25+ partner banks offering home loan interest rates from 8.5%-9.5% with approval in 4-8 days for qualified applicants.
          </p>
          <div className="legal-pricing">
            Legal Package: ₹15,999 | Loan Processing: ₹9,999 | Combined: ₹19,999 (Save ₹6,000)
          </div>
        </div>
      </div>

      {/* Stats Section */}
      <div className="legal-stats">
        <div className="legal-stat-grid">
          <div className="legal-stat-card">
            <h3>25+</h3>
            <p>Partner Banks</p>
          </div>
          <div className="legal-stat-card">
            <h3>15-20</h3>
            <p>Days Loan Approval</p>
          </div>
          <div className="legal-stat-card">
            <h3>50+</h3>
            <p>Cities Covered</p>
          </div>
          <div className="legal-stat-card">
            <h3>₹2L</h3>
            <p>Average Savings</p>
          </div>
        </div>
      </div>

      {/* Main Content */}
      <div className="legal-content">
        <h2>Our Services</h2>
        <div className="legal-grid">
          {/* Features */}
          <div className="legal-card">
            <h2>Key Features</h2>
            <ul className="legal-list">
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Title deed verification and encumbrance certificate analysis preventing fraud in 12-18% dispute cases</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Sale agreement drafting and legal review by qualified advocates empaneled across 50+ cities</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">RERA registration verification—1.19 lakh projects with 97 lakh units registered verified instantly</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Home loan pre-approval assistance with 25+ partner banks processing in 4-5 days for salaried, 7-10 days for self-employed</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Property document verification (NOC, Approvals, Tax receipts) using AI-enhanced systems</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Stamp duty and registration fee calculation for all states with new Registration Bill 2025 rates (₹50-₹100 in rural areas)</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Legal due diligence report with risk assessment reducing legal disputes by up to 25%</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">End-to-end loan processing support with average approval time of 15-20 days vs 45-60 days industry average</span>
              </li>
            </ul>
          </div>

          {/* Benefits */}
          <div className="legal-card">
            <h2>Benefits</h2>
            <ul className="legal-list">
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Save ₹50,000-₹2 lakhs on legal fees with our transparent fixed-price packages</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Get home loans at lowest interest rates (8.5%-9.5% current rates) through our 25+ bank partnerships</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Avoid legal disputes with comprehensive title verification—1.25 lakh RERA complaints resolved to date</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Faster loan approval - 15-20 days vs 45-60 days industry average with complete documentation support</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Expert guidance on tax benefits under Section 80C and 24(b) maximizing your savings</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Complete transparency with regular status updates via SMS/email and digital tracking</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Access to empaneled lawyers in 50+ cities with expertise in Registration Bill 2025 compliance</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Insurance guidance for property and loan protection with comprehensive coverage options</span>
              </li>
            </ul>
          </div>

          {/* Process */}
          <div className="legal-card">
            <h2>How It Works</h2>
            <ul className="legal-list">
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Free consultation call to assess your property and loan requirements with expert advisors</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Document collection and legal verification by RERA-certified advocates within 3-5 days</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Loan application submission to multiple banks for best rates—comparing 25+ lenders</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Legal clearance certificate and loan sanction coordination with 48-hour processing for qualified applicants</span>
              </li>
              <li>
                <div className="legal-check"></div>
                <span className="legal-text">Registration support using new digital systems and loan disbursement completion with Aadhaar-based verification</span>
              </li>
            </ul>
          </div>
        </div>
      </div>


    </div>
    </>
  );
}