import React, { useState } from "react";
import {
  Home,
  Users,
  Wrench,
  Settings,
  ArrowRight,
  MapPin,
  Shield,
  TrendingUp,
  Calendar,
  Clock,
  Phone,
  Mail,
  FileText,
  Download,
  Star,
  Award,
  Calculator,
  ChevronDown,
  ChevronUp,
  CheckCircle,
  Smartphone,
  Database,
  Receipt,
  Scale,
  Building,
  UserCheck,
  AlertTriangle,
  PieChart,
  Play,
  Map,
  BookOpen,
  Trophy,
  User,
} from "lucide-react";
import { Button } from "../../components/ui/button";
import { useNavigate } from "react-router-dom";

export function PropertyManagementPremium() {
  const navigate = useNavigate();
  const [activeTab, setActiveTab] = useState("management");
  const [propertyValue, setPropertyValue] = useState("");
  const [monthlyRent, setMonthlyRent] = useState("");
  const [openFaq, setOpenFaq] = useState<number | null>(null);
  const [showComparison, setShowComparison] = useState(false);
  const [selectedPlan, setSelectedPlan] = useState<string | null>(null);
  const [activeTestimonial, setActiveTestimonial] = useState(0);
  const [currentVacancyRate, setCurrentVacancyRate] = useState("");
  const [currentMaintenanceCosts, setCurrentMaintenanceCosts] = useState("");
  const [showQuiz, setShowQuiz] = useState(false);
  const [quizAnswers, setQuizAnswers] = useState<{
    propertyCount?: string;
    complexity?: string;
    timeCommitment?: string;
    budget?: string;
  }>({});
  const [recommendedPlan, setRecommendedPlan] = useState("");
  const [activeVideo, setActiveVideo] = useState<string | null>(null);
  const [selectedServiceArea, setSelectedServiceArea] = useState("mumbai");

  const calculateROI = () => {
    if (!propertyValue || !monthlyRent) return null;
    const value = parseFloat(propertyValue) || 0;
    const rent = parseFloat(monthlyRent) || 0;
    const annualRent = rent * 12;
    const currentVacancy = parseFloat(currentVacancyRate) || 60; // Default market average
    const currentMaintenance =
      parseFloat(currentMaintenanceCosts) || annualRent * 0.15; // Default 15% of rent

    const managementFees = {
      basic: annualRent * 0.1,
      premium: annualRent * 0.15,
      enterprise: annualRent * 0.2,
    };

    // Calculate improvements with NAL India
    const improvedVacancyDays = 12; // NAL India average
    const vacancyImprovement =
      currentVacancy > improvedVacancyDays
        ? ((currentVacancy - improvedVacancyDays) / 365) * annualRent
        : 0;
    const maintenanceImprovement = currentMaintenance * 0.25; // 25% savings

    // Before NAL calculations
    const beforeVacancyLoss = (currentVacancy / 365) * annualRent;
    const beforeNetIncome = annualRent - beforeVacancyLoss - currentMaintenance;
    const beforeROI = value > 0 ? (beforeNetIncome / value) * 100 : 0;

    return {
      grossYield: value > 0 ? ((annualRent / value) * 100).toFixed(2) : "0.00",
      beforeROI: beforeROI.toFixed(2),
      beforeNetIncome,
      beforeVacancyLoss,
      currentMaintenance,
      netYield: {
        basic:
          value > 0
            ? (
                ((annualRent -
                  managementFees.basic +
                  vacancyImprovement +
                  maintenanceImprovement) /
                  value) *
                100
              ).toFixed(2)
            : "0.00",
        premium:
          value > 0
            ? (
                ((annualRent -
                  managementFees.premium +
                  vacancyImprovement +
                  maintenanceImprovement) /
                  value) *
                100
              ).toFixed(2)
            : "0.00",
        enterprise:
          value > 0
            ? (
                ((annualRent -
                  managementFees.enterprise +
                  vacancyImprovement +
                  maintenanceImprovement) /
                  value) *
                100
              ).toFixed(2)
            : "0.00",
      },
      managementFees,
      vacancyImprovement,
      maintenanceImprovement,
      annualRent,
    };
  };

  const handleQuizComplete = (answers: {
    propertyCount?: string;
    complexity?: string;
    timeCommitment?: string;
    budget?: string;
  }) => {
    let score = 0;
    if (answers.propertyCount === "multiple") score += 2;
    if (answers.complexity === "high") score += 2;
    if (answers.timeCommitment === "minimal") score += 1;
    if (answers.budget === "premium") score += 1;

    if (score >= 4) setRecommendedPlan("Enterprise Solution");
    else if (score >= 2) setRecommendedPlan("Premium Management");
    else setRecommendedPlan("Basic Management");

    setShowQuiz(false);
  };

  const roiData = calculateROI();

  const teamMembers = [
    {
      name: "Rajesh Kumar",
      role: "Senior Property Manager",
      experience: "12+ years",
      specialization: "Commercial Properties",
      image:
        "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=300&h=300&fit=crop&crop=face",
    },
    {
      name: "Priya Sharma",
      role: "Residential Specialist",
      experience: "8+ years",
      specialization: "Luxury Apartments",
      image:
        "https://images.unsplash.com/photo-1494790108755-2616b612b786?w=300&h=300&fit=crop&crop=face",
    },
    {
      name: "Amit Patel",
      role: "Maintenance Coordinator",
      experience: "10+ years",
      specialization: "Technical Operations",
      image:
        "https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=300&h=300&fit=crop&crop=face",
    },
    {
      name: "Sneha Reddy",
      role: "Client Relations Manager",
      experience: "6+ years",
      specialization: "Customer Success",
      image:
        "https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=300&h=300&fit=crop&crop=face",
    },
  ];

  const serviceAreas = {
    mumbai: {
      name: "Mumbai Metropolitan",
      areas: [
        "Bandra",
        "Andheri",
        "Powai",
        "Lower Parel",
        "Worli",
        "Juhu",
        "Malad",
        "Goregaon",
      ],
      properties: "2,500+",
    },
    pune: {
      name: "Pune & PCMC",
      areas: [
        "Koregaon Park",
        "Hinjewadi",
        "Wakad",
        "Baner",
        "Kharadi",
        "Magarpatta",
        "Hadapsar",
      ],
      properties: "1,800+",
    },
    bangalore: {
      name: "Bangalore Urban",
      areas: [
        "Whitefield",
        "Electronic City",
        "Koramangala",
        "Indiranagar",
        "HSR Layout",
        "Marathahalli",
      ],
      properties: "2,200+",
    },
    delhi: {
      name: "Delhi NCR",
      areas: [
        "Gurgaon",
        "Noida",
        "Greater Noida",
        "Faridabad",
        "Ghaziabad",
        "New Delhi",
      ],
      properties: "3,100+",
    },
  };

  const awards = [
    {
      title: "Best Property Management Company 2024",
      organization: "Real Estate Excellence Awards",
      year: "2024",
      icon: Trophy,
    },
    {
      title: "Customer Service Excellence",
      organization: "Property Management Association",
      year: "2023",
      icon: Award,
    },
    {
      title: "Technology Innovation Award",
      organization: "PropTech India",
      year: "2023",
      icon: Smartphone,
    },
    {
      title: "Certified Property Management Professional",
      organization: "IREM India Chapter",
      year: "2022",
      icon: CheckCircle,
    },
  ];

  const blogPosts = [
    {
      title: "Complete Guide to Property Management in Mumbai",
      excerpt:
        "Everything you need to know about managing rental properties in Mumbai's competitive market.",
      readTime: "8 min read",
      category: "Market Insights",
      image:
        "https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?w=400&h=250&fit=crop",
    },
    {
      title: "Maximizing Rental Yields: 10 Proven Strategies",
      excerpt:
        "Learn how to increase your property's rental income with these expert-tested methods.",
      readTime: "6 min read",
      category: "Investment Tips",
      image:
        "https://images.unsplash.com/photo-1560518883-ce09059eeffa?w=400&h=250&fit=crop",
    },
    {
      title: "Legal Updates: New Rental Laws in India 2024",
      excerpt:
        "Stay compliant with the latest changes in rental regulations and tenant rights.",
      readTime: "5 min read",
      category: "Legal Updates",
      image:
        "https://images.unsplash.com/photo-1589829545856-d10d557cf95f?w=400&h=250&fit=crop",
    },
  ];

  const videos = [
    {
      id: "property-tour",
      title: "Virtual Property Tour - Luxury Apartment",
      thumbnail:
        "https://images.unsplash.com/photo-1545324418-cc1a3fa10c00?w=400&h=250&fit=crop",
      duration: "3:45",
      category: "Property Tours",
    },
    {
      id: "management-process",
      title: "How NAL India Manages Your Property",
      thumbnail:
        "https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=400&h=250&fit=crop",
      duration: "5:20",
      category: "Process Overview",
    },
    {
      id: "client-testimonial",
      title: "Client Success Story - 300% ROI Increase",
      thumbnail:
        "https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?w=400&h=250&fit=crop",
      duration: "2:15",
      category: "Success Stories",
    },
  ];

  return (
    <>
      <style>{`
        /* Fix double border issue on inputs */
        input, textarea, select {
          border: 1px solid #D1D5DB !important;
          box-shadow: none !important;
          outline: none !important;
          background-clip: padding-box !important;
        }
        
        input:focus, textarea:focus, select:focus {
          border-color: #3b82f6 !important;
          box-shadow: 0 0 0 3px rgba(59,130,246,0.1) !important;
          outline: none !important;
        }
        
        .property-mgmt-hero {
          background: linear-gradient(rgba(30, 41, 59, 0.9), rgba(30, 41, 59, 0.8)), url('https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80') !important;
          background-size: cover !important;
          background-position: center !important;
          padding: 8rem 0 !important;
          color: white !important;
          text-align: center !important;
        }
        .property-mgmt-hero h1 {
          font-size: 3.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .property-mgmt-hero p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          max-width: 50rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
          line-height: 1.7 !important;
        }
        .property-mgmt-pricing {
          background: rgba(255, 255, 255, 0.95) !important;
          color: #1e293b !important;
          padding: 1.5rem 3rem !important;
          border-radius: 1rem !important;
          font-weight: 600 !important;
          font-size: 1.1rem !important;
          display: inline-block !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1) !important;
          backdrop-filter: blur(10px) !important;
        }
        .property-mgmt-features {
          padding: 6rem 2rem !important;
          background: #f8fafc !important;
        }
        .property-mgmt-features h2 {
          font-size: 2.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .property-mgmt-feature-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .property-mgmt-feature-card {
          background: white !important;
          padding: 0 !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          text-align: center !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
          overflow: hidden !important;
        }
        .property-mgmt-feature-image {
          width: 100% !important;
          height: 200px !important;
          object-fit: cover !important;
        }
        .property-mgmt-feature-content {
          padding: 2rem !important;
        }
        .property-mgmt-feature-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
          border-color: #cbd5e1 !important;
        }
        .property-mgmt-feature-card h3 {
          font-size: 1.5rem !important;
          font-weight: 600 !important;
          margin-bottom: 1rem !important;
          color: #1e293b !important;
        }
        .property-mgmt-feature-card p {
          color: #64748b !important;
          line-height: 1.7 !important;
          font-size: 1rem !important;
        }
        .property-mgmt-benefits {
          padding: 6rem 2rem !important;
          background: white !important;
        }
        .property-mgmt-benefits h2 {
          font-size: 2.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 4rem !important;
          color: #1e293b !important;
          letter-spacing: -0.025em !important;
        }
        .property-mgmt-benefit-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)) !important;
          gap: 2rem !important;
          max-width: 72rem !important;
          margin: 0 auto !important;
        }
        .property-mgmt-benefit-card {
          background: #f8fafc !important;
          padding: 3rem !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
        }
        .property-mgmt-benefit-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
        }
        input[type="number"] {
          line-height: 1.2 !important;
          height: auto !important;
        }ty-mgmt-benefit-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
        }
        .property-mgmt-benefit-card h3 {
          font-size: 1.625rem !important;
          font-weight: 600 !important;
          margin-bottom: 1.5rem !important;
          color: #1e293b !important;
        }
        .property-mgmt-benefit-list {
          list-style: none !important;
          padding: 0 !important;
        }
        .property-mgmt-benefit-item {
          display: flex !important;
          align-items: center !important;
          gap: 0.75rem !important;
          margin-bottom: 0.75rem !important;
        }
        .property-mgmt-benefit-icon {
          background: #dcfce7 !important;
          border-radius: 50% !important;
          padding: 0.25rem !important;
          width: 1.5rem !important;
          height: 1.5rem !important;
          display: flex !important;
          align-items: center !important;
          justify-content: center !important;
        }
        .property-mgmt-benefit-icon::after {
          content: '✓' !important;
          color: #059669 !important;
          font-weight: bold !important;
          font-size: 0.75rem !important;
        }
        .property-mgmt-benefit-text {
          color: #475569 !important;
          line-height: 1.7 !important;
          font-size: 1rem !important;
        }
        .property-mgmt-cta {
          padding: 8rem 2rem !important;
          background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #334155 100%) !important;
          color: white !important;
          text-align: center !important;
          position: relative !important;
          overflow: hidden !important;
        }
        .property-mgmt-cta::before {
          content: '' !important;
          position: absolute !important;
          top: 0 !important;
          left: 0 !important;
          right: 0 !important;
          bottom: 0 !important;
          background: radial-gradient(circle at 30% 20%, rgba(168, 85, 247, 0.1) 0%, transparent 50%), radial-gradient(circle at 70% 80%, rgba(147, 51, 234, 0.1) 0%, transparent 50%) !important;
        }
        .property-mgmt-cta-card {
          background: rgba(255, 255, 255, 0.05) !important;
          backdrop-filter: blur(20px) !important;
          border: 1px solid rgba(255, 255, 255, 0.1) !important;
          border-radius: 2rem !important;
          padding: 4rem !important;
          max-width: 50rem !important;
          margin: 0 auto !important;
          position: relative !important;
          box-shadow: 0 25px 50px rgba(0, 0, 0, 0.25) !important;
        }
        .property-mgmt-cta h2 {
          font-size: 2.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .property-mgmt-cta p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          line-height: 1.6 !important;
        }
        .property-mgmt-cta-button {
          background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%) !important;
          color: white !important;
          padding: 1.25rem 3rem !important;
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          border-radius: 12px !important;
          box-shadow: 0 8px 25px rgba(30, 41, 59, 0.25) !important;
          transition: all 0.3s ease !important;
          border: none !important;
          cursor: pointer !important;
          position: relative !important;
          overflow: hidden !important;
        }
        .property-mgmt-cta-button:hover {
          transform: translateY(-2px) !important;
          box-shadow: 0 12px 35px rgba(30, 41, 59, 0.35) !important;
          background: linear-gradient(135deg, #334155 0%, #1e293b 100%) !important;
        }
        .property-mgmt-cta-button::before {
          content: '' !important;
          position: absolute !important;
          top: 0 !important;
          left: -100% !important;
          width: 100% !important;
          height: 100% !important;
          background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent) !important;
          transition: left 0.5s !important;
        }
        .property-mgmt-cta-button:hover::before {
          left: 100% !important;
        }
        .tab-content {
          animation: fadeIn 0.3s ease-in-out !important;
        }
        .services-tabs *::before,
        .services-tabs *::after {
          display: none !important;
        }
        .services-tabs > button:empty {
          display: none !important;
        }
        .services-tabs > *:not(button) {
          display: none !important;
        }
        .services-tabs button {
          background: transparent !important;
        }
        .services-tabs button.bg-blue-600 {
          background: #2563eb !important;
        }
        @keyframes fadeIn {
          from { opacity: 0; transform: translateY(10px); }
          to { opacity: 1; transform: translateY(0); }
        }  }
        .tab-content {
          animation: fadeIn 0.3s ease-in-out !important;
        }
        .services-tabs *::before,
        .services-tabs *::after {
          display: none !important;
        }
        .services-tabs > button:empty {
          display: none !important;
        }
        .services-tabs > *:not(button) {
          display: none !important;
        }
        .services-tabs button {
          background: transparent !important;
        }
        .services-tabs button.bg-blue-600 {
          background: #2563eb !important;
        }
        @keyframes fadeIn {
          from { opacity: 0; transform: translateY(10px); }
          to { opacity: 1; transform: translateY(0); }
        }
      `}</style>
      <div className="min-h-screen bg-white">
        {/* Hero Section */}
        <header className="property-mgmt-hero">
          <div>
            <h1>Property Management Services</h1>
            <p>
              Complete property management solutions for landlords and
              investors. Maximize returns with professional management.
            </p>
            <div className="property-mgmt-pricing">
              Basic Plan: 10% of rent | Premium Plan: 15% of rent | Full
              Service: 20% of rent | Enterprise: Custom pricing
            </div>
          </div>
        </header>

        {/* Key Value Propositions */}
        <section className="bg-white py-20">
          <div className="max-w-7xl mx-auto px-4">
            <h2 className="text-4xl font-bold text-center mb-16 text-gray-900">
              Why Choose Our Property Management
            </h2>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
              <div className="text-center p-6 bg-gradient-to-br from-green-50 to-green-100 rounded-2xl">
                <Receipt className="w-12 h-12 text-green-600 mx-auto mb-4" />
                <h3 className="text-xl font-bold mb-3 text-gray-900">
                  Guaranteed Rent Collection
                </h3>
                <p className="text-gray-600">
                  100% rent collection guarantee with automated payment
                  processing
                </p>
              </div>
              <div className="text-center p-6 bg-gradient-to-br from-blue-50 to-blue-100 rounded-2xl">
                <UserCheck className="w-12 h-12 text-blue-600 mx-auto mb-4" />
                <h3 className="text-xl font-bold mb-3 text-gray-900">
                  Verified Tenant Management
                </h3>
                <p className="text-gray-600">
                  Comprehensive tenant screening with KYC and background
                  verification
                </p>
              </div>
              <div className="text-center p-6 bg-gradient-to-br from-purple-50 to-purple-100 rounded-2xl">
                <FileText className="w-12 h-12 text-purple-600 mx-auto mb-4" />
                <h3 className="text-xl font-bold mb-3 text-gray-900">
                  Legal & Agreement Support
                </h3>
                <p className="text-gray-600">
                  Complete legal documentation and rental agreement management
                </p>
              </div>
              <div className="text-center p-6 bg-gradient-to-br from-orange-50 to-orange-100 rounded-2xl">
                <Phone className="w-12 h-12 text-orange-600 mx-auto mb-4" />
                <h3 className="text-xl font-bold mb-3 text-gray-900">
                  Dedicated Property Manager
                </h3>
                <p className="text-gray-600">
                  Personal relationship manager for all your property needs
                </p>
              </div>
              <div className="text-center p-6 bg-gradient-to-br from-red-50 to-red-100 rounded-2xl">
                <Wrench className="w-12 h-12 text-red-600 mx-auto mb-4" />
                <h3 className="text-xl font-bold mb-3 text-gray-900">
                  24×7 Maintenance Handling
                </h3>
                <p className="text-gray-600">
                  Round-the-clock maintenance support with trusted vendor
                  network
                </p>
              </div>
              <div className="text-center p-6 bg-gradient-to-br from-indigo-50 to-indigo-100 rounded-2xl">
                <Database className="w-12 h-12 text-indigo-600 mx-auto mb-4" />
                <h3 className="text-xl font-bold mb-3 text-gray-900">
                  Owner Portal
                </h3>
                <p className="text-gray-600">
                  Real-time dashboard to track everything about your property
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* What We Do - Core Services */}
        <section className="bg-gray-50 py-20">
          <div className="max-w-7xl mx-auto px-4">
            <h2 className="text-4xl font-bold text-center mb-16 text-gray-900">
              What We Do - Core Services
            </h2>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
              {/* Tenant Management */}
              <div className="bg-white p-8 rounded-2xl shadow-lg">
                <Users className="w-10 h-10 text-blue-600 mb-4" />
                <h3 className="text-xl font-bold mb-4 text-gray-900">
                  3.1 Tenant Management
                </h3>
                <ul className="space-y-2 text-gray-600">
                  <li>• Tenant onboarding</li>
                  <li>• Tenant verification</li>
                  <li>• Lease preparation</li>
                  <li>• Rent reminders</li>
                  <li>• Tenant exit process</li>
                </ul>
              </div>

              {/* Rent Management */}
              <div className="bg-white p-8 rounded-2xl shadow-lg">
                <Receipt className="w-10 h-10 text-green-600 mb-4" />
                <h3 className="text-xl font-bold mb-4 text-gray-900">
                  3.2 Rent Management
                </h3>
                <ul className="space-y-2 text-gray-600">
                  <li>• Monthly rent collection</li>
                  <li>• Payment reminders</li>
                  <li>• Late fee handling</li>
                  <li>• Auto-settlement to owner</li>
                  <li>• Rent receipts</li>
                </ul>
              </div>

              {/* Maintenance Management */}
              <div className="bg-white p-8 rounded-2xl shadow-lg">
                <Wrench className="w-10 h-10 text-orange-600 mb-4" />
                <h3 className="text-xl font-bold mb-4 text-gray-900">
                  3.3 Maintenance Management
                </h3>
                <ul className="space-y-2 text-gray-600">
                  <li>• 24/7 repair handling</li>
                  <li>• Vendor coordination</li>
                  <li>• Scheduled inspections</li>
                  <li>• AMC & cleaning</li>
                  <li>• Emergency support</li>
                </ul>
              </div>

              {/* Property Care */}
              <div className="bg-white p-8 rounded-2xl shadow-lg">
                <Home className="w-10 h-10 text-purple-600 mb-4" />
                <h3 className="text-xl font-bold mb-4 text-gray-900">
                  3.4 Property Care
                </h3>
                <ul className="space-y-2 text-gray-600">
                  <li>• Property inspections</li>
                  <li>• Move-in/move-out reports</li>
                  <li>• Cleaning & repairs</li>
                  <li>• Painting, electrical, plumbing</li>
                  <li>• Regular check-ups</li>
                </ul>
              </div>

              {/* Legal & Documentation */}
              <div className="bg-white p-8 rounded-2xl shadow-lg">
                <FileText className="w-10 h-10 text-red-600 mb-4" />
                <h3 className="text-xl font-bold mb-4 text-gray-900">
                  3.5 Legal & Documentation
                </h3>
                <ul className="space-y-2 text-gray-600">
                  <li>• Rental agreement</li>
                  <li>• Police verification</li>
                  <li>• Notice drafting</li>
                  <li>• Eviction support</li>
                  <li>• Rent dispute assistance</li>
                </ul>
              </div>

              {/* Owner Support */}
              <div className="bg-white p-8 rounded-2xl shadow-lg">
                <Phone className="w-10 h-10 text-indigo-600 mb-4" />
                <h3 className="text-xl font-bold mb-4 text-gray-900">
                  3.6 Owner Support
                </h3>
                <ul className="space-y-2 text-gray-600">
                  <li>• Monthly statements</li>
                  <li>• Expense reports</li>
                  <li>• Service history</li>
                  <li>• One dedicated relationship manager</li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        {/* 6-Step Workflow Process */}
        <section className="bg-white py-20">
          <div className="max-w-4xl mx-auto px-4">
            <h2 className="text-4xl font-bold text-center mb-16 text-gray-900">
              6-Step Workflow Process
            </h2>
            <div className="space-y-8">
              {[
                {
                  step: 1,
                  title: "Property Onboarding",
                  desc: "Complete property assessment and documentation",
                },
                {
                  step: 2,
                  title: "Tenant Assignment",
                  desc: "Professional tenant screening and placement",
                },
                {
                  step: 3,
                  title: "Rent Management",
                  desc: "Automated collection and payment processing",
                },
                {
                  step: 4,
                  title: "Maintenance",
                  desc: "24/7 repair coordination and vendor management",
                },
                {
                  step: 5,
                  title: "Inspections",
                  desc: "Regular property inspections and condition reports",
                },
                {
                  step: 6,
                  title: "Reporting",
                  desc: "Monthly statements and performance analytics",
                },
              ].map((item, index) => (
                <div
                  key={index}
                  className="flex items-start gap-6 p-6 bg-gray-50 rounded-2xl"
                >
                  <div className="w-12 h-12 bg-blue-600 text-white rounded-full flex items-center justify-center text-xl font-bold flex-shrink-0">
                    {item.step}
                  </div>
                  <div>
                    <h3 className="text-xl font-bold text-gray-900 mb-2">
                      {item.title}
                    </h3>
                    <p className="text-gray-600">{item.desc}</p>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Owner Dashboard Preview */}
        <section className="bg-gradient-to-br from-blue-50 to-indigo-100 py-20">
          <div className="max-w-6xl mx-auto px-4">
            <h2 className="text-4xl font-bold text-center mb-16 text-gray-900">
              Owner Dashboard Preview
            </h2>
            <div className="bg-white rounded-2xl p-8 shadow-2xl">
              <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-8">
                <div className="bg-green-50 p-6 rounded-xl text-center">
                  <Receipt className="w-12 h-12 text-green-600 mx-auto mb-4" />
                  <div className="text-3xl font-bold text-green-600">
                    ₹45,000
                  </div>
                  <div className="text-gray-600">Rent Collected This Month</div>
                </div>
                <div className="bg-blue-50 p-6 rounded-xl text-center">
                  <Wrench className="w-12 h-12 text-blue-600 mx-auto mb-4" />
                  <div className="text-3xl font-bold text-blue-600">3</div>
                  <div className="text-gray-600">
                    Active Maintenance Requests
                  </div>
                </div>
                <div className="bg-purple-50 p-6 rounded-xl text-center">
                  <Users className="w-12 h-12 text-purple-600 mx-auto mb-4" />
                  <div className="text-3xl font-bold text-purple-600">2</div>
                  <div className="text-gray-600">Active Tenants</div>
                </div>
              </div>
              <div className="text-center text-gray-600">
                <p className="text-lg">
                  Real-time insights into your property performance, rent
                  collection, and maintenance status
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Maintenance Tracker Preview */}
        <section className="bg-gradient-to-br from-orange-50 to-red-100 py-20">
          <div className="max-w-6xl mx-auto px-4">
            <h2 className="text-4xl font-bold text-center mb-16 text-gray-900">
              Maintenance Tracker Preview
            </h2>
            <div className="bg-white rounded-2xl p-8 shadow-2xl">
              <div className="space-y-6">
                <div className="flex items-center justify-between p-6 bg-yellow-50 rounded-xl border-l-4 border-yellow-400">
                  <div className="flex items-center gap-4">
                    <AlertTriangle className="w-8 h-8 text-yellow-600" />
                    <div>
                      <div className="text-lg font-semibold text-gray-900">
                        Plumbing Issue - Kitchen Sink
                      </div>
                      <div className="text-sm text-gray-600">
                        Reported: 2 hours ago
                      </div>
                    </div>
                  </div>
                  <div className="bg-yellow-100 text-yellow-800 px-4 py-2 rounded-full text-sm font-medium">
                    In Progress
                  </div>
                </div>
                <div className="flex items-center justify-between p-6 bg-green-50 rounded-xl border-l-4 border-green-400">
                  <div className="flex items-center gap-4">
                    <CheckCircle className="w-8 h-8 text-green-600" />
                    <div>
                      <div className="text-lg font-semibold text-gray-900">
                        AC Servicing - Living Room
                      </div>
                      <div className="text-sm text-gray-600">
                        Completed: Yesterday
                      </div>
                    </div>
                  </div>
                  <div className="bg-green-100 text-green-800 px-4 py-2 rounded-full text-sm font-medium">
                    Completed
                  </div>
                </div>
              </div>
              <div className="text-center text-gray-600 mt-8">
                <p className="text-lg">
                  Track all maintenance requests with real-time status updates
                  and photo documentation
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Tenant App Features */}
        <section className="bg-gradient-to-br from-purple-50 to-pink-100 py-20">
          <div className="max-w-6xl mx-auto px-4">
            <h2 className="text-4xl font-bold text-center mb-16 text-gray-900">
              Tenant App Features
            </h2>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
              <div className="bg-white p-8 rounded-2xl shadow-lg text-center">
                <Smartphone className="w-16 h-16 text-blue-600 mx-auto mb-6" />
                <h3 className="text-xl font-semibold mb-4 text-gray-900">
                  Pay Rent
                </h3>
                <p className="text-gray-600">
                  Easy online rent payment with multiple payment options
                </p>
              </div>
              <div className="bg-white p-8 rounded-2xl shadow-lg text-center">
                <Settings className="w-16 h-16 text-green-600 mx-auto mb-6" />
                <h3 className="text-xl font-semibold mb-4 text-gray-900">
                  Raise Issue
                </h3>
                <p className="text-gray-600">
                  Report maintenance issues with photo attachments
                </p>
              </div>
              <div className="bg-white p-8 rounded-2xl shadow-lg text-center">
                <Download className="w-16 h-16 text-purple-600 mx-auto mb-6" />
                <h3 className="text-xl font-semibold mb-4 text-gray-900">
                  Download Agreements
                </h3>
                <p className="text-gray-600">
                  Access all rental documents and agreements
                </p>
              </div>
              <div className="bg-white p-8 rounded-2xl shadow-lg text-center">
                <Phone className="w-16 h-16 text-orange-600 mx-auto mb-6" />
                <h3 className="text-xl font-semibold mb-4 text-gray-900">
                  Chat Support
                </h3>
                <p className="text-gray-600">
                  24/7 chat support for all queries and assistance
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Performance Guarantees */}
        <section className="bg-green-50 py-12">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-8">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Our Performance Guarantees
              </h2>
              <p className="text-lg text-gray-600">
                We back our services with industry-leading guarantees
              </p>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
              {[
                {
                  title: "Rent Collection Guarantee",
                  description:
                    "99.5% on-time collection or we waive our fee for that month",
                  icon: Receipt,
                  highlight: "99.5% Success Rate",
                },
                {
                  title: "Vacancy Period Guarantee",
                  description:
                    "Find quality tenants within 30 days or reduce management fee by 50%",
                  icon: Clock,
                  highlight: "30-Day Maximum",
                },
                {
                  title: "Maintenance Response Guarantee",
                  description:
                    "2-hour emergency response time with 24/7 support hotline",
                  icon: Wrench,
                  highlight: "2-Hour Response",
                },
              ].map((guarantee, index) => (
                <div
                  key={index}
                  className="bg-white rounded-2xl p-6 shadow-lg border border-green-200"
                >
                  <div className="flex items-center mb-4">
                    <div className="bg-green-100 p-3 rounded-lg mr-4">
                      <guarantee.icon className="w-6 h-6 text-green-600" />
                    </div>
                    <h3 className="text-lg font-bold text-gray-900">
                      {guarantee.title}
                    </h3>
                  </div>

                  <div className="bg-green-100 text-green-800 text-sm font-semibold px-3 py-1 rounded-full mb-3 inline-block">
                    {guarantee.highlight}
                  </div>

                  <p className="text-gray-600">{guarantee.description}</p>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Benefits Section */}
        <section className="property-mgmt-benefits">
          <h2>Professional Property Management</h2>
          <div className="property-mgmt-benefit-grid">
            <div className="property-mgmt-benefit-card">
              <h3>Revenue Optimization</h3>
              <ul className="property-mgmt-benefit-list">
                <li className="property-mgmt-benefit-item">
                  <div className="property-mgmt-benefit-icon"></div>
                  <span className="property-mgmt-benefit-text">
                    Dynamic rent optimization based on real-time Indian market
                    analysis increasing returns by 15-22% in metro cities
                  </span>
                </li>
                <li className="property-mgmt-benefit-item">
                  <div className="property-mgmt-benefit-icon"></div>
                  <span className="property-mgmt-benefit-text">
                    Average vacancy period reduced to 12 days compared to Indian
                    market average of 60 days
                  </span>
                </li>
                <li className="property-mgmt-benefit-item">
                  <div className="property-mgmt-benefit-icon"></div>
                  <span className="property-mgmt-benefit-text">
                    99.5% on-time rent collection rate with UPI integration,
                    automated reminders, and legal support network
                  </span>
                </li>
              </ul>
            </div>
            <div className="property-mgmt-benefit-card">
              <h3>Maintenance Excellence</h3>
              <ul className="property-mgmt-benefit-list">
                <li className="property-mgmt-benefit-item">
                  <div className="property-mgmt-benefit-icon"></div>
                  <span className="property-mgmt-benefit-text">
                    Round-the-clock maintenance with 2-hour emergency response
                    time guarantee
                  </span>
                </li>
                <li className="property-mgmt-benefit-item">
                  <div className="property-mgmt-benefit-icon"></div>
                  <span className="property-mgmt-benefit-text">
                    Network of 500+ verified contractors with insurance coverage
                    and quality assurance programs
                  </span>
                </li>
                <li className="property-mgmt-benefit-item">
                  <div className="property-mgmt-benefit-icon"></div>
                  <span className="property-mgmt-benefit-text">
                    IoT-enabled predictive maintenance with annual AMC for
                    electrical, plumbing, and HVAC systems
                  </span>
                </li>
              </ul>
            </div>
          </div>
        </section>

        {/* Features Section */}
        <section className="property-mgmt-features">
          <h2>Comprehensive Management Solutions</h2>
          <div className="property-mgmt-feature-grid">
            <div className="property-mgmt-feature-card">
              <img
                src="https://images.unsplash.com/photo-1582407947304-fd86f028f716?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                alt="Property Care"
                className="property-mgmt-feature-image"
              />
              <div className="property-mgmt-feature-content">
                <h3>Property Care</h3>
                <p>Complete property maintenance and upkeep services</p>
              </div>
            </div>
            <div className="property-mgmt-feature-card">
              <img
                src="https://images.unsplash.com/photo-1556742049-0cfed4f6a45d?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                alt="Tenant Management"
                className="property-mgmt-feature-image"
              />
              <div className="property-mgmt-feature-content">
                <h3>Tenant Management</h3>
                <p>Screening, leasing, and tenant relationship management</p>
              </div>
            </div>
            <div className="property-mgmt-feature-card">
              <img
                src="https://images.unsplash.com/photo-1621905251918-48416bd8575a?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                alt="Maintenance Services"
                className="property-mgmt-feature-image"
              />
              <div className="property-mgmt-feature-content">
                <h3>Maintenance Services</h3>
                <p>24/7 emergency repairs and scheduled maintenance</p>
              </div>
            </div>
          </div>
        </section>

        {/* ROI Calculator */}
        <section className="bg-blue-50 py-12">
          <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-8">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                <Calculator className="w-8 h-8 inline-block mr-3 text-blue-600" />
                ROI Calculator
              </h2>
              <p className="text-lg text-gray-600">
                Calculate your potential returns with our management services
              </p>
            </div>

            <div className="bg-white rounded-2xl p-8 shadow-xl">
              <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
                <div>
                  <h3 className="text-xl font-bold text-gray-900 mb-6">
                    Property Details
                  </h3>
                  <div className="space-y-4">
                    <div>
                      <label className="block text-sm font-medium text-gray-700 mb-2">
                        Property Value (₹)
                      </label>
                      <input
                        type="number"
                        value={propertyValue}
                        onChange={(e) => setPropertyValue(e.target.value)}
                        placeholder="e.g., 5000000"
                        className="w-full px-4 py-3 border border-gray-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none transition-all"
                      />
                    </div>
                    <div>
                      <label className="block text-sm font-medium text-gray-700 mb-2">
                        Expected Monthly Rent (₹)
                      </label>
                      <input
                        type="number"
                        value={monthlyRent}
                        onChange={(e) => setMonthlyRent(e.target.value)}
                        placeholder="e.g., 25000"
                        className="w-full px-4 py-3 border border-gray-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none transition-all"
                      />
                    </div>
                    <div>
                      <label className="block text-sm font-medium text-gray-700 mb-2">
                        Current Vacancy Period (days) - Optional
                      </label>
                      <input
                        type="number"
                        value={currentVacancyRate}
                        onChange={(e) => setCurrentVacancyRate(e.target.value)}
                        placeholder="e.g., 60"
                        className="w-full px-4 py-3 border border-gray-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none"
                      />
                    </div>
                    <div>
                      <label className="block text-sm font-medium text-gray-700 mb-2">
                        Annual Maintenance Costs (₹) - Optional
                      </label>
                      <input
                        type="number"
                        value={currentMaintenanceCosts}
                        onChange={(e) =>
                          setCurrentMaintenanceCosts(e.target.value)
                        }
                        placeholder="e.g., 50000"
                        className="w-full px-4 py-3 border border-gray-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none"
                      />
                    </div>
                  </div>
                </div>

                {roiData && (
                  <div>
                    <h3 className="text-xl font-bold text-gray-900 mb-6">
                      Real-time ROI Analysis
                    </h3>

                    {/* Before vs After Comparison */}
                    <div className="bg-gradient-to-r from-red-50 to-green-50 p-6 rounded-xl mb-6">
                      <h4 className="font-bold text-gray-900 mb-4 text-center">
                        Before NAL vs With NAL India
                      </h4>
                      <div className="grid grid-cols-2 gap-4">
                        <div className="text-center p-4 bg-red-100 rounded-lg">
                          <div className="text-sm text-red-700 font-medium">
                            Self Management
                          </div>
                          <div className="text-2xl font-bold text-red-600">
                            {roiData.beforeROI}%
                          </div>
                          <div className="text-xs text-red-600">Annual ROI</div>
                        </div>
                        <div className="text-center p-4 bg-green-100 rounded-lg">
                          <div className="text-sm text-green-700 font-medium">
                            With NAL Premium
                          </div>
                          <div className="text-2xl font-bold text-green-600">
                            {roiData.netYield.premium}%
                          </div>
                          <div className="text-xs text-green-600">
                            Annual ROI
                          </div>
                        </div>
                      </div>
                      <div className="text-center mt-3">
                        <span className="bg-green-500 text-white px-3 py-1 rounded-full text-sm font-bold">
                          +
                          {(
                            parseFloat(roiData.netYield.premium) -
                            parseFloat(roiData.beforeROI)
                          ).toFixed(1)}
                          % Improvement 📈
                        </span>
                      </div>
                    </div>

                    {/* Savings Breakdown */}
                    <div className="bg-blue-50 p-4 rounded-lg mb-6">
                      <h4 className="font-semibold text-blue-900 mb-3">
                        Annual Savings Breakdown
                      </h4>
                      <div className="space-y-2">
                        <div className="flex justify-between">
                          <span className="text-blue-700">
                            Vacancy Reduction:
                          </span>
                          <span className="font-bold text-green-600">
                            +₹{roiData.vacancyImprovement.toLocaleString()}
                          </span>
                        </div>
                        <div className="flex justify-between">
                          <span className="text-blue-700">
                            Maintenance Savings:
                          </span>
                          <span className="font-bold text-green-600">
                            +₹{roiData.maintenanceImprovement.toLocaleString()}
                          </span>
                        </div>
                        <div className="border-t pt-2 flex justify-between font-bold">
                          <span className="text-blue-900">
                            Total Annual Savings:
                          </span>
                          <span className="text-green-600">
                            ₹
                            {(
                              roiData.vacancyImprovement +
                              roiData.maintenanceImprovement
                            ).toLocaleString()}
                          </span>
                        </div>
                      </div>
                    </div>

                    {/* Plan Comparison */}
                    <div className="space-y-3">
                      <h4 className="font-semibold text-gray-900">
                        Compare All Plans:
                      </h4>
                      {[
                        {
                          plan: "Basic (10%)",
                          yield: roiData.netYield.basic,
                          fee: roiData.managementFees.basic,
                          color: "blue",
                        },
                        {
                          plan: "Premium (15%)",
                          yield: roiData.netYield.premium,
                          fee: roiData.managementFees.premium,
                          color: "green",
                        },
                        {
                          plan: "Enterprise (20%)",
                          yield: roiData.netYield.enterprise,
                          fee: roiData.managementFees.enterprise,
                          color: "purple",
                        },
                      ].map((item, index) => {
                        const isRecommended = recommendedPlan.includes(
                          item.plan.split(" ")[0]
                        );
                        const improvement = (
                          parseFloat(item.yield) - parseFloat(roiData.beforeROI)
                        ).toFixed(1);
                        return (
                          <div
                            key={index}
                            className={`flex justify-between items-center p-4 border rounded-xl transition-all ${
                              isRecommended
                                ? "border-green-500 bg-gradient-to-r from-green-50 to-green-100 shadow-lg transform scale-105"
                                : "bg-white border-gray-200 hover:border-blue-300 hover:shadow-md"
                            }`}
                          >
                            <div>
                              <div className="font-medium text-gray-900 flex items-center">
                                {item.plan}
                                {isRecommended && (
                                  <span className="ml-2 text-xs bg-green-500 text-white px-2 py-1 rounded-full animate-pulse">
                                    ✨ Recommended
                                  </span>
                                )}
                              </div>
                              <div className="text-sm text-gray-600">
                                Annual fee: ₹{item.fee.toLocaleString()}
                              </div>
                              <div className="text-xs text-green-600 font-medium">
                                +{improvement}% vs self-management
                              </div>
                            </div>
                            <div className="text-right">
                              <div
                                className={`text-2xl font-bold ${
                                  isRecommended
                                    ? "text-green-600"
                                    : `text-${item.color}-600`
                                }`}
                              >
                                {item.yield}%
                              </div>
                              <div className="text-xs text-gray-500">
                                Net ROI
                              </div>
                            </div>
                          </div>
                        );
                      })}
                    </div>

                    {/* CTA Button */}
                    <div className="mt-6 text-center">
                      <Button
                        className="bg-green-600 hover:bg-green-700 text-white px-8 py-3 text-lg font-semibold"
                        onClick={() =>
                          navigate(
                            "/contact?service=property-management&calculated=true"
                          )
                        }
                      >
                        Start Management Now - Get {roiData.netYield.premium}%
                        ROI
                        <ArrowRight className="w-5 h-5 ml-2" />
                      </Button>
                    </div>
                  </div>
                )}
              </div>
            </div>
          </div>
        </section>

        {/* Expanded Success Stories */}
        <section className="bg-gray-50 py-12">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Success Stories Across Property Types
              </h2>
              <p className="text-lg text-gray-600">
                Real results from different investor profiles who trust NAL
                India
              </p>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
              {[
                {
                  name: "Dr. Sunita Reddy",
                  location: "Hyderabad",
                  property: "10+ Properties Portfolio",
                  profile: "Portfolio Owner",
                  result: "25% time savings",
                  beforeAfter: {
                    before: "20 hours/week management",
                    after: "5 hours/week oversight",
                  },
                  quote:
                    "Managing 12 properties was overwhelming. NAL India handles everything while I focus on my practice.",
                  rating: 5,
                  image:
                    "https://images.unsplash.com/photo-1559839734-2b71ea197ec2?w=80&h=80&fit=crop&crop=face",
                },
                {
                  name: "Vikram Singh",
                  location: "Delhi NCR",
                  property: "Commercial Space",
                  profile: "Commercial Property Owner",
                  result: "₹15L additional revenue",
                  beforeAfter: {
                    before: "6 months vacancy",
                    after: "2 weeks vacancy",
                  },
                  quote:
                    "Their commercial leasing expertise filled my office space in record time with premium tenants.",
                  rating: 5,
                  image:
                    "https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=80&h=80&fit=crop&crop=face",
                },
                {
                  name: "Meera Joshi",
                  location: "Chennai",
                  property: "4BHK Independent House",
                  profile: "NRI Investor",
                  result: "100% remote management",
                  beforeAfter: {
                    before: "Frequent India visits",
                    after: "Complete remote oversight",
                  },
                  quote:
                    "Living in Singapore, I needed reliable property management. NAL India provides complete peace of mind.",
                  rating: 5,
                  image:
                    "https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=80&h=80&fit=crop&crop=face",
                },
              ].map((testimonial, index) => (
                <div
                  key={index}
                  className="bg-white rounded-2xl p-6 shadow-lg hover:shadow-xl transition-shadow"
                >
                  <div className="flex items-center mb-4">
                    <img
                      src={testimonial.image}
                      alt={testimonial.name}
                      className="w-12 h-12 rounded-full object-cover"
                    />
                    <div className="ml-4">
                      <h4 className="font-bold text-gray-900">
                        {testimonial.name}
                      </h4>
                      <p className="text-sm text-gray-600">
                        {testimonial.location} • {testimonial.property}
                      </p>
                      <p className="text-xs text-blue-600 font-medium">
                        {testimonial.profile}
                      </p>
                    </div>
                  </div>

                  <div className="mb-4">
                    <div className="flex items-center mb-2">
                      {[...Array(testimonial.rating)].map((_, i) => (
                        <Star
                          key={i}
                          className="w-4 h-4 text-yellow-400 fill-current"
                        />
                      ))}
                    </div>
                    <div className="text-lg font-bold text-green-600 mb-3">
                      {testimonial.result}
                    </div>

                    <div className="bg-gray-50 p-3 rounded-lg mb-3">
                      <div className="text-xs text-gray-600 mb-1">
                        Before vs After:
                      </div>
                      <div className="flex justify-between text-sm">
                        <span className="text-red-600">
                          Before: {testimonial.beforeAfter.before}
                        </span>
                        <span className="text-green-600">
                          After: {testimonial.beforeAfter.after}
                        </span>
                      </div>
                    </div>

                    <p className="text-gray-700 italic text-sm">
                      "{testimonial.quote}"
                    </p>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Customer Reviews & Trust Signals */}
        <section className="bg-white py-12">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Trusted by Property Owners Across India
              </h2>
              <div className="flex justify-center items-center gap-8 mb-8">
                <div className="flex items-center gap-2">
                  <div className="flex">
                    {[...Array(5)].map((_, i) => (
                      <Star
                        key={i}
                        className="w-5 h-5 text-yellow-400 fill-current"
                      />
                    ))}
                  </div>
                  <span className="text-lg font-semibold text-gray-900">
                    4.8/5
                  </span>
                  <span className="text-gray-600">(2,847 reviews)</span>
                </div>
                <div className="flex items-center gap-4">
                  <img
                    src="https://upload.wikimedia.org/wikipedia/commons/c/c1/Google_%22G%22_logo.svg"
                    alt="Google"
                    className="w-6 h-6"
                  />
                  <span className="text-gray-600">Google Reviews</span>
                </div>
              </div>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
              {[
                {
                  badge: "RERA Certified",
                  icon: Shield,
                  description:
                    "Registered with Real Estate Regulatory Authority",
                },
                {
                  badge: "ISO 9001:2015",
                  icon: Award,
                  description: "Quality Management System Certified",
                },
                {
                  badge: "Insured Services",
                  icon: Shield,
                  description:
                    "₹10L insurance coverage for all managed properties",
                },
                {
                  badge: "24/7 Support",
                  icon: Phone,
                  description: "Round-the-clock customer support hotline",
                },
              ].map((trust, index) => (
                <div
                  key={index}
                  className="text-center p-6 bg-gray-50 rounded-xl"
                >
                  <div className="bg-blue-100 w-12 h-12 rounded-full flex items-center justify-center mx-auto mb-4">
                    <trust.icon className="w-6 h-6 text-blue-600" />
                  </div>
                  <h4 className="font-bold text-gray-900 mb-2">
                    {trust.badge}
                  </h4>
                  <p className="text-sm text-gray-600">{trust.description}</p>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Expanded FAQ Section */}
        <section className="bg-gray-50 py-12">
          <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Frequently Asked Questions
              </h2>
              <p className="text-lg text-gray-600">
                Get answers to common questions about our property management
                services
              </p>
            </div>

            <div className="space-y-4">
              {[
                {
                  question:
                    "How much can I earn with your management services?",
                  answer:
                    "Our clients typically see 15-22% higher returns compared to self-management. With our 99.5% rent collection rate and average 12-day vacancy periods, you can expect consistent income with minimal hassle.",
                },
                {
                  question: "What happens during the property inspection?",
                  answer:
                    "Our certified inspectors conduct a comprehensive 50-point inspection covering structural, electrical, plumbing, and safety aspects. You receive a detailed report with photos, recommended improvements, and market positioning suggestions within 24 hours.",
                },
                {
                  question:
                    "How is the rent collected and what payment methods do you accept?",
                  answer:
                    "We collect rent through UPI, NEFT, bank transfers, and digital wallets. Automated reminders are sent 3 days before due date, with escalation procedures for late payments. Funds are transferred to your account within 24 hours of collection.",
                },
                {
                  question: "Can I terminate my contract early?",
                  answer:
                    "Yes, you can terminate with 60 days written notice. There are no early termination penalties. We ensure smooth transition and provide all property documents and tenant information for seamless handover.",
                },
                {
                  question: "What's included in maintenance costs?",
                  answer:
                    "Our management fee covers coordination and oversight. Actual repair costs are separate and pre-approved by you. Emergency repairs under ₹5,000 are handled immediately with post-approval. We negotiate 15-20% discounts with our vendor network.",
                },
                {
                  question: "What is your success rate for rent collection?",
                  answer:
                    "We maintain a 99.5% on-time rent collection rate through UPI integration, automated reminders, and our legal support network. Late payments are handled professionally with clear escalation procedures.",
                },
                {
                  question: "Can I switch between service plans?",
                  answer:
                    "Yes, you can upgrade or downgrade your service plan with 30 days notice. We will adjust the services and pricing accordingly from the next billing cycle.",
                },
                {
                  question: "How quickly can you find tenants for my property?",
                  answer:
                    "Our average vacancy period is just 12 days compared to the market average of 60 days. We have an extensive network and proven marketing strategies to find quality tenants quickly.",
                },
                {
                  question: "What happens if there are maintenance issues?",
                  answer:
                    "We provide 24/7 emergency support with 2-hour response time guarantee. Our network of 500+ verified contractors ensures quality repairs at competitive rates, all covered by insurance.",
                },
                {
                  question: "Do you provide legal support for tenant disputes?",
                  answer:
                    "Yes, our Premium and Enterprise plans include legal documentation support and dispute resolution assistance. We handle tenant agreements, eviction procedures, and regulatory compliance.",
                },
              ].map((faq, index) => (
                <div
                  key={index}
                  className="border border-gray-200 rounded-lg bg-white"
                >
                  <button
                    onClick={() => setOpenFaq(openFaq === index ? null : index)}
                    className="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-50 transition-colors"
                  >
                    <span className="font-semibold text-gray-900">
                      {faq.question}
                    </span>
                    {openFaq === index ? (
                      <ChevronUp className="w-5 h-5 text-gray-500" />
                    ) : (
                      <ChevronDown className="w-5 h-5 text-gray-500" />
                    )}
                  </button>
                  {openFaq === index && (
                    <div className="px-6 pb-4">
                      <p className="text-gray-700 leading-relaxed">
                        {faq.answer}
                      </p>
                    </div>
                  )}
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Comparison Table */}
        <section className="bg-white py-20">
          <div className="max-w-6xl mx-auto px-4">
            <h2 className="text-4xl font-bold text-center mb-16 text-gray-900">
              Feature Comparison
            </h2>
            <div className="bg-white rounded-2xl shadow-2xl overflow-hidden">
              <div className="overflow-x-auto">
                <table className="w-full">
                  <thead>
                    <tr className="bg-gray-50 border-b-2 border-gray-200">
                      <th className="text-left py-6 px-8 font-bold text-gray-900 text-lg">
                        Feature
                      </th>
                      <th className="text-center py-6 px-8 font-bold text-gray-900 text-lg">
                        Basic
                      </th>
                      <th className="text-center py-6 px-8 font-bold text-gray-900 text-lg bg-blue-50">
                        Premium
                      </th>
                      <th className="text-center py-6 px-8 font-bold text-gray-900 text-lg">
                        Enterprise
                      </th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr className="border-b border-gray-100">
                      <td className="py-4 px-8 text-gray-700 font-medium">
                        Rent Collection
                      </td>
                      <td className="text-center py-4 px-8">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                      <td className="text-center py-4 px-8 bg-blue-50">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                      <td className="text-center py-4 px-8">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                    </tr>
                    <tr className="border-b border-gray-100">
                      <td className="py-4 px-8 text-gray-700 font-medium">
                        Tenant Screening
                      </td>
                      <td className="text-center py-4 px-8">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                      <td className="text-center py-4 px-8 bg-blue-50">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                      <td className="text-center py-4 px-8">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                    </tr>
                    <tr className="border-b border-gray-100">
                      <td className="py-4 px-8 text-gray-700 font-medium">
                        24/7 Maintenance
                      </td>
                      <td className="text-center py-4 px-8 text-gray-400">-</td>
                      <td className="text-center py-4 px-8 bg-blue-50">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                      <td className="text-center py-4 px-8">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                    </tr>
                    <tr className="border-b border-gray-100">
                      <td className="py-4 px-8 text-gray-700 font-medium">
                        Legal Support
                      </td>
                      <td className="text-center py-4 px-8 text-gray-400">-</td>
                      <td className="text-center py-4 px-8 bg-blue-50">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                      <td className="text-center py-4 px-8">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                    </tr>
                    <tr className="border-b border-gray-100">
                      <td className="py-4 px-8 text-gray-700 font-medium">
                        Owner Portal
                      </td>
                      <td className="text-center py-4 px-8 text-gray-400">-</td>
                      <td className="text-center py-4 px-8 bg-blue-50">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                      <td className="text-center py-4 px-8">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                    </tr>
                    <tr className="border-b border-gray-100">
                      <td className="py-4 px-8 text-gray-700 font-medium">
                        Tax Support
                      </td>
                      <td className="text-center py-4 px-8 text-gray-400">-</td>
                      <td className="text-center py-4 px-8 bg-blue-50 text-gray-400">
                        -
                      </td>
                      <td className="text-center py-4 px-8">
                        <CheckCircle className="w-6 h-6 text-green-500 mx-auto" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </section>

        {/* Pricing Plans */}
        <section className="bg-gray-50 py-20">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-12">
              <h2 className="text-4xl font-bold text-gray-900 mb-4">
                Choose Your Service Plan
              </h2>
              <p className="text-lg text-gray-600">
                Flexible pricing options to suit your property management needs
              </p>

              <Button
                onClick={() => setShowQuiz(true)}
                variant="outline"
                className="mt-4 bg-blue-50 border-blue-200 text-blue-700 hover:bg-blue-100"
              >
                <Star className="w-4 h-4 mr-2" />
                Find Your Perfect Plan (30 seconds)
              </Button>
            </div>

            {showQuiz && (
              <div
                className="fixed inset-0 flex items-center justify-center"
                style={{ zIndex: 9999, backgroundColor: "rgba(0,0,0,0.35)" }}
              >
                <div className="bg-white rounded-2xl p-8 max-w-md w-full mx-4 relative">
                  <h3 className="text-xl font-bold text-gray-900 mb-6">
                    Find Your Perfect Plan
                  </h3>
                  <div className="space-y-4">
                    <div>
                      <label className="block text-sm font-medium text-gray-700 mb-2">
                        How many properties do you own?
                      </label>
                      <select
                        onChange={(e) =>
                          setQuizAnswers({
                            ...quizAnswers,
                            propertyCount: e.target.value,
                          })
                        }
                        className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none"
                      >
                        <option value="">Select...</option>
                        <option value="single">1 property</option>
                        <option value="few">2-5 properties</option>
                        <option value="multiple">6+ properties</option>
                      </select>
                    </div>

                    <div>
                      <label className="block text-sm font-medium text-gray-700 mb-2">
                        Management complexity needed?
                      </label>
                      <select
                        onChange={(e) =>
                          setQuizAnswers({
                            ...quizAnswers,
                            complexity: e.target.value,
                          })
                        }
                        className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none"
                      >
                        <option value="">Select...</option>
                        <option value="basic">
                          Basic (rent collection, maintenance)
                        </option>
                        <option value="medium">
                          Medium (+ legal, inspections)
                        </option>
                        <option value="high">
                          High (+ tax, portfolio management)
                        </option>
                      </select>
                    </div>

                    <div>
                      <label className="block text-sm font-medium text-gray-700 mb-2">
                        Time commitment preference?
                      </label>
                      <select
                        onChange={(e) =>
                          setQuizAnswers({
                            ...quizAnswers,
                            timeCommitment: e.target.value,
                          })
                        }
                        className="w-full px-3 py-2 border border-gray-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none"
                      >
                        <option value="">Select...</option>
                        <option value="involved">
                          Stay involved in decisions
                        </option>
                        <option value="minimal">
                          Minimal involvement preferred
                        </option>
                      </select>
                    </div>
                  </div>

                  <div className="flex gap-3 mt-6">
                    <Button
                      onClick={() => setShowQuiz(false)}
                      variant="outline"
                      className="flex-1"
                    >
                      Cancel
                    </Button>
                    <button
                      onClick={() => {
                        let recommendation = "Basic Management";
                        let score = 0;

                        if (quizAnswers.propertyCount === "multiple")
                          score += 2;
                        if (quizAnswers.complexity === "high") score += 2;
                        else if (quizAnswers.complexity === "medium")
                          score += 1;
                        if (quizAnswers.timeCommitment === "minimal")
                          score += 1;

                        if (score >= 4) recommendation = "Enterprise Solution";
                        else if (score >= 2)
                          recommendation = "Premium Management";

                        setRecommendedPlan(recommendation);
                        setShowQuiz(false);

                        alert(
                          `Based on your answers, we recommend: ${recommendation}`
                        );
                      }}
                      className="flex-1 h-9 px-4 py-2 rounded-md text-sm font-medium"
                      style={{
                        backgroundColor: "#2563eb",
                        color: "#ffffff",
                        border: "none",
                        cursor: "pointer",
                      }}
                    >
                      Get Recommendation
                    </button>
                  </div>
                </div>
              </div>
            )}

            <div className="grid grid-cols-1 md:grid-cols-3 gap-8 pt-6 items-stretch">
              {[
                {
                  name: "Basic Plan",
                  price: "8%",
                  period: "of rental income",
                  features: [
                    "Rent Collection",
                    "Tenant Screening",
                    "Basic Maintenance",
                    "Monthly Reports",
                  ],
                  popular: false,
                },
                {
                  name: "Premium Plan",
                  price: "10%",
                  period: "of rental income",
                  features: [
                    "Everything in Basic",
                    "24/7 Maintenance",
                    "Legal Support",
                    "Owner Portal Access",
                    "Dedicated Manager",
                  ],
                  popular: true,
                },
                {
                  name: "NRI Special",
                  price: "12%",
                  period: "of rental income",
                  features: [
                    "Everything in Premium",
                    "NRI Tax Support",
                    "International Banking",
                    "Time Zone Support",
                    "Priority Service",
                  ],
                  popular: false,
                },
              ].map((plan, index) => (
                <div
                  key={index}
                  className={`relative rounded-2xl border text-gray-900 shadow-lg transition-all cursor-pointer flex flex-col h-full ${
                    plan.popular
                      ? "border-blue-500 bg-white transform scale-105"
                      : "border-gray-200 bg-white hover:border-blue-300 hover:shadow-xl"
                  }`}
                  onClick={() =>
                    setSelectedPlan(
                      selectedPlan === plan.name ? null : plan.name
                    )
                  }
                >
                  <div className="p-8 flex flex-col h-full">
                    {plan.popular && (
                      <div className="absolute -top-4 left-1/2 transform -translate-x-1/2 bg-blue-500 text-white px-4 py-1 rounded-full text-sm font-semibold">
                        Most Popular
                      </div>
                    )}

                    <div className="text-center mb-6">
                      <h3 className="text-2xl font-bold mb-2 text-gray-900">
                        {plan.name}
                      </h3>
                      <div className="text-4xl font-bold mb-1 text-blue-600">
                        {plan.price}
                      </div>
                      <div className="text-gray-600">{plan.period}</div>
                    </div>

                    <ul className="space-y-3 flex-grow mb-8">
                      {plan.features.map((feature, idx) => (
                        <li key={idx} className="flex items-center gap-3">
                          <CheckCircle className="w-4 h-4 text-green-500 flex-shrink-0" />
                          <span className="text-gray-700">{feature}</span>
                        </li>
                      ))}
                    </ul>

                    <Button
                      className={`w-full ${
                        plan.popular
                          ? "bg-blue-600 hover:bg-blue-700"
                          : plan.name === "NRI Special"
                          ? "bg-purple-600 hover:bg-purple-700"
                          : "bg-blue-600 hover:bg-blue-700"
                      }`}
                      onClick={(e) => {
                        e.stopPropagation();
                        navigate(
                          `/contact?plan=${plan.name
                            .toLowerCase()
                            .replace(" ", "-")}`
                        );
                      }}
                    >
                      Choose {plan.name}
                    </Button>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Owner/Tenant Portals */}
        <section className="bg-gradient-to-br from-blue-50 to-indigo-100 py-12">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Dedicated Client Portals
              </h2>
              <p className="text-lg text-gray-600">
                Secure access for property owners and tenants
              </p>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              <div className="bg-white rounded-2xl p-8 shadow-xl border border-blue-200">
                <div className="flex items-center mb-6">
                  <div className="bg-blue-100 p-3 rounded-lg mr-4">
                    <Building className="w-8 h-8 text-blue-600" />
                  </div>
                  <div>
                    <h3 className="text-xl font-bold text-gray-900">
                      Owner Portal
                    </h3>
                    <p className="text-gray-600">For Property Owners</p>
                  </div>
                </div>

                <ul className="space-y-3 mb-6">
                  <li className="flex items-center">
                    <CheckCircle className="w-5 h-5 text-green-500 mr-3" />
                    <span>Real-time financial reports</span>
                  </li>
                  <li className="flex items-center">
                    <CheckCircle className="w-5 h-5 text-green-500 mr-3" />
                    <span>Property performance analytics</span>
                  </li>
                  <li className="flex items-center">
                    <CheckCircle className="w-5 h-5 text-green-500 mr-3" />
                    <span>Maintenance request tracking</span>
                  </li>
                  <li className="flex items-center">
                    <CheckCircle className="w-5 h-5 text-green-500 mr-3" />
                    <span>Document management</span>
                  </li>
                </ul>

                <button
                  className="w-full py-2 px-4 font-medium rounded-md text-sm flex items-center justify-center"
                  style={{
                    backgroundColor: "#2563eb",
                    color: "#ffffff",
                    border: "none",
                  }}
                  onClick={() => navigate("/login?type=owner")}
                >
                  <User className="w-4 h-4 mr-2" />
                  Owner Login
                </button>
              </div>

              <div className="bg-white rounded-2xl p-8 shadow-xl border border-green-200">
                <div className="flex items-center mb-6">
                  <div className="bg-green-100 p-3 rounded-lg mr-4">
                    <Users className="w-8 h-8 text-green-600" />
                  </div>
                  <div>
                    <h3 className="text-xl font-bold text-gray-900">
                      Tenant Portal
                    </h3>
                    <p className="text-gray-600">For Tenants</p>
                  </div>
                </div>

                <ul className="space-y-3 mb-6">
                  <li className="flex items-center">
                    <CheckCircle className="w-5 h-5 text-green-500 mr-3" />
                    <span>Online rent payment</span>
                  </li>
                  <li className="flex items-center">
                    <CheckCircle className="w-5 h-5 text-green-500 mr-3" />
                    <span>Maintenance requests</span>
                  </li>
                  <li className="flex items-center">
                    <CheckCircle className="w-5 h-5 text-green-500 mr-3" />
                    <span>Lease document access</span>
                  </li>
                  <li className="flex items-center">
                    <CheckCircle className="w-5 h-5 text-green-500 mr-3" />
                    <span>Communication center</span>
                  </li>
                </ul>

                <button
                  className="w-full py-2 px-4 font-medium rounded-md text-sm flex items-center justify-center"
                  style={{
                    backgroundColor: "#16a34a",
                    color: "#ffffff",
                    border: "none",
                  }}
                  onClick={() => navigate("/login?type=tenant")}
                >
                  <User className="w-4 h-4 mr-2" />
                  Tenant Login
                </button>
              </div>
            </div>
          </div>
        </section>

        {/* CTA Section */}
        <section className="property-mgmt-cta">
          <div className="property-mgmt-cta-card">
            <h2>Start Professional Management</h2>
            <p>Let experts handle your property while you enjoy the returns</p>
            <div className="flex flex-col lg:flex-row gap-3 justify-center items-center mt-6">
              <Button
                className="property-mgmt-cta-button w-full lg:w-auto"
                onClick={() => {
                  if (propertyValue && monthlyRent) {
                    navigate(
                      `/contact?service=property-management&value=${propertyValue}&rent=${monthlyRent}`
                    );
                  } else {
                    navigate("/contact?service=property-management");
                  }
                }}
              >
                {propertyValue && monthlyRent
                  ? "Get Instant Quote"
                  : "Get Free Quote + Guarantee"}
                <ArrowRight className="w-5 h-5 ml-2" />
              </Button>
              <Button
                variant="outline"
                className="bg-white/10 border-white text-white hover:bg-white/20 w-full lg:w-auto"
                onClick={() => navigate("/login")}
              >
                <Calendar className="w-5 h-5 mr-2" />
                Book Free Consultation
              </Button>
              <Button
                variant="outline"
                className="bg-white/10 border-white text-white hover:bg-white/20 w-full lg:w-auto"
                onClick={() => {
                  const testimonialsSection =
                    document.querySelector(".bg-gray-50");
                  testimonialsSection?.scrollIntoView({ behavior: "smooth" });
                }}
              >
                <Star className="w-5 h-5 mr-2" />
                View Success Stories
              </Button>
            </div>
          </div>
        </section>
      </div>
    </>
  );
}