import React from "react";
import { Shield, ArrowLeft, Phone, Home, AlertTriangle, CheckCircle, FileText, Calendar } from "lucide-react";
import { useNavigate } from "react-router-dom";
import { Button } from "../../components/ui/button";

export function PropertyOwnersGuidance() {
  const navigate = useNavigate();

  const handleGetAssistance = () => {
    window.location.href = "tel:+911234567890";
  };

  return (
    <>
      <style>{`
        .buyers-hero {
          background: linear-gradient(135deg, #0056D2 0%, #004bb5 100%);
          padding: 3rem 1rem;
          text-align: center;
          color: white;
        }
        .buyers-hero h1 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 1rem;
          color: white;
        }
        .buyers-hero p {
          font-size: 1.125rem;
          color: #e0f2fe;
          max-width: 48rem;
          margin: 0 auto;
        }
        .buyers-section {
          padding: 3rem 1rem;
          background: #f9fafb;
        }
        .buyers-section.with-bg {
          background: white;
          position: relative;
        }
        .buyers-section h2 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 2rem;
          color: #111827;
          text-align: center;
        }
        .tip-card {
          background: linear-gradient(135deg, #eff6ff 0%, #ecfeff 100%);
          padding: 2rem;
          border-radius: 1rem;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
          border: 1px solid #a5b4fc;
          transition: all 0.3s ease;
          text-align: center;
          cursor: pointer;
        }
        .tip-card:hover {
          background: linear-gradient(135deg, #dbeafe 0%, #cffafe 100%);
          transform: translateY(-4px);
          box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
          border-color: #0056D2;
        }
      `}</style>
      
      <div className="min-h-screen bg-white">
        <div className="p-4">
          <button
            onClick={() => navigate(-1)}
            className="flex items-center gap-2 text-[#0056D2] hover:text-[#003d99] transition-colors"
          >
            <ArrowLeft className="w-5 h-5" />
            <span className="font-medium">Back</span>
          </button>
        </div>

        <section className="buyers-hero">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1>Home Insurance Guidance for Property Owners</h1>
            <p>
              Comprehensive insurance guidance for existing property owners. Learn about coverage types, renewals, and protection strategies.
            </p>
          </div>
        </section>

        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Why Insurance Matters for Property Owners</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
              <div className="tip-card">
                <Shield className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Risk Protection
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Protects existing property against natural disasters, fire, theft, and accidental damage.
                </p>
              </div>
              <div className="tip-card">
                <Home className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Investment Security
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Helps safeguard your long-term investment value and protects against market fluctuations.
                </p>
              </div>
              <div className="tip-card">
                <AlertTriangle className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Rental Properties
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Essential coverage for rented or vacant properties with additional liability protection.
                </p>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>When Insurance Is Usually Required</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl border border-blue-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-blue-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <FileText className="w-5 h-5 text-blue-600" />
                  Existing Loans
                </h3>
                <ul className="space-y-3 text-sm text-gray-700">
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Properties with existing loans or mortgages</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Commercial or mixed-use properties</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>During property renovations or major repairs</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl border border-blue-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-blue-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <Calendar className="w-5 h-5 text-blue-600" />
                  Rental Properties
                </h3>
                <ul className="space-y-3 text-sm text-gray-700">
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>When renting out your property to tenants</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>For vacant properties awaiting sale or rent</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Properties in high-risk areas or locations</span>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Common Questions from Property Owners</h2>
            <div className="max-w-4xl mx-auto">
              <div className="space-y-6">
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: Do I need insurance if my home is already built and paid for?
                  </h3>
                  <p className="text-gray-600">
                    A: Yes, insurance is still important for protection against natural disasters, theft, and other risks regardless of loan status.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: How often should insurance policies be renewed?
                  </h3>
                  <p className="text-gray-600">
                    A: Typically annually, but check your specific policy terms. Some policies may have different renewal periods.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: What types of risks should be covered?
                  </h3>
                  <p className="text-gray-600">
                    A: Essential coverage includes fire, natural disasters, theft, and liability. Consider additional coverage based on your location and property type.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: Is insurance different for rental properties?
                  </h3>
                  <p className="text-gray-600">
                    A: Yes, rental properties typically need landlord insurance which includes liability coverage and loss of rental income protection.
                  </p>
                </div>
                <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Q: How do I update coverage when property value increases?
                  </h3>
                  <p className="text-gray-600">
                    A: Contact your insurance provider to reassess and update your coverage amount based on current property valuation and market rates.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section" style={{ background: "white" }}>
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="bg-blue-50 border-l-4 border-blue-400 p-6 rounded-lg">
              <div className="flex items-start gap-3">
                <Phone className="w-6 h-6 text-blue-600 mt-1" />
                <div>
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    How Our Assistance Helps Property Owners
                  </h3>
                  <ul className="space-y-2 text-sm text-gray-700">
                    <li>• Explain different types of coverage available for your property</li>
                    <li>• Guide you on renewal considerations and timing</li>
                    <li>• Connect you with insurers for policy selection and comparison</li>
                    <li>• Help assess appropriate coverage levels for your property</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 className="text-base">Ready to Get Started?</h2>
            <div className="flex justify-center">
              <Button
                className="bg-blue-600 hover:bg-blue-700 text-white p-4 h-auto flex items-center gap-2"
                style={{ backgroundColor: "#0056D2", color: "white" }}
                onClick={handleGetAssistance}
              >
                <Phone className="w-5 h-5" />
                <span>Get Insurance Assistance</span>
              </Button>
            </div>
            <p className="text-center text-sm text-gray-500 mt-4 italic">
              We do not provide insurance directly. Our role is limited to assistance and guidance only.
            </p>
          </div>
        </section>
      </div>
    </>
  );
}