import React from 'react';
import { TrendingUp, BarChart3, Calculator, ArrowRight } from 'lucide-react';
import { Button } from '../../components/ui/button';
import { useNavigate } from 'react-router-dom';
import './PropertyValuationPremium.css';

export function PropertyValuationPremium() {
  const navigate = useNavigate();

  const handleOrderValuation = () => {
    navigate('/valuation-reports');
  };

  return (
    <>
      <style>{`
        .valuation-hero {
          background: linear-gradient(rgba(30, 41, 59, 0.9), rgba(30, 41, 59, 0.8)), url('https://images.unsplash.com/photo-1560518883-ce09059eeffa?ixlib=rb-4.0.3&auto=format&fit=crop&w=2073&q=80') !important;
          background-size: cover !important;
          background-position: center !important;
          padding: 8rem 0 !important;
          color: white !important;
          text-align: center !important;
        }
        .valuation-hero h1 {
          font-size: 3.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: white !important;
          letter-spacing: -0.025em !important;
        }
        .valuation-hero p {
          font-size: 1.25rem !important;
          margin-bottom: 2.5rem !important;
          color: #e2e8f0 !important;
          max-width: 50rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
          line-height: 1.7 !important;
        }
      `}</style>
      <div className="min-h-screen">
        {/* Hero Section */}
        <header className="valuation-hero">
          <div>
            <h1>Property Valuation</h1>
            <p>
              Property valuation service with market data analysis. Get detailed market value reports with comparative analysis and professional insights.
            </p>
            <div className="valuation-pricing">
              Beta Pricing: Basic Report: ₹999 | Detailed Report: ₹2,999 | Coming Soon: Professional Certifications
            </div>
          </div>
        </header>

        {/* Benefits Section */}
        <section className="valuation-benefits">
          <h2>Accurate Valuations You Can Trust</h2>
          <div className="valuation-benefit-grid">
            <div className="valuation-benefit-card">
              <h3>Data-Driven Analysis</h3>
              <ul className="valuation-benefit-list">
                <li className="valuation-benefit-item">
                  <div className="valuation-benefit-icon"></div>
                  <span className="valuation-benefit-text">Comprehensive analysis using 150+ market indicators and comparable sales data from Indian metro cities</span>
                </li>
                <li className="valuation-benefit-item">
                  <div className="valuation-benefit-icon"></div>
                  <span className="valuation-benefit-text">Live market data from 25,000+ recent transactions across IT hubs, metro cities, and emerging markets</span>
                </li>
                <li className="valuation-benefit-item">
                  <div className="valuation-benefit-icon"></div>
                  <span className="valuation-benefit-text">Advanced CMA using AI algorithms trained on Indian real estate patterns and regional price variations</span>
                </li>
              </ul>
            </div>
            <div className="valuation-benefit-card">
              <h3>Certified Experts</h3>
              <ul className="valuation-benefit-list">
                <li className="valuation-benefit-item">
                  <div className="valuation-benefit-icon"></div>
                  <span className="valuation-benefit-text">Team of 75+ RICS and IBBI certified valuers with specialized expertise in Indian property markets and regulatory compliance</span>
                </li>
                <li className="valuation-benefit-item">
                  <div className="valuation-benefit-icon"></div>
                  <span className="valuation-benefit-text">Reports accepted by 40+ Indian banks including SBI, HDFC, ICICI, Axis, Kotak Mahindra, and regional cooperative banks</span>
                </li>
                <li className="valuation-benefit-item">
                  <div className="valuation-benefit-icon"></div>
                  <span className="valuation-benefit-text">Compliant with RBI guidelines, SARFAESI Act, Banking Regulation Act 1949, and state-specific valuation norms</span>
                </li>
              </ul>
            </div>
          </div>
        </section>

        {/* Features Section */}
        <section className="valuation-features">
          <h2>Advanced Valuation Technology</h2>
          <div className="valuation-feature-grid">
            <div className="valuation-feature-card">
              <img 
                src="https://images.unsplash.com/photo-1590283603385-17ffb3a7f29f?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                alt="Market Analysis" 
                className="valuation-feature-image"
              />
              <div className="valuation-feature-content">
                <h3>Market Analysis</h3>
                <p>Real-time market trends and price predictions</p>
              </div>
            </div>
            <div className="valuation-feature-card">
              <img 
                src="https://images.unsplash.com/photo-1553729459-efe14ef6055d?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                alt="Comparative Study" 
                className="valuation-feature-image"
              />
              <div className="valuation-feature-content">
                <h3>Comparative Study</h3>
                <p>Detailed comparison with similar properties</p>
              </div>
            </div>
            <div className="valuation-feature-card">
              <img 
                src="https://images.unsplash.com/photo-1579621970563-ebec7560ff3e?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                alt="ROI Calculator" 
                className="valuation-feature-image"
              />
              <div className="valuation-feature-content">
                <h3>ROI Calculator</h3>
                <p>Investment returns and rental yield analysis</p>
              </div>
            </div>
          </div>
        </section>

        {/* Integration Section */}
        <section className="valuation-integration">
          <h2>Professional Valuation Network</h2>
          <div className="valuation-integration-grid">
            <div className="valuation-integration-card">
              <h3>Banking & Financial Integration</h3>
              <ul className="valuation-integration-list">
                <li className="valuation-integration-item">
                  <div className="valuation-integration-icon"></div>
                  <span className="valuation-integration-text">Direct API integration with major Indian banks for instant valuation report submission and approval</span>
                </li>
                <li className="valuation-integration-item">
                  <div className="valuation-integration-icon"></div>
                  <span className="valuation-integration-text">Empaneled with SBI, HDFC Bank, ICICI Bank, and 35+ other financial institutions for home loan valuations</span>
                </li>
                <li className="valuation-integration-item">
                  <div className="valuation-integration-icon"></div>
                  <span className="valuation-integration-text">RBI-compliant valuation standards with automated report generation and digital signature integration</span>
                </li>
              </ul>
            </div>
            <div className="valuation-integration-card">
              <h3>Government & Regulatory Integration</h3>
              <ul className="valuation-integration-list">
                <li className="valuation-integration-item">
                  <div className="valuation-integration-icon"></div>
                  <span className="valuation-integration-text">Integration with state revenue departments for property record verification and ownership validation</span>
                </li>
                <li className="valuation-integration-item">
                  <div className="valuation-integration-icon"></div>
                  <span className="valuation-integration-text">RERA project database connectivity for under-construction property valuation and risk assessment</span>
                </li>
                <li className="valuation-integration-item">
                  <div className="valuation-integration-icon"></div>
                  <span className="valuation-integration-text">Municipal corporation integration for property tax records, approved plans, and compliance verification</span>
                </li>
              </ul>
            </div>
            <div className="valuation-integration-card">
              <h3>Market Data & Analytics Integration</h3>
              <ul className="valuation-integration-list">
                <li className="valuation-integration-item">
                  <div className="valuation-integration-icon"></div>
                  <span className="valuation-integration-text">Real-time market data integration from leading property portals and transaction databases</span>
                </li>
                <li className="valuation-integration-item">
                  <div className="valuation-integration-icon"></div>
                  <span className="valuation-integration-text">AI-powered comparable sales analysis using machine learning algorithms trained on Indian market patterns</span>
                </li>
                <li className="valuation-integration-item">
                  <div className="valuation-integration-icon"></div>
                  <span className="valuation-integration-text">Integration with infrastructure development databases for future growth potential assessment</span>
                </li>
              </ul>
            </div>
          </div>
        </section>

        {/* CTA Section */}
        <section className="valuation-cta">
          <div className="valuation-cta-card">
            <h2>Get Your Property Valued</h2>
            <p>
              Professional valuation reports in 24 hours
            </p>
            <Button className="valuation-cta-button" onClick={handleOrderValuation}>
              Order Valuation Report
              <ArrowRight className="w-5 h-5 ml-2" />
            </Button>
          </div>
        </section>
      </div>
    </>
  );
}