import React from 'react';
import { useNavigate } from 'react-router-dom';
import { CheckCircle, Shield, FileCheck, Award } from 'lucide-react';
import { Button } from '../../components/ui/button';

export function RERACompliance() {
  const navigate = useNavigate();

  return (
    <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <div className="relative bg-gradient-to-br from-blue-600 via-blue-700 to-indigo-800 py-20 mt-3 overflow-hidden">
        <div className="absolute top-20 left-10 w-72 h-72 bg-white/5 rounded-full blur-3xl"></div>
        <div className="absolute bottom-20 right-10 w-96 h-96 bg-blue-400/10 rounded-full blur-3xl"></div>
        <div className="relative max-w-5xl mx-auto px-4 text-center">
          <h1 className="text-5xl font-bold text-white mb-6">RERA Compliance Assistance</h1>
          <p className="text-xl text-blue-100 mb-8 leading-relaxed">
            Transparency You Can Trust. NAL verifies whether the project is legally registered under RERA (1.19 lakh projects comprising 97 lakh units registered to date) and checks the accuracy of uploaded RERA documents for complete regulatory compliance. With 1.25 lakh complaints resolved and counting, RERA compliance is critical for buyer confidence.
          </p>
          <div className="inline-block bg-white/20 backdrop-blur-sm text-white px-8 py-4 rounded-xl font-semibold text-lg shadow-lg border border-white/30">
            RERA Verification: ₹2,999 | Full Compliance Package: ₹15,000
          </div>
        </div>
      </div>

      {/* Service Images Section */}
      <div className="bg-gradient-to-b from-white to-gray-50 py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="text-center bg-white p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group">
              <img 
                src="https://images.unsplash.com/photo-1589994965851-a8f479c573a9?w=400&h=300&fit=crop"
                alt="Regulatory Compliance" 
                className="w-full h-48 object-cover rounded-xl mb-6 shadow-md group-hover:scale-105 transition-transform duration-300"
              />
              <h3 className="text-xl font-bold text-gray-900 mb-3">Regulatory Compliance</h3>
              <p className="text-gray-600">1.19 lakh projects verified</p>
            </div>
            
            <div className="text-center bg-white p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group">
              <img 
                src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400&h=300&fit=crop"
                alt="32 State RERAs" 
                className="w-full h-48 object-cover rounded-xl mb-6 shadow-md group-hover:scale-105 transition-transform duration-300"
              />
              <h3 className="text-xl font-bold text-gray-900 mb-3">32 State RERAs</h3>
              <p className="text-gray-600">97 lakh units registered and verified</p>
            </div>
            
            <div className="text-center bg-white p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group">
              <img 
                src="https://images.unsplash.com/photo-1551434678-e076c223a692?w=400&h=300&fit=crop"
                alt="Regulatory Support" 
                className="w-full h-48 object-cover rounded-xl mb-6 shadow-md group-hover:scale-105 transition-transform duration-300"
              />
              <h3 className="text-xl font-bold text-gray-900 mb-3">Regulatory Support</h3>
              <p className="text-gray-600">1.25 lakh complaints resolved nationwide</p>
            </div>
          </div>
        </div>
      </div>

      <div className="max-w-6xl mx-auto px-4 py-16 -mt-6">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Features */}
          <div className="bg-white p-8 rounded-2xl border border-gray-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Key Features</h2>
            <ul className="space-y-4">
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">RERA number verification across 32 operational State RERAs and authenticity validation</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Approval certificate validation for 1.19 lakh registered projects and legal compliance checks</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Building compliance review against standards from Registration Bill 2025 and regulatory updates</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Project registration status verification with instant access to official RERA databases</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Developer compliance monitoring tracking 88,461+ registered real estate agents</span>
              </li>
            </ul>
          </div>

          {/* Benefits */}
          <div className="bg-white p-8 rounded-2xl border border-gray-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Benefits</h2>
            <ul className="space-y-4">
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Complete legal compliance ensuring project legitimacy among 1.19 lakh registered projects nationwide</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Enhanced buyer confidence through transparency—critical as India ranked 36th in Global Real Estate Transparency Index</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Reduced regulatory risks with verification against official RERA databases across 32 State RERAs</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Market credibility boost as RERA improved transparency and strengthened investment inflows</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Protection against non-compliant projects—1.25 lakh complaints resolved demonstrate active enforcement</span>
              </li>
            </ul>
          </div>

          {/* Process */}
          <div className="bg-white p-8 rounded-2xl border border-gray-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">How It Works</h2>
            <ol className="space-y-4">
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">1</div>
                <span className="text-gray-700">Comprehensive requirement analysis aligned with state-specific RERA regulations</span>
              </li>
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">2</div>
                <span className="text-gray-700">RERA documentation preparation with verification against 1.19 lakh project database</span>
              </li>
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">3</div>
                <span className="text-gray-700">Official RERA submission support with tracking across 32 State regulatory authorities</span>
              </li>
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">4</div>
                <span className="text-gray-700">Ongoing compliance monitoring as regulations evolve under Registration Bill 2025</span>
              </li>
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">5</div>
                <span className="text-gray-700">Continuous support with monthly regulatory updates and compliance status reports</span>
              </li>
            </ol>
          </div>
        </div>

        {/* CTA Section */}
        <div className="mt-16 bg-gradient-to-r from-blue-600 to-blue-700 rounded-2xl p-12 text-white text-center shadow-2xl relative overflow-hidden">
          <div className="absolute top-10 right-10 w-32 h-32 bg-white/10 rounded-full blur-2xl"></div>
          <div className="absolute bottom-10 left-10 w-40 h-40 bg-blue-400/20 rounded-full blur-2xl"></div>
          <div className="relative">
            <h2 className="text-4xl font-bold mb-6">Ready to Get Started?</h2>
            <p className="text-blue-100 mb-10 max-w-2xl mx-auto text-lg leading-relaxed">
              Contact our experts today to learn more about how RERA compliance assistance can help you with data-backed insights and professional service.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button 
                variant="outline" 
                className="border-2 border-white text-white hover:bg-white/10 px-8 py-4 font-semibold text-lg rounded-xl transition-all duration-300"
              >
                Schedule Consultation
              </Button>
              <Button 
                className="bg-white text-blue-600 hover:bg-gray-100 px-8 py-4 font-semibold text-lg rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105"
              >
                Get Started Now
              </Button>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}