import React, { useState } from "react";
import {
  CheckCircle,
  FileText,
  Scale,
  ArrowRight,
  ArrowLeft,
  Search,
  Upload,
  Globe,
  Building,
  Users,
  Home,
  MessageCircle,
  Mail,
  ExternalLink,
  Shield,
  Phone,
  MapPin,
  AlertTriangle,
  Eye,
  Calendar,
  BookOpen,
} from "lucide-react";
import { Button } from "../../components/ui/button";
import { Input } from "../../components/ui/input";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "../../components/ui/select";
import { useNavigate } from "react-router-dom";

interface VerificationResult {
  status: "verified" | "not-found" | "pending";
  reraNumber: string;
  validityDate: string;
  projectName: string;
}

export function RERACompliancePremium() {
  const navigate = useNavigate();
  const [activeSection, setActiveSection] = useState("");
  const [verificationForm, setVerificationForm] = useState({
    projectName: "",
    builderName: "",
    state: "",
    reraNumber: "",
  });
  const [verificationResult, setVerificationResult] =
    useState<VerificationResult | null>(null);
  const [submissionForm, setSubmissionForm] = useState({
    projectName: "",
    builderName: "",
    reraNumber: "",
    state: "",
    validityFrom: "",
    validityTo: "",
  });

  const handleVerification = () => {
    // Simulate verification
    const isValid = Math.random() > 0.3;
    setVerificationResult({
      status: isValid ? "verified" : "not-found",
      reraNumber: verificationForm.reraNumber,
      validityDate: "2025-12-31",
      projectName: verificationForm.projectName,
    });
  };

  const statePortals = [
    { name: "Andhra Pradesh RERA", url: "https://aprera.ap.gov.in" },
    { name: "Arunachal Pradesh RERA", url: "https://arunachalrera.gov.in" },
    { name: "Himachal Pradesh RERA", url: "https://himachalrera.nic.in" },
    { name: "Madhya Pradesh RERA", url: "https://mprera.nic.in" },
    { name: "Chhattisgarh RERA", url: "https://cgrera.gov.in" },
    { name: "Delhi RERA", url: "https://www.delhi.gov.in/rera" },
    { name: "Goa RERA", url: "https://goarera.gov.in" },
    { name: "Gujarat RERA", url: "https://gujrera.gujarat.gov.in" },
    { name: "Haryana RERA", url: "https://haryanarera.gov.in" },
    { name: "Assam RERA", url: "https://assamrera.gov.in" },
    { name: "Jharkhand RERA", url: "https://jrrera.nic.in" },
    { name: "Karnataka RERA", url: "https://rera.karnataka.gov.in" },
    { name: "Kerala RERA", url: "https://k-rera.kerala.gov.in" },
    { name: "Bihar RERA", url: "https://rera.bihar.gov.in" },
    { name: "Maharashtra RERA", url: "https://maharera.mahaonline.gov.in" },
    { name: "Manipur RERA", url: "https://manipurrera.gov.in" },
    { name: "Meghalaya RERA", url: "https://meghalayarera.gov.in" },
    { name: "Mizoram RERA", url: "https://mizoramrera.gov.in" },
    { name: "Nagaland RERA", url: "https://nagalandrera.gov.in" },
    { name: "Odisha RERA", url: "https://orera.odisha.gov.in" },
    { name: "Punjab RERA", url: "https://punjabrera.punjab.gov.in" },
    { name: "Rajasthan RERA", url: "https://rera.rajasthan.gov.in" },
    { name: "Sikkim RERA", url: "https://sikkimrera.gov.in" },
    { name: "Tamil Nadu RERA", url: "https://www.tnrera.tn.gov.in" },
    { name: "Telangana RERA", url: "https://tsrera.telangana.gov.in" },
    { name: "Tripura RERA", url: "https://tripurarera.gov.in" },
    { name: "Uttar Pradesh RERA", url: "https://www.up-rera.in" },
    { name: "Uttarakhand RERA", url: "https://ukrera.uk.gov.in" },
    { name: "West Bengal RERA", url: "https://wbrera.wb.gov.in" },
  ];

  return (
    <>
      <style>{`
        .rera-hero {
          background: #f9fafb !important;
          padding: 4rem 1rem !important;
          text-align: center !important;
        }
        .rera-hero h1 {
          font-size: 3rem !important;
          font-weight: 700 !important;
          margin-bottom: 1rem !important;
          color: #111827 !important;
        }
        .rera-hero p {
          font-size: 1.125rem !important;
          margin-bottom: 0 !important;
          color: #4b5563 !important;
          max-width: 48rem !important;
          margin-left: auto !important;
          margin-right: auto !important;
        }
        .rera-intro {
          background: #0056D2 !important;
          color: white !important;
          padding: 3rem 1rem !important;
          text-align: center !important;
        }
        .rera-intro h2 {
          font-size: 2rem !important;
          font-weight: 700 !important;
          margin-bottom: 1rem !important;
          color: white !important;
        }
        .rera-intro p {
          font-size: 1rem !important;
          color: #e0f2fe !important;
          max-width: 48rem !important;
          margin: 0 auto !important;
        }
        .rera-actions {
          padding: 4rem 1rem !important;
          background: white !important;
        }
        .rera-actions h2 {
          font-size: 1.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 2rem !important;
          color: #111827 !important;
        }
        .rera-action-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)) !important;
          gap: 1.5rem !important;
        }
        .rera-action-card {
          background: white !important;
          padding: 0 !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          text-align: center !important;
          transition: all 0.3s ease !important;
          cursor: pointer !important;
          overflow: hidden !important;
          border: 1px solid #e2e8f0 !important;
        }
        .rera-action-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
          border-color: #cbd5e1 !important;
        }
        .rera-action-image {
          width: 100% !important;
          height: 150px !important;
          object-fit: cover !important;
        }
        .rera-action-content {
          padding: 1.5rem !important;
        }
        .rera-action-content h3 {
          font-size: 1.125rem !important;
          font-weight: 600 !important;
          margin-bottom: 0.5rem !important;
          color: #111827 !important;
        }
        .rera-action-content p {
          color: #4b5563 !important;
          line-height: 1.5 !important;
          font-size: 0.875rem !important;
        }

        .rera-section {
          padding: 3rem 1rem !important;
          background: white !important;
        }
        .rera-section h2 {
          font-size: 1.5rem !important;
          font-weight: 700 !important;
          margin-bottom: 1.5rem !important;
          color: #111827 !important;
          text-align: center !important;
        }
        .rera-form {
          max-width: 40rem !important;
          margin: 0 auto !important;
          background: linear-gradient(135deg, #ffffff 0%, #f8faff 100%) !important;
          padding: 2rem !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 86, 210, 0.1) !important;
          border: 1px solid #e0f2fe !important;
        }
        .rera-form-group {
          margin-bottom: 1.5rem !important;
        }
        .rera-form-label {
          display: block !important;
          margin-bottom: 0.5rem !important;
          font-weight: 600 !important;
          color: #374151 !important;
        }
        .rera-result {
          margin-top: 2rem !important;
          padding: 1.5rem !important;
          border-radius: 0.5rem !important;
          text-align: center !important;
        }
        .rera-result.verified {
          background: #d1fae5 !important;
          border: 1px solid #10b981 !important;
        }
        .rera-result.not-found {
          background: #fee2e2 !important;
          border: 1px solid #ef4444 !important;
        }
        .rera-result.pending {
          background: #fef3c7 !important;
          border: 1px solid #f59e0b !important;
        }
        .rera-badge {
          display: inline-block !important;
          padding: 0.5rem 1rem !important;
          border-radius: 0.5rem !important;
          font-weight: 600 !important;
          margin-bottom: 1rem !important;
        }
        .rera-badge.verified {
          background: #10b981 !important;
          color: white !important;
        }
        .rera-badge.not-found {
          background: #ef4444 !important;
          color: white !important;
        }
        .rera-badge.pending {
          background: #f59e0b !important;
          color: white !important;
        }
        .rera-portals-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)) !important;
          gap: 1rem !important;
          max-width: 60rem !important;
          margin: 0 auto !important;
        }
        .rera-portal-card {
          background: white !important;
          padding: 0.75rem !important;
          border-radius: 0.5rem !important;
          box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08) !important;
          transition: all 0.3s ease !important;
          border: 1px solid #e2e8f0 !important;
        }
        .rera-portal-card:hover {
          transform: translateY(-4px) !important;
          box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12) !important;
          border-color: #0056D2 !important;
          background: #f8faff !important;
        }
        .rera-portal-card:hover h3 {
          color: #0056D2 !important;
        }
        .rera-portal-link {
          color: #0056D2 !important;
          text-decoration: none !important;
          font-weight: 600 !important;
          display: flex !important;
          align-items: center !important;
          gap: 0.5rem !important;
          transition: all 0.3s ease !important;
          cursor: pointer !important;
        }
        .rera-portal-link:hover {
          color: #003d99 !important;
          text-decoration: underline !important;
        }
        .rera-needs {
          padding: 4rem 1rem !important;
          background: white !important;
        }
        .rera-needs h2 {
          font-size: 1.75rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 2rem !important;
          color: #111827 !important;
        }
        .rera-needs-grid {
          display: grid !important;
          grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)) !important;
          gap: 1.5rem !important;
        }
        .rera-needs-card {
          background: white !important;
          padding: 0 !important;
          border-radius: 1rem !important;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
          text-align: center !important;
          transition: all 0.3s ease !important;
          overflow: hidden !important;
          border: 1px solid #e2e8f0 !important;
        }
        .rera-needs-card:hover {
          transform: translateY(-8px) !important;
          box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12) !important;
          border-color: #cbd5e1 !important;
        }
        .rera-needs-image {
          width: 100% !important;
          height: 150px !important;
          object-fit: cover !important;
        }
        .rera-needs-content {
          padding: 1.5rem !important;
        }
        .rera-benefits {
          padding: 3rem 1rem !important;
          background: white !important;
        }
        .rera-benefits h2 {
          font-size: 1.5rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 2rem !important;
          color: #111827 !important;
        }
        .rera-benefits-list {
          max-width: 48rem !important;
          margin: 0 auto !important;
        }
        .rera-benefit-item {
          display: flex !important;
          align-items: center !important;
          gap: 1rem !important;
          margin-bottom: 1rem !important;
          font-size: 1.125rem !important;
        }
        .rera-benefit-icon {
          background: #e0f2fe !important;
          border-radius: 50% !important;
          padding: 0.5rem !important;
          color: #0056D2 !important;
        }
        .rera-faqs {
          padding: 3rem 1rem !important;
          background: white !important;
        }
        .rera-faqs h2 {
          font-size: 1.5rem !important;
          font-weight: 700 !important;
          text-align: center !important;
          margin-bottom: 2rem !important;
          color: #111827 !important;
        }
        .rera-faq-item {
          background: white !important;
          padding: 1rem !important;
          border-radius: 0.75rem !important;
          margin-bottom: 0.75rem !important;
          box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08) !important;
        }
        .rera-faq-question {
          font-weight: 600 !important;
          color: #1e293b !important;
          margin-bottom: 0.5rem !important;
        }
        .rera-faq-answer {
          color: #64748b !important;
        }
        .rera-support {
          padding: 1.5rem 1rem !important;
          background: #0056D2 !important;
          color: white !important;
          text-align: center !important;
        }
        .rera-support h2 {
          font-size: 2rem !important;
          font-weight: 700 !important;
          margin-bottom: 1rem !important;
          color: white !important;
        }
        .rera-support-contact {
          display: flex !important;
          flex-direction: column !important;
          gap: 1rem !important;
          margin-bottom: 2rem !important;
          align-items: center !important;
        }
        .rera-contact-item {
          display: flex !important;
          align-items: center !important;
          gap: 0.75rem !important;
          color: #e0f2fe !important;
          font-size: 0.875rem !important;
        }
        .rera-support-buttons {
          display: flex !important;
          gap: 1rem !important;
          justify-content: center !important;
          flex-wrap: wrap !important;
        }
      `}</style>
      <div className="min-h-screen bg-white">
        {/* Back Button */}
        <div className="p-4">
          <button
            onClick={() => navigate(-1)}
            className="flex items-center gap-2 text-[#0056D2] hover:text-[#003d99] transition-colors"
          >
            <ArrowLeft className="w-5 h-5" />
            <span className="font-medium">Back</span>
          </button>
        </div>

        {/* Hero Section */}
        <section className="rera-intro">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>What is RERA & Why It Matters?</h2>
            <p>
              RERA (Real Estate Regulatory Authority) ensures that all real
              estate projects and agents follow transparent, legal, and fair
              practices. With NAL's RERA Compliance Assistance, buyers can
              verify project authenticity and sellers can easily submit their
              RERA details for review.
            </p>
          </div>
        </section>

        {/* Who Needs RERA Registration */}
        <section className="rera-needs">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Who Needs RERA Registration?</h2>
            <div className="rera-needs-grid">
              <div className="rera-needs-card">
                <img
                  src="https://images.unsplash.com/photo-1560518883-ce09059eeffa?w=400&h=250&fit=crop"
                  alt="Builders and Promoters"
                  className="rera-needs-image"
                />
                <div className="rera-needs-content">
                  <h3 className="text-xl font-semibold mb-2">
                    Builders/Promoters
                  </h3>
                  <p className="text-sm text-[#0056D2] font-medium mb-2">
                    Commercial Developers & Project Promoters
                  </p>
                  <p className="text-gray-600">
                    All new projects with land area ≥ 500 sq m or units ≥ 8 must
                    register with RERA before marketing or selling properties.
                  </p>
                </div>
              </div>
              <div className="rera-needs-card">
                <img
                  src="https://images.unsplash.com/photo-1521791136064-7986c2920216?w=400&h=250&fit=crop"
                  alt="Real Estate Agents"
                  className="rera-needs-image"
                />
                <div className="rera-needs-content">
                  <h3 className="text-xl font-semibold mb-2">
                    Real Estate Agents
                  </h3>
                  <p className="text-sm text-[#0056D2] font-medium mb-2">
                    Licensed Property Consultants & Brokers
                  </p>
                  <p className="text-gray-600">
                    Agents dealing in RERA-registered projects must obtain Agent
                    RERA ID and maintain compliance with regulatory standards.
                  </p>
                </div>
              </div>
              <div className="rera-needs-card">
                <img
                  src="https://images.unsplash.com/photo-1570129477492-45c003edd2be?w=400&h=250&fit=crop"
                  alt="Individual Homeowners"
                  className="rera-needs-image"
                />
                <div className="rera-needs-content">
                  <h3 className="text-xl font-semibold mb-2">
                    Individual Homeowners
                  </h3>
                  <p className="text-sm text-[#0056D2] font-medium mb-2">
                    Private Property Owners & Resellers
                  </p>
                  <p className="text-gray-600">
                    Resale of existing properties does not require RERA
                    registration, but buyers should verify original RERA
                    compliance.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Benefits of RERA Compliance */}
        <section className="rera-benefits">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Benefits of RERA Compliance</h2>
            <p className="text-center text-gray-600 mb-8 max-w-3xl mx-auto">
              RERA compliance ensures transparency, accountability, and
              protection for all stakeholders in real estate transactions.
            </p>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
              <div
                className="p-4 rounded-xl shadow-sm border border-gray-200 transition-all duration-300 hover:bg-[#f8faff] hover:border-[#0056D2] hover:transform hover:translate-y-[-4px] hover:shadow-lg"
                style={{ background: "#f0f8ff" }}
              >
                <Shield className="w-10 h-10 text-[#0056D2] mx-auto mb-3" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Legal Transparency
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Ensures complete transparency in all property transactions
                  with standardized documentation and clear legal frameworks.
                </p>
              </div>
              <div
                className="p-6 rounded-xl shadow-sm border border-gray-200 transition-all duration-300 hover:bg-[#f8faff] hover:border-[#0056D2] hover:transform hover:translate-y-[-4px] hover:shadow-lg"
                style={{ background: "#f0f8ff" }}
              >
                <FileText className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Verified Documentation
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  All property listings come with authentic, verified
                  documentation reducing the risk of fraudulent transactions.
                </p>
              </div>
              <div
                className="p-6 rounded-xl shadow-sm border border-gray-200 transition-all duration-300 hover:bg-[#f8faff] hover:border-[#0056D2] hover:transform hover:translate-y-[-4px] hover:shadow-lg"
                style={{ background: "#f0f8ff" }}
              >
                <Users className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Buyer Trust
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Builds strong buyer confidence through continuous regulatory
                  oversight and standardized practices.
                </p>
              </div>
              <div
                className="p-6 rounded-xl shadow-sm border border-gray-200 transition-all duration-300 hover:bg-[#f8faff] hover:border-[#0056D2] hover:transform hover:translate-y-[-4px] hover:shadow-lg"
                style={{ background: "#f0f8ff" }}
              >
                <Scale className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Fraud Protection
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Significantly reduces fraud and protects consumer interests
                  through strict regulatory compliance measures.
                </p>
              </div>
              <div
                className="p-6 rounded-xl shadow-sm border border-gray-200 transition-all duration-300 hover:bg-[#f8faff] hover:border-[#0056D2] hover:transform hover:translate-y-[-4px] hover:shadow-lg"
                style={{ background: "#f0f8ff" }}
              >
                <Building className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Mandatory Compliance
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  All new development projects must comply with RERA regulations
                  ensuring quality and timely delivery.
                </p>
              </div>
              <div
                className="p-6 rounded-xl shadow-sm border border-gray-200 transition-all duration-300 hover:bg-[#f8faff] hover:border-[#0056D2] hover:transform hover:translate-y-[-4px] hover:shadow-lg"
                style={{ background: "#f0f8ff" }}
              >
                <CheckCircle className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Quality Assurance
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  RERA ensures adherence to quality standards and timely project
                  completion with regular monitoring and penalties for delays.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* RERA Guidance & Quick Actions */}
        <section className="rera-needs" style={{ background: "#f8fafc" }}>
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="p-6 mb-8">
              <h2 className="text-center">RERA Guidance & Resources</h2>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
              {/* Buyers Guidance Card */}
              <div
                className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl shadow-sm border border-blue-100 text-center cursor-pointer transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-[#0056D2] hover:transform hover:translate-y-[-4px] hover:shadow-lg"
                onClick={() => navigate("/services/rera-guidance-buyers")}
              >
                <Users className="w-12 h-12 text-[#0056D2] mx-auto mb-3" />
                <h3 className="text-lg font-bold text-gray-900 mb-3">
                  RERA Guidance for Buyers
                </h3>
                <p className="text-gray-600 mb-4 text-sm">
                  Essential tips for buyers to verify RERA compliance and
                  protect yourself from fraud.
                </p>
                <div className="flex items-center justify-center gap-2 text-[#0056D2] font-semibold text-sm">
                  <span>Buyer's Guide</span>
                  <ArrowRight className="w-4 h-4" />
                </div>
              </div>

              {/* Builders & Promoters Guidance Card */}
              <div
                className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl shadow-sm border border-blue-100 text-center cursor-pointer transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-[#0056D2] hover:transform hover:translate-y-[-4px] hover:shadow-lg"
                onClick={() => navigate("/services/rera-registration-guidance")}
              >
                <Building className="w-12 h-12 text-[#0056D2] mx-auto mb-3" />
                <h3 className="text-lg font-bold text-gray-900 mb-3">
                  RERA Guidance for Builders
                </h3>
                <p className="text-gray-600 mb-4 text-sm">
                  Complete step-by-step guide for registration, documentation,
                  and compliance.
                </p>
                <div className="flex items-center justify-center gap-2 text-[#0056D2] font-semibold text-sm">
                  <span>Builder's Guide</span>
                  <ArrowRight className="w-4 h-4" />
                </div>
              </div>

              {/* Quick RERA Action */}
              <div
                className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl shadow-sm border border-blue-100 text-center cursor-pointer transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-[#0056D2] hover:transform hover:translate-y-[-4px] hover:shadow-lg"
                onClick={() => setActiveSection("portals")}
              >
                <Globe className="w-12 h-12 text-[#0056D2] mx-auto mb-3" />
                <h3 className="text-lg font-bold text-gray-900 mb-3">
                  State RERA Portals
                </h3>
                <p className="text-gray-600 mb-4 text-sm">
                  Access official RERA portals for all 36 Indian states and UTs.
                </p>
                <div className="flex items-center justify-center gap-2 text-[#0056D2] font-semibold text-sm">
                  <span>Visit Portals</span>
                  <ArrowRight className="w-4 h-4" />
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* State-wise RERA Portals Section */}
        {activeSection === "portals" && (
          <section className="rera-section">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
              <h2>India RERA Portals</h2>
              <p className="text-center text-gray-600 mb-8 max-w-3xl mx-auto">
                Access official state RERA portals for registration
                verification, project details, and regulatory compliance
                information.
              </p>
              <div className="rera-portals-grid">
                {statePortals.map((portal, index) => (
                  <div key={index} className="rera-portal-card">
                    <div className="flex items-center gap-2 mb-2">
                      <MapPin className="w-5 h-5 text-[#0056D2]" />
                      <h3 className="font-semibold text-lg text-gray-800">
                        {portal.name}
                      </h3>
                    </div>
                    <a
                      className="rera-portal-link"
                      href={portal.url}
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      Visit Official Portal
                      <ExternalLink className="w-4 h-4" />
                    </a>
                  </div>
                ))}
              </div>
              <div className="mt-6 text-center">
                <Button
                  onClick={() => setActiveSection("")}
                  variant="outline"
                  className="border-gray-300 text-gray-700 hover:bg-gray-50"
                >
                  Cancel
                </Button>
              </div>
            </div>
          </section>
        )}

        {/* FAQs */}
        <section
          className="rera-faqs"
          style={{
            background: "linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%)",
          }}
        >
          <h2>Frequently Asked Questions</h2>
          <div className="max-w-4xl mx-auto">
            <div className="rera-faq-item">
              <div className="rera-faq-question">
                Q: Which projects need RERA registration?
              </div>
              <div className="rera-faq-answer">
                A: Projects with land area ≥500 sq m or ≥8 units must register.
                Single plots and buildings with &lt;8 units are exempt.
              </div>
            </div>
            <div className="rera-faq-item">
              <div className="rera-faq-question">
                Q: How can I verify if a project is RERA registered?
              </div>
              <div className="rera-faq-answer">
                A: Check the state RERA website, look for RERA number in
                advertisements, or ask the builder for registration certificate.
              </div>
            </div>
            <div className="rera-faq-item">
              <div className="rera-faq-question">
                Q: Can I get refund if project is delayed?
              </div>
              <div className="rera-faq-answer">
                A: Yes, you can claim refund with interest if the project is
                delayed beyond the promised date.
              </div>
            </div>
            <div className="rera-faq-item">
              <div className="rera-faq-question">
                Q: How long does RERA registration take?
              </div>
              <div className="rera-faq-answer">
                A: Typically 30-60 days after submitting complete documents,
                depending on state RERA processing time.
              </div>
            </div>
            <div className="rera-faq-item">
              <div className="rera-faq-question">
                Q: Is resale property RERA applicable?
              </div>
              <div className="rera-faq-answer">
                A: No, RERA only applies to new projects. Resale properties are
                not covered under RERA regulations.
              </div>
            </div>
            <div className="rera-faq-item">
              <div className="rera-faq-question">
                Q: What are the penalties for non-compliance?
              </div>
              <div className="rera-faq-answer">
                A: Penalties up to 10% of project cost, imprisonment up to 3
                years, and project deregistration for serious violations.
              </div>
            </div>
          </div>
        </section>
      </div>
    </>
  );
}