import React from "react";
import {
  Users,
  Shield,
  Search,
  AlertTriangle,
  CheckCircle,
  FileText,
  Calendar,
  Eye,
  Phone,
  Scale,
  ArrowLeft,
} from "lucide-react";
import { useNavigate } from "react-router-dom";
import { Button } from "../../components/ui/button";

export function RERAGuidanceBuyers() {
  const navigate = useNavigate();

  return (
    <>
      <style>{`
        .buyers-hero {
          background: linear-gradient(135deg, #0056D2 0%, #004bb5 100%);
          padding: 3rem 1rem;
          text-align: center;
          color: white;
        }
        .buyers-hero h1 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 1rem;
          color: white;
        }
        .buyers-hero p {
          font-size: 1.125rem;
          color: #e0f2fe;
          max-width: 48rem;
          margin: 0 auto;
        }
        .buyers-section {
          padding: 3rem 1rem;
          background: #f9fafb;
        }
        .buyers-section.with-bg {
          background: white;
          position: relative;
        }
        .buyers-section h2 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 2rem;
          color: #111827;
          text-align: center;
        }
        .tip-card {
          background: linear-gradient(135deg, #eff6ff 0%, #ecfeff 100%);
          padding: 2rem;
          border-radius: 1rem;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
          border: 1px solid #a5b4fc;
          transition: all 0.3s ease;
          text-align: center;
          cursor: pointer;
        }
        .tip-card:hover {
          background: linear-gradient(135deg, #dbeafe 0%, #cffafe 100%);
          transform: translateY(-4px);
          box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
          border-color: #0056D2;
        }
      `}</style>

      <div className="min-h-screen bg-white">
        {/* Back Button */}
        <div className="p-4">
          <button
            onClick={() => navigate(-1)}
            className="flex items-center gap-2 text-[#0056D2] hover:text-[#003d99] transition-colors"
          >
            <ArrowLeft className="w-5 h-5" />
            <span className="font-medium">Back</span>
          </button>
        </div>

        {/* Hero Section */}
        <section className="buyers-hero">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1>RERA Guidance for Buyers</h1>
            <p>
              Essential tips and guidelines to protect yourself when buying
              property. Learn how to verify RERA compliance and understand your
              rights as a buyer.
            </p>
          </div>
        </section>

        {/* Essential Buyer Tips */}
        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Essential Buyer Protection Tips</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
              <div className="tip-card">
                <AlertTriangle className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Never Buy Without RERA
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Never purchase a flat in a new project without a valid RERA
                  registration number. This is your primary protection against
                  fraud.
                </p>
              </div>

              <div className="tip-card">
                <Search className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Verify Project Details
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Check if the RERA number matches exactly with the project
                  name, location, and builder details on official RERA portal.
                </p>
              </div>

              <div className="tip-card">
                <Calendar className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Check Validity Status
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Verify if the project validity is still active and not
                  expired. Check completion timeline and delivery dates.
                </p>
              </div>

              <div className="tip-card">
                <FileText className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Review All Documents
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Carefully review sale agreement, payment schedule, and all
                  project documents before making any payments.
                </p>
              </div>

              <div className="tip-card">
                <Eye className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Site Visit & Inspection
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Visit the project site personally and verify construction
                  progress matches the timeline mentioned in RERA portal.
                </p>
              </div>

              <div className="tip-card">
                <Shield className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Know Your Rights
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Understand your rights under RERA including compensation for
                  delays and right to cancel booking with refund.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Verification Checklist */}
        <section className="buyers-section">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>RERA Verification Checklist</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl border border-blue-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-blue-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <CheckCircle className="w-5 h-5 text-blue-600" />
                  Before Booking
                </h3>
                <ul className="space-y-3 text-sm text-gray-700">
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>
                      Verify RERA registration number on official state portal
                    </span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>
                      Check project completion date and current status
                    </span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>
                      Verify builder's track record and previous projects
                    </span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>
                      Review project layout, amenities, and specifications
                    </span>
                  </li>
                </ul>
              </div>

              <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl border border-blue-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-blue-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <FileText className="w-5 h-5 text-blue-600" />
                  During Purchase
                </h3>
                <ul className="space-y-3 text-sm text-gray-700">
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>
                      Ensure RERA number is mentioned in sale agreement
                    </span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>
                      Check carpet area calculation as per RERA guidelines
                    </span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Verify possession date and penalty clauses</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full mt-2 flex-shrink-0"></div>
                    <span>Get all approvals and clearances in writing</span>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        {/* Your Rights Under RERA */}
        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Your Rights Under RERA</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
              <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-6 rounded-xl shadow-sm border border-blue-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-blue-100 hover:to-cyan-100 hover:border-blue-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <Scale className="w-12 h-12 text-blue-600 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Timely Possession
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Right to get possession on agreed date or compensation for
                  delays as per RERA guidelines.
                </p>
              </div>

              <div className="bg-gradient-to-br from-green-50 to-emerald-50 p-6 rounded-xl shadow-sm border border-green-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-green-100 hover:to-emerald-100 hover:border-green-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <FileText className="w-12 h-12 text-blue-600 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Transparent Information
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Right to get complete and accurate information about the
                  project including all approvals and clearances.
                </p>
              </div>

              <div className="bg-gradient-to-br from-purple-50 to-indigo-50 p-6 rounded-xl shadow-sm border border-purple-200 transition-all duration-300 hover:bg-gradient-to-br hover:from-purple-100 hover:to-indigo-100 hover:border-purple-300 hover:transform hover:translate-y-[-4px] hover:shadow-lg cursor-pointer">
                <Shield className="w-12 h-12 text-blue-600 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2 text-center">
                  Refund & Cancellation
                </h3>
                <p className="text-sm text-gray-600 text-center">
                  Right to cancel booking and get refund with interest in case
                  of project delays or non-compliance.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Red Flags to Watch */}
        <section className="buyers-section" style={{ background: "white" }}>
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="bg-red-50 border-l-4 border-red-400 p-6 rounded-lg">
              <div className="flex items-start gap-3">
                <AlertTriangle className="w-6 h-6 text-red-600 mt-1" />
                <div>
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Red Flags to Avoid
                  </h3>
                  <ul className="space-y-2 text-sm text-gray-700">
                    <li>• Projects without valid RERA registration</li>
                    <li>
                      • Builders asking for full payment before possession
                    </li>
                    <li>• Projects with expired RERA validity</li>
                    <li>• Unrealistic possession timelines or prices</li>
                    <li>• Lack of proper documentation or approvals</li>
                    <li>• Builders with history of project delays</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Contact & Support */}
        <section className="buyers-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 className="text-base">Need Help or Have Complaints?</h2>
            <div className="flex justify-center">
              <Button
                className="bg-blue-600 hover:bg-blue-700 text-white p-2 h-auto flex flex-col items-center gap-1"
                style={{ backgroundColor: "#2563eb", color: "white" }}
                onClick={() => navigate("/contact")}
              >
                <Users className="w-4 h-4" />
                <span className="text-xs">Get Expert Help</span>
              </Button>
            </div>
          </div>
        </section>
      </div>
    </>
  );
}