import React from "react";
import {
  Building,
  FileText,
  CheckCircle,
  Clock,
  AlertTriangle,
  ArrowRight,
  ArrowLeft,
  Download,
  Users,
  Scale,
  Home,
} from "lucide-react";
import { useNavigate } from "react-router-dom";
import { Button } from "../../components/ui/button";

export function RERARegistrationGuidance() {
  const navigate = useNavigate();

  return (
    <>
      <style>{`
        .guidance-hero {
          background: linear-gradient(135deg, #0056D2 0%, #004bb5 100%);
          padding: 4rem 1rem;
          text-align: center;
          color: white;
        }
        .guidance-hero h1 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 1rem;
          color: white;
        }
        .guidance-hero p {
          font-size: 1.125rem;
          color: #e0f2fe;
          max-width: 48rem;
          margin: 0 auto;
        }
        .guidance-section {
          padding: 3rem 1rem;
          background: #f9fafb;
        }
        .guidance-section.with-bg {
          background: #f9fafb;
          position: relative;
        }
        .guidance-section.with-bg::before {
          content: '';
          position: absolute;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          background: rgba(249, 250, 251, 0.9);
          z-index: 1;
        }
        .guidance-section.with-bg > * {
          position: relative;
          z-index: 2;
        }
        .guidance-section h2 {
          font-size: 2rem;
          font-weight: 700;
          margin-bottom: 2rem;
          color: #111827;
          text-align: center;
        }
        .step-card {
          background: white;
          padding: 2rem;
          border-radius: 1rem;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
          border: 1px solid #e5e7eb;
          transition: all 0.3s ease;
        }
        .step-card:hover {
          transform: translateY(-4px);
          box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
          border-color: #0056D2;
          background: white;
        }
        .document-card {
          background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
          padding: 1.5rem;
          border-radius: 0.75rem;
          box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
          border: 1px solid #bae6fd;
          transition: all 0.3s ease;
        }
        .document-card:hover {
          transform: translateY(-4px);
          box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
          border-color: #0056D2;
          background: linear-gradient(135deg, #e0f2fe 0%, #bae6fd 100%);
        }
      `}</style>

      <div className="min-h-screen bg-white">
        {/* Back Button */}
        <div className="p-4">
          <button
            onClick={() => navigate(-1)}
            className="flex items-center gap-2 text-[#0056D2] hover:text-[#003d99] transition-colors"
          >
            <ArrowLeft className="w-5 h-5" />
            <span className="font-medium">Back</span>
          </button>
        </div>

        {/* Hero Section */}
        <section className="guidance-hero">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1>RERA Registration Guidance for Builders & Promoters</h1>
            <p>
              Complete step-by-step guide to register your real estate projects
              with RERA authorities. Ensure compliance and build buyer trust
              with proper registration.
            </p>
          </div>
        </section>

        {/* Registration Steps */}
        <section className="guidance-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Step-by-Step Registration Process</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
              <div className="step-card">
                <div className="flex items-center gap-3 mb-4">
                  <div className="w-8 h-8 bg-[#0056D2] text-white rounded-full flex items-center justify-center font-bold">
                    1
                  </div>
                  <FileText className="w-8 h-8 text-[#0056D2]" />
                </div>
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  Document Preparation
                </h3>
                <p className="text-sm text-gray-600">
                  Gather all required documents including land title, approvals,
                  NOCs, and project plans.
                </p>
              </div>

              <div className="step-card">
                <div className="flex items-center gap-3 mb-4">
                  <div className="w-8 h-8 bg-[#0056D2] text-white rounded-full flex items-center justify-center font-bold">
                    2
                  </div>
                  <Users className="w-8 h-8 text-[#0056D2]" />
                </div>
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  Promoter Registration
                </h3>
                <p className="text-sm text-gray-600">
                  Register as a promoter with RERA authority in your state
                  before project registration.
                </p>
              </div>

              <div className="step-card">
                <div className="flex items-center gap-3 mb-4">
                  <div className="w-8 h-8 bg-[#0056D2] text-white rounded-full flex items-center justify-center font-bold">
                    3
                  </div>
                  <Home className="w-8 h-8 text-[#0056D2]" />
                </div>
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  Project Registration
                </h3>
                <p className="text-sm text-gray-600">
                  Submit project details, upload documents, and pay registration
                  fees online.
                </p>
              </div>

              <div className="step-card">
                <div className="flex items-center gap-3 mb-4">
                  <div className="w-8 h-8 bg-[#0056D2] text-white rounded-full flex items-center justify-center font-bold">
                    4
                  </div>
                  <Scale className="w-8 h-8 text-[#0056D2]" />
                </div>
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  Verification Process
                </h3>
                <p className="text-sm text-gray-600">
                  RERA authority reviews documents and conducts site
                  verification if required.
                </p>
              </div>

              <div className="step-card">
                <div className="flex items-center gap-3 mb-4">
                  <div className="w-8 h-8 bg-[#0056D2] text-white rounded-full flex items-center justify-center font-bold">
                    5
                  </div>
                  <CheckCircle className="w-8 h-8 text-[#0056D2]" />
                </div>
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  Certificate Issuance
                </h3>
                <p className="text-sm text-gray-600">
                  Receive RERA registration certificate and unique registration
                  number.
                </p>
              </div>

              <div className="step-card">
                <div className="flex items-center gap-3 mb-4">
                  <div className="w-8 h-8 bg-[#0056D2] text-white rounded-full flex items-center justify-center font-bold">
                    6
                  </div>
                  <Clock className="w-8 h-8 text-[#0056D2]" />
                </div>
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  Ongoing Compliance
                </h3>
                <p className="text-sm text-gray-600">
                  Submit quarterly progress reports and maintain compliance
                  throughout project lifecycle.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Required Documents */}
        <section
          className="guidance-section with-bg"
          style={{ background: "transparent" }}
        >
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Required Documents Checklist</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              <div className="document-card">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <FileText className="w-5 h-5 text-[#0056D2]" />
                  Land & Legal Documents
                </h3>
                <ul className="space-y-2 text-sm text-gray-700">
                  <li className="flex items-center gap-2">
                    <CheckCircle className="w-4 h-4 text-green-500" />
                    Clear title deed of land
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="w-4 h-4 text-green-500" />
                    Sanctioned building plan
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="w-4 h-4 text-green-500" />
                    Commencement certificate
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="w-4 h-4 text-green-500" />
                    Environmental clearance (if applicable)
                  </li>
                </ul>
              </div>

              <div className="document-card">
                <h3 className="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
                  <Building className="w-5 h-5 text-[#0056D2]" />
                  Project & Financial Documents
                </h3>
                <ul className="space-y-2 text-sm text-gray-700">
                  <li className="flex items-center gap-2">
                    <CheckCircle className="w-4 h-4 text-green-500" />
                    Project layout and specifications
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="w-4 h-4 text-green-500" />
                    Financial statements and audited accounts
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="w-4 h-4 text-green-500" />
                    Bank guarantee or deposit
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="w-4 h-4 text-green-500" />
                    Project completion timeline
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        {/* Important Notes */}
        <section className="guidance-section with-bg">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="bg-yellow-50 border-l-4 border-yellow-400 p-6 rounded-lg">
              <div className="flex items-start gap-3">
                <AlertTriangle className="w-6 h-6 text-yellow-600 mt-1" />
                <div>
                  <h3 className="text-lg font-semibold text-gray-900 mb-2">
                    Important Guidelines
                  </h3>
                  <ul className="space-y-2 text-sm text-gray-700">
                    <li>
                      • Projects with land area ≥ 500 sq m or ≥ 8 units must
                      register
                    </li>
                    <li>
                      • Registration must be completed before marketing or
                      selling
                    </li>
                    <li>• Quarterly progress reports are mandatory</li>
                    <li>
                      • Non-compliance attracts penalties and project suspension
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Download Resources */}
        <section
          className="guidance-section with-bg"
          style={{ background: "transparent" }}
        >
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2>Download Resources</h2>
            <div className="flex justify-center gap-8">
              <Button
                className="bg-[#0056D2] hover:bg-[#004bb5] text-white p-2 h-auto flex flex-col items-center gap-1 w-30"
                onClick={async () => {
                  const { generateRERAChecklistPDF } = await import(
                    "../../utils/pdfGenerator"
                  );
                  await generateRERAChecklistPDF();
                }}
              >
                <Download className="w-4 h-4" />
                <span className="font-medium text-xs">
                  Document Checklist PDF
                </span>
              </Button>

              <Button
                className="bg-blue-600 hover:bg-blue-700 text-white p-2 h-auto flex flex-col items-center gap-1 w-30"
                style={{ backgroundColor: "#2563eb", color: "white" }}
                onClick={async () => {
                  const { generateRERACompliancePDF } = await import(
                    "../../utils/pdfGenerator"
                  );
                  await generateRERACompliancePDF();
                }}
              >
                <Download className="w-4 h-4" />
                <span className="font-medium text-xs">Compliance Guide</span>
              </Button>
            </div>
          </div>
        </section>
      </div>
    </>
  );
}