import React from 'react';
import { useNavigate } from 'react-router-dom';
import { CheckCircle, Shield, Search, FileText } from 'lucide-react';
import { Button } from '../../components/ui/button';

export function TitleSearch() {
  const navigate = useNavigate();

  return (
    <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <div className="relative bg-gradient-to-br from-blue-600 via-blue-700 to-indigo-800 py-20 mt-3 overflow-hidden">
        <div className="absolute top-20 left-10 w-72 h-72 bg-white/5 rounded-full blur-3xl"></div>
        <div className="absolute bottom-20 right-10 w-96 h-96 bg-blue-400/10 rounded-full blur-3xl"></div>
        <div className="relative max-w-5xl mx-auto px-4 text-center">
          <h1 className="text-5xl font-bold text-black mb-6">Title Search & Property History Check</h1>
          <p className="text-xl text-blue-100 mb-8 leading-relaxed">
            Know the Property Before You Sign. NAL performs a deep background check to ensure the property has a clean history and clear ownership chain. With document fraud accounting for 12-18% of property disputes and over 6.5 million people affected by land conflicts, our comprehensive verification protects your investment.
          </p>
          <div className="inline-block bg-blue-900/90 text-black px-8 py-4 rounded-xl font-semibold text-lg shadow-xl border-2 border-blue-400/50 mb-8">
            Basic Title Search: ₹4,999 | Comprehensive Report: ₹7,999
          </div>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button 
              variant="outline" 
              className="border-2 border-white text-white hover:bg-white/10 px-8 py-4 font-semibold text-lg rounded-xl transition-all duration-300"
              onClick={() => navigate('/services/title-search-premium')}
            >
              Instant Verification
            </Button>
            <Button 
              className="bg-white text-blue-600 hover:bg-gray-100 px-8 py-4 font-semibold text-lg rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105"
              onClick={() => navigate('/services/title-search-premium')}
            >
              Start Title Search
            </Button>
          </div>
        </div>
      </div>

      {/* Service Images Section */}
      <div className="bg-gradient-to-b from-white to-gray-50 py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="text-center bg-white p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group">
              <img 
                src="https://images.unsplash.com/photo-1436450412740-6b988f486c6b?w=400&h=300&fit=crop"
                alt="Legal Verification" 
                className="w-full h-48 object-cover rounded-xl mb-6 shadow-md group-hover:scale-105 transition-transform duration-300"
              />
              <h3 className="text-xl font-bold text-gray-900 mb-3">Legal Verification</h3>
              <p className="text-gray-600">Prevent fraud in 12-18% dispute cases</p>
            </div>
            
            <div className="text-center bg-white p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group">
              <img 
                src="https://images.unsplash.com/photo-1554224155-6726b3ff858f?w=400&h=300&fit=crop"
                alt="Digital Verification" 
                className="w-full h-48 object-cover rounded-xl mb-6 shadow-md group-hover:scale-105 transition-transform duration-300"
              />
              <h3 className="text-xl font-bold text-gray-900 mb-3">Digital Verification</h3>
              <p className="text-gray-600">30-year history with blockchain validation</p>
            </div>
            
            <div className="text-center bg-white p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group">
              <img 
                src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=400&h=300&fit=crop"
                alt="Fraud Prevention" 
                className="w-full h-48 object-cover rounded-xl mb-6 shadow-md group-hover:scale-105 transition-transform duration-300"
              />
              <h3 className="text-xl font-bold text-gray-900 mb-3">Fraud Prevention</h3>
              <p className="text-gray-600">Reduce risk with 30-year verification</p>
            </div>
          </div>
        </div>
      </div>

      <div className="max-w-6xl mx-auto px-4 py-16 -mt-6">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Features */}
          <div className="bg-white p-8 rounded-2xl border border-gray-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Key Features</h2>
            <ul className="space-y-4">
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Complete ownership chain verification with 30-year historical record analysis</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Encumbrance certificate analysis and validation through government registry systems</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Mortgage and lien verification checks across banking databases</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Litigation and legal dispute investigation—critical as 1.25 lakh RERA complaints were resolved in recent years</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">RERA records validation with instant verification of project registration authenticity</span>
              </li>
            </ul>
          </div>

          {/* Benefits */}
          <div className="bg-white p-8 rounded-2xl border border-gray-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">Benefits</h2>
            <ul className="space-y-4">
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Prevents fraud and protects against legal complications—critical as forgery can attract 7 years imprisonment under IPC Section 468</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Ensures safe buying with complete legal transparency in line with Registration Bill 2025</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Eliminates legal surprises and hidden liabilities through comprehensive background checks</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Provides complete peace of mind backed by verification of 943 crore+ digital documents ecosystem</span>
              </li>
              <li className="flex items-start gap-3">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                <span className="text-gray-700">Ensures clear and marketable title for future transactions with blockchain validation</span>
              </li>
            </ul>
          </div>

          {/* Process */}
          <div className="bg-white p-8 rounded-2xl border border-gray-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
            <h2 className="text-2xl font-bold text-gray-900 mb-6">How It Works</h2>
            <ol className="space-y-4">
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">1</div>
                <span className="text-gray-700">Comprehensive document collection and initial verification with AI-powered fraud detection</span>
              </li>
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">2</div>
                <span className="text-gray-700">Registry verification and official record checks across state government databases</span>
              </li>
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">3</div>
                <span className="text-gray-700">Detailed legal investigation including 30-year encumbrance certificate and court record search</span>
              </li>
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">4</div>
                <span className="text-gray-700">Property history compilation analyzing ownership chain and transaction patterns</span>
              </li>
              <li className="flex items-start gap-3">
                <div className="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0 mt-0.5">5</div>
                <span className="text-gray-700">Clear title report with legal certification delivered within 7-10 days with risk assessment</span>
              </li>
            </ol>
          </div>
        </div>

        {/* CTA Section */}
        <div className="mt-16 bg-gradient-to-r from-blue-600 to-blue-700 rounded-2xl p-12 text-white text-center shadow-2xl relative overflow-hidden">
          <div className="absolute top-10 right-10 w-32 h-32 bg-white/10 rounded-full blur-2xl"></div>
          <div className="absolute bottom-10 left-10 w-40 h-40 bg-blue-400/20 rounded-full blur-2xl"></div>
          <div className="relative">
            <h2 className="text-4xl font-bold mb-6">Ready to Get Started?</h2>
            <p className="text-blue-100 mb-10 max-w-2xl mx-auto text-lg leading-relaxed">
              Contact our experts today to learn more about how title search & property history check can help you with data-backed insights and professional service.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button 
                variant="outline" 
                className="border-2 border-white text-white hover:bg-white/10 px-8 py-4 font-semibold text-lg rounded-xl transition-all duration-300"
              >
                Schedule Consultation
              </Button>
              <Button 
                className="bg-white text-blue-600 hover:bg-gray-100 px-8 py-4 font-semibold text-lg rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105"
              >
                Get Started Now
              </Button>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}