export interface Property {
  id: string;
  title: string;
  type: string;
  bhk?: string;
  address: string;
  city: string;
  state: string;
  pincode: string;
  landmark?: string;
  area: number;
  price: number;
  listingIntent: string;
  status: string;
  amenities: string[];
  customAmenities: string[];
  virtualTour?: string;
  sellerType?: string;
  biddingEnabled?: boolean;
  coordinates?: { lat: number; lng: number };
  views: number;
  inquiries: number;
  createdAt: string;
  updatedAt: string;
  description?: string;
  images?: any[];
  videos?: any[];
  imageCategories?: any;
}

export interface Lead {
  id: string;
  name: string;
  email: string;
  phone: string;
  propertyId: string;
  status: string;
  createdAt: string;
}

export interface Booking {
  id: string;
  propertyId: string;
  userId: string;
  date: string;
  status: string;
}

export interface Document {
  id: string;
  name: string;
  type: string;
  url: string;
  uploadDate: string;
}

export interface Campaign {
  id: string;
  name: string;
  status: string;
  budget: number;
  startDate: string;
  endDate: string;
}

export interface User {
  id: string;
  name: string;
  email: string;
  role: string;
  createdAt: string;
}