import React from 'react';
import { FaHeartbeat, FaMicrochip, FaMemory, FaHdd, FaDatabase } from 'react-icons/fa';

const SimpleSystemHealth: React.FC = () => {
  return (
    <div style={{ padding: '20px', backgroundColor: 'white', borderRadius: '8px', boxShadow: '0 2px 4px rgba(0,0,0,0.1)' }}>
      <div style={{ display: 'flex', alignItems: 'center', marginBottom: '20px' }}>
        <FaHeartbeat style={{ color: '#27ae60', marginRight: '10px', fontSize: '24px' }} />
        <h2 style={{ margin: 0, color: '#333' }}>System Health Monitoring</h2>
      </div>
      
      <div style={{ display: 'grid', gridTemplateColumns: 'repeat(auto-fit, minmax(200px, 1fr))', gap: '16px', marginBottom: '20px' }}>
        <div style={{ padding: '16px', backgroundColor: '#f8f9fa', borderRadius: '8px', textAlign: 'center' }}>
          <FaMicrochip style={{ fontSize: '32px', color: '#3498db', marginBottom: '8px' }} />
          <div style={{ fontSize: '24px', fontWeight: 'bold', color: '#333' }}>--</div>
          <div style={{ fontSize: '14px', color: '#666' }}>CPU Usage</div>
        </div>
        
        <div style={{ padding: '16px', backgroundColor: '#f8f9fa', borderRadius: '8px', textAlign: 'center' }}>
          <FaMemory style={{ fontSize: '32px', color: '#e74c3c', marginBottom: '8px' }} />
          <div style={{ fontSize: '24px', fontWeight: 'bold', color: '#333' }}>--</div>
          <div style={{ fontSize: '14px', color: '#666' }}>Memory Usage</div>
        </div>
        
        <div style={{ padding: '16px', backgroundColor: '#f8f9fa', borderRadius: '8px', textAlign: 'center' }}>
          <FaHdd style={{ fontSize: '32px', color: '#f39c12', marginBottom: '8px' }} />
          <div style={{ fontSize: '24px', fontWeight: 'bold', color: '#333' }}>--</div>
          <div style={{ fontSize: '14px', color: '#666' }}>Disk Usage</div>
        </div>
        
        <div style={{ padding: '16px', backgroundColor: '#f8f9fa', borderRadius: '8px', textAlign: 'center' }}>
          <FaDatabase style={{ fontSize: '32px', color: '#27ae60', marginBottom: '8px' }} />
          <div style={{ fontSize: '24px', fontWeight: 'bold', color: '#333' }}>--</div>
          <div style={{ fontSize: '14px', color: '#666' }}>Services</div>
        </div>
      </div>
      
      <div style={{ padding: '16px', backgroundColor: '#fff3cd', borderRadius: '8px', border: '1px solid #ffeaa7' }}>
        <div style={{ fontSize: '14px', color: '#856404' }}>
          <strong>Status:</strong> Connecting to monitoring service...
        </div>
        <div style={{ fontSize: '12px', color: '#856404', marginTop: '4px' }}>
          Please ensure your backend server is running on port 8090
        </div>
      </div>
    </div>
  );
};

export default SimpleSystemHealth;