import React, { useState, useEffect } from 'react';
import { FaHeartbeat, FaMicrochip, FaMemory, FaHdd, FaDatabase, FaCheckCircle, FaExclamationTriangle } from 'react-icons/fa';

const StandaloneSystemHealth: React.FC = () => {
  const [currentTime, setCurrentTime] = useState(new Date());
  const [mockMetrics, setMockMetrics] = useState({
    cpu: Math.floor(Math.random() * 30) + 20,
    memory: Math.floor(Math.random() * 40) + 30,
    disk: Math.floor(Math.random() * 20) + 15,
    services: 100
  });

  useEffect(() => {
    const timer = setInterval(() => {
      setCurrentTime(new Date());
      setMockMetrics({
        cpu: Math.floor(Math.random() * 30) + 20,
        memory: Math.floor(Math.random() * 40) + 30,
        disk: Math.floor(Math.random() * 20) + 15,
        services: 100
      });
    }, 5000);

    return () => clearInterval(timer);
  }, []);

  const getStatusColor = (value: number, type: string) => {
    if (type === 'services') return '#27ae60';
    if (value < 50) return '#27ae60';
    if (value < 80) return '#f39c12';
    return '#e74c3c';
  };

  const getStatusIcon = (value: number, type: string) => {
    if (type === 'services' || value < 80) {
      return <FaCheckCircle style={{ color: '#27ae60', fontSize: '16px' }} />;
    }
    return <FaExclamationTriangle style={{ color: '#f39c12', fontSize: '16px' }} />;
  };

  return (
    <div style={{ 
      padding: '24px', 
      backgroundColor: 'white', 
      borderRadius: '12px', 
      boxShadow: '0 4px 6px rgba(0,0,0,0.1)',
      maxWidth: '1200px',
      margin: '0 auto'
    }}>
      {/* Header */}
      <div style={{ 
        display: 'flex', 
        alignItems: 'center', 
        justifyContent: 'space-between',
        marginBottom: '32px',
        paddingBottom: '16px',
        borderBottom: '2px solid #f1f3f4'
      }}>
        <div style={{ display: 'flex', alignItems: 'center' }}>
          <FaHeartbeat style={{ 
            color: '#27ae60', 
            marginRight: '12px', 
            fontSize: '32px',
            animation: 'pulse 2s infinite'
          }} />
          <div>
            <h1 style={{ margin: 0, color: '#2c3e50', fontSize: '28px', fontWeight: 'bold' }}>
              System Health Monitor
            </h1>
            <p style={{ margin: '4px 0 0 0', color: '#7f8c8d', fontSize: '16px' }}>
              Real-time system performance dashboard
            </p>
          </div>
        </div>
        <div style={{ 
          backgroundColor: '#27ae60', 
          color: 'white', 
          padding: '12px 20px', 
          borderRadius: '25px',
          fontSize: '16px',
          fontWeight: 'bold'
        }}>
          ✓ HEALTHY
        </div>
      </div>

      {/* Metrics Grid */}
      <div style={{ 
        display: 'grid', 
        gridTemplateColumns: 'repeat(auto-fit, minmax(280px, 1fr))', 
        gap: '24px', 
        marginBottom: '32px' 
      }}>
        {/* CPU Usage */}
        <div style={{ 
          padding: '24px', 
          backgroundColor: '#f8f9fa', 
          borderRadius: '12px', 
          border: '2px solid #e9ecef',
          transition: 'transform 0.2s ease'
        }}>
          <div style={{ display: 'flex', alignItems: 'center', justifyContent: 'space-between', marginBottom: '16px' }}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <FaMicrochip style={{ fontSize: '24px', color: '#3498db', marginRight: '12px' }} />
              <span style={{ fontSize: '18px', fontWeight: '600', color: '#2c3e50' }}>CPU Usage</span>
            </div>
            {getStatusIcon(mockMetrics.cpu, 'cpu')}
          </div>
          <div style={{ fontSize: '36px', fontWeight: 'bold', color: getStatusColor(mockMetrics.cpu, 'cpu') }}>
            {mockMetrics.cpu}%
          </div>
          <div style={{ fontSize: '14px', color: '#7f8c8d', marginTop: '8px' }}>
            Processor utilization
          </div>
        </div>

        {/* Memory Usage */}
        <div style={{ 
          padding: '24px', 
          backgroundColor: '#f8f9fa', 
          borderRadius: '12px', 
          border: '2px solid #e9ecef',
          transition: 'transform 0.2s ease'
        }}>
          <div style={{ display: 'flex', alignItems: 'center', justifyContent: 'space-between', marginBottom: '16px' }}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <FaMemory style={{ fontSize: '24px', color: '#e74c3c', marginRight: '12px' }} />
              <span style={{ fontSize: '18px', fontWeight: '600', color: '#2c3e50' }}>Memory Usage</span>
            </div>
            {getStatusIcon(mockMetrics.memory, 'memory')}
          </div>
          <div style={{ fontSize: '36px', fontWeight: 'bold', color: getStatusColor(mockMetrics.memory, 'memory') }}>
            {mockMetrics.memory}%
          </div>
          <div style={{ fontSize: '14px', color: '#7f8c8d', marginTop: '8px' }}>
            RAM consumption
          </div>
        </div>

        {/* Disk Usage */}
        <div style={{ 
          padding: '24px', 
          backgroundColor: '#f8f9fa', 
          borderRadius: '12px', 
          border: '2px solid #e9ecef',
          transition: 'transform 0.2s ease'
        }}>
          <div style={{ display: 'flex', alignItems: 'center', justifyContent: 'space-between', marginBottom: '16px' }}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <FaHdd style={{ fontSize: '24px', color: '#f39c12', marginRight: '12px' }} />
              <span style={{ fontSize: '18px', fontWeight: '600', color: '#2c3e50' }}>Disk Usage</span>
            </div>
            {getStatusIcon(mockMetrics.disk, 'disk')}
          </div>
          <div style={{ fontSize: '36px', fontWeight: 'bold', color: getStatusColor(mockMetrics.disk, 'disk') }}>
            {mockMetrics.disk}%
          </div>
          <div style={{ fontSize: '14px', color: '#7f8c8d', marginTop: '8px' }}>
            Storage utilization
          </div>
        </div>

        {/* Services Health */}
        <div style={{ 
          padding: '24px', 
          backgroundColor: '#f8f9fa', 
          borderRadius: '12px', 
          border: '2px solid #e9ecef',
          transition: 'transform 0.2s ease'
        }}>
          <div style={{ display: 'flex', alignItems: 'center', justifyContent: 'space-between', marginBottom: '16px' }}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <FaDatabase style={{ fontSize: '24px', color: '#27ae60', marginRight: '12px' }} />
              <span style={{ fontSize: '18px', fontWeight: '600', color: '#2c3e50' }}>Services</span>
            </div>
            {getStatusIcon(mockMetrics.services, 'services')}
          </div>
          <div style={{ fontSize: '36px', fontWeight: 'bold', color: getStatusColor(mockMetrics.services, 'services') }}>
            {mockMetrics.services}%
          </div>
          <div style={{ fontSize: '14px', color: '#7f8c8d', marginTop: '8px' }}>
            Services healthy
          </div>
        </div>
      </div>

      {/* Status Information */}
      <div style={{ 
        display: 'grid', 
        gridTemplateColumns: 'repeat(auto-fit, minmax(300px, 1fr))', 
        gap: '20px' 
      }}>
        <div style={{ 
          padding: '20px', 
          backgroundColor: '#d4edda', 
          borderRadius: '8px', 
          border: '1px solid #c3e6cb' 
        }}>
          <div style={{ fontSize: '16px', color: '#155724', fontWeight: '600', marginBottom: '8px' }}>
            ✅ System Status: Operational
          </div>
          <div style={{ fontSize: '14px', color: '#155724' }}>
            All systems are running normally. No issues detected.
          </div>
        </div>

        <div style={{ 
          padding: '20px', 
          backgroundColor: '#f8f9fa', 
          borderRadius: '8px', 
          border: '1px solid #dee2e6' 
        }}>
          <div style={{ fontSize: '16px', color: '#495057', fontWeight: '600', marginBottom: '8px' }}>
            📊 Last Updated
          </div>
          <div style={{ fontSize: '14px', color: '#6c757d' }}>
            {currentTime.toLocaleString()}
          </div>
        </div>
      </div>

      <style>{`
        @keyframes pulse {
          0% { transform: scale(1); }
          50% { transform: scale(1.1); }
          100% { transform: scale(1); }
        }
      `}</style>
    </div>
  );
};

export default StandaloneSystemHealth;