export interface DataRetentionPolicy {
  id: number;
  data_type: string;
  retention_period_days: number;
  description: string;
  is_active: boolean;
  created_at: string;
  updated_at: string;
}

export interface ErasureRequest {
  id: number;
  user_id: string;
  request_type: 'partial' | 'complete';
  status: 'pending' | 'approved' | 'rejected' | 'completed';
  reason: string;
  data_categories: string[];
  requested_at: string;
  processed_at?: string;
  processed_by?: string;
  completion_date?: string;
  notes?: string;
}

export interface DataExport {
  id: number;
  user_id: string;
  export_type: 'personal_data' | 'activity_logs' | 'property_data' | 'complete';
  status: 'pending' | 'processing' | 'completed' | 'failed';
  file_path?: string;
  file_size?: number;
  requested_at: string;
  completed_at?: string;
  download_expires_at?: string;
}

export interface DataCategory {
  category: string;
  description: string;
  data_count: number;
  last_updated: string;
  retention_days: number;
}

export interface RetentionStats {
  total_policies: number;
  active_policies: number;
  pending_erasure_requests: number;
  completed_erasures: number;
  data_exports_this_month: number;
  storage_saved_gb: number;
}

export interface UserDataSummary {
  user_id: string;
  username?: string;
  email?: string;
  phone_number?: string;
  data_categories: DataCategory[];
  total_data_size_mb: number;
  account_created: string;
  last_activity?: string;
  retention_eligible: boolean;
}

export interface ApiResponse<T> {
  status?: 'success' | 'error';
  data?: T;
  message?: string;
  detail?: string;
}

export interface PaginatedResponse<T> {
  data: T[];
  total_count: number;
  page: number;
  page_size: number;
  has_next: boolean;
  has_previous: boolean;
}