export type FeatureCategory = 'listing' | 'lead' | 'report' | 'addon' | 'analytics' | 'agent';

export type EntitlementSource = 'subscription' | 'credits' | 'admin_grant' | 'free';

export interface Feature {
  id?: number;
  code: string;
  name: string;
  category: FeatureCategory;
  description?: string;
  requires_subscription: boolean;
  requires_credits: boolean;
  credit_cost: number;
  metadata: Record<string, any>;
  is_active: boolean;
  created_at?: string;
}

export interface EntitlementCheckRequest {
  user_id: number;
  user_type: string;
  feature_code: string;
  context?: Record<string, any>;
}

export interface EntitlementCheckResponse {
  is_granted: boolean;
  feature_code: string;
  denial_reason?: string;
  entitlement_source?: EntitlementSource;
  credit_cost: number;
  current_balance?: number;
  usage_count: number;
  usage_limit?: number;
  metadata: Record<string, any>;
}

export interface FeatureUsageRequest {
  user_id: number;
  user_type: string;
  feature_code: string;
  reference_type?: string;
  reference_id?: number;
  context?: Record<string, any>;
}

export interface FeatureUsageResponse {
  success: boolean;
  message: string;
  credits_spent: number;
  new_balance?: number;
  usage_count: number;
}

export interface PackageEntitlement {
  id?: number;
  package_id: number;
  feature_code: string;
  feature_name?: string;
  package_name?: string;
  category?: string;
  limits: Record<string, any>;
  is_enabled: boolean;
  created_at?: string;
}

export interface UserEntitlement {
  code: string;
  name: string;
  category: FeatureCategory;
  source: EntitlementSource;
  limits?: Record<string, any>;
  credit_cost?: number;
  current_balance?: number;
}

export interface EntitlementAnalytics {
  feature_code: string;
  total_checks: number;
  granted_count: number;
  denied_count: number;
}
