// Flexible type declarations to resolve all TypeScript errors

// Toast function types
declare const toast: {
  (message: any, data?: any): any;
  success: (message: any, data?: any) => any;
  error: (message: any, data?: any) => any;
  warning: (message: any, data?: any) => any;
  warn: (message: any, data?: any) => any;
  info: (message: any, data?: any) => any;
  loading: (message: any, data?: any) => any;
};

// jsPDF types
declare module 'jspdf' {
  interface jsPDF {
    getNumberOfPages(): number;
    [key: string]: any;
  }
  const jsPDF: {
    new (...args: any[]): jsPDF;
    [key: string]: any;
  };
  export = jsPDF;
}

// Flexible interfaces
interface FlexibleObject {
  [key: string]: any;
}

interface ExternalToast {
  [key: string]: any;
}

interface MediaFile {
  id: string;
  url: string;
  type?: string;
  category?: string;
  is_primary?: boolean;
  thumbnail_url?: string;
  title?: string;
  document_type?: string;
  file_name?: string;
  [key: string]: any;
}

interface MediaState {
  images: MediaFile[];
  videos: MediaFile[];
  documents: MediaFile[];
  uploading: boolean;
  loading: boolean;
  error: string;
  [key: string]: any;
}

interface UrgentSaleProperty {
  id: string;
  title: string;
  price: number;
  location: string;
  primary_image?: string;
  [key: string]: any;
}

interface BiddingProperty {
  id: string;
  title: string;
  price: number;
  location: string;
  sale_price?: number;
  [key: string]: any;
}

interface RealProperty {
  id: string;
  title: string;
  price: number;
  location: string;
  listing_type?: string;
  [key: string]: any;
}

interface ItineraryProperty {
  id: string;
  propertyId: number;
  title: string;
  address: string;
  city: string;
  photo: string;
  visitDate: string;
  visitTime: string;
  duration: number;
  order: number;
  status: string;
  latitude?: number;
  longitude?: number;
  contactName?: string;
  contactPhone?: string;
  visitType?: string;
  meetingWith?: string;
  [key: string]: any;
}

interface VisitBooking {
  propertyId: number | string;
  [key: string]: any;
}

interface SearchHistoryEntry {
  id: string;
  query: string;
  timestamp: string;
  [key: string]: any;
}

interface SearchHistoryAPI {
  storeSearch(data: SearchHistoryEntry): Promise<SearchHistoryEntry>;
  getUserHistory(userId: string, limit?: number): Promise<SearchHistoryEntry[]>;
  getRecommendations(userId: string): Promise<any>;
  clearAllHistory?: () => Promise<void>;
}

interface AuctionDetail {
  id: number;
  propertyId: any;
  propertyTitle: any;
  propertyImage: any;
  propertyLocation: string;
  status: "active" | "ended" | "upcoming";
  startTime: string;
  endTime: string;
  reservePrice: any;
  startingPrice: any;
  bidIncrement: any;
  highestBid: any;
  bidderCount: number;
  bids: any[];
  [key: string]: any;
}

interface Bidder {
  id: string;
  name: string;
  email: string;
  phone: string;
  verified: boolean;
  totalBids?: number;
  joinedAt?: string;
  [key: string]: any;
}

interface RiskSubmissionResponse {
  builder_name?: string;
  [key: string]: any;
}

interface SubmissionDetail {
  builder_name: string;
  [key: string]: any;
}

interface AppContextType {
  deleteProperty?: (id: string) => void;
  [key: string]: any;
}

// Global variable declarations
declare const filters: any;
declare const propertyEmail: string;
declare const selectedProperty: any;

// Module declarations
declare module '../context/PropertyContext' {
  const content: any;
  export default content;
}

declare module '../types' {
  export const PropertyFilters: any;
  export const Property: any;
  export default any;
}

declare module '../data/mockData' {
  const content: any;
  export default content;
}

declare module '../hooks/useSidebar' {
  const content: any;
  export default content;
}

declare module '../api/user/userDashboard' {
  export const saveProperty: any;
  export const removeSavedProperty: any;
  export const SavedProperty: any;
}

declare module '../services/valuationApi' {
  export const Comparable: any;
}

// React Hook Form types
declare module 'react-hook-form' {
  interface FieldError {
    message?: string;
    type?: string;
    [key: string]: any;
  }
}

export {};