// Google Earth Engine Types for Flood Risk Analysis

export interface FloodRiskData {
  score: number; // 0-10 scale
  level: 'low' | 'medium' | 'high';
  elevation: number; // meters above sea level
  waterDistance: number; // meters to nearest water body
  historicalFloods: number; // count of past flood events
  waterOccurrence: number; // percentage (0-100)
  lastUpdated: string; // ISO date string
}

export interface UrbanGrowthData {
  growthScore: number; // 0-10 scale
  growthRate: number; // percentage annual growth
  developmentLevel: 'emerging' | 'developing' | 'mature' | 'saturated';
  urbanAreaChange: number; // percentage change
  infrastructureScore: number; // 0-10 scale
  investmentPotential: number; // 0-10 scale
  timelineData: {
    year: number;
    urbanArea: number; // sq km
    builtUpDensity: number; // percentage
  }[];
  lastUpdated: string;
}

export interface GEEFloodResponse {
  success: boolean;
  data?: {
    elevation: number;
    waterOccurrence: number;
    waterDistance: number;
    floodHistory: number;
  };
  error?: string;
  cached?: boolean;
}

export interface FloodRiskCalculation {
  elevationScore: number;
  proximityScore: number;
  historyScore: number;
  occurrenceScore: number;
  finalScore: number;
}

export interface CachedFloodData {
  [key: string]: {
    data: FloodRiskData;
    timestamp: number;
  };
}

// Infrastructure & Accessibility Data

export interface InfrastructureData {
  accessibilityScore: number; // 0-10 scale
  connectivityLevel: 'excellent' | 'good' | 'average' | 'poor';
  
  // Transportation
  nearestHighway: {
    name: string;
    distance: number; // km
  };
  nearestMetro: {
    name: string;
    distance: number; // km
  } | null;
  nearestAirport: {
    name: string;
    distance: number; // km
  };
  
  // Key Amenities
  nearestITPark: {
    name: string;
    distance: number; // km
  } | null;
  nearestHospital: {
    name: string;
    distance: number; // km
  };
  nearestSchool: {
    name: string;
    distance: number; // km
  };
  
  // Scores
  transportScore: number; // 0-10
  amenitiesScore: number; // 0-10
  employmentScore: number; // 0-10
  
  lastUpdated: string;
}
