// Global type declarations
declare global {
  namespace google {
    namespace maps {
      class Map {
        constructor(...args: any[]);
        addListener(event: string, handler: (e: any) => void): void;
        setCenter(latLng: any): void;
        getZoom(): number;
        getBounds(): any;
      }
      class Marker {
        constructor(options: any);
        setMap(map: Map | null): void;
      }
      class Geocoder {
        constructor(...args: any[]);
        geocode(request: any, callback: (results: any[], status: any) => void): void;
      }
      class Circle {
        constructor(...args: any[]);
        addListener(event: string, handler: () => void): void;
        setMap(map: Map | null): void;
      }
      interface MapMouseEvent {
        latLng: any;
      }
      namespace places {
        class Autocomplete {
          constructor(input: HTMLInputElement, options?: any);
          addListener(event: string, handler: () => void): void;
          getPlace(): any;
        }
      }
      namespace event {
        function addListener(instance: any, eventName: string, handler: Function): any;
      }
    }
  }

  interface Window {
    google: typeof google;
  }
}

// Property types with flexible structure
declare module "*.jpg" {
  const content: string;
  export default content;
}

declare module "*.png" {
  const content: string;
  export default content;
}

// Flexible property interface
interface Property {
  id: string;
  title: string;
  description?: string;
  price?: number;
  location?: string;
  city?: string;
  state?: string;
  pincode?: string;
  address?: string;
  latitude?: string | number;
  longitude?: string | number;
  built_up_area?: number;
  carpet_area?: number;
  super_area?: number;
  bedrooms?: number;
  bathrooms?: number;
  property_type?: string;
  listing_type?: string;
  amenities?: string[];
  customAmenities?: string[];
  images?: any[];
  videos?: any[];
  documents?: any[];
  listed_by_id?: string | number;
  user_id?: string | number;
  sale_price?: number;
  primary_image?: string;
  [key: string]: any; // Allow any additional properties
}

// Flexible interfaces for common types
interface User {
  id: string | number;
  username?: string;
  email?: string;
  first_name?: string;
  last_name?: string;
  firstName?: string;
  lastName?: string;
  mobile?: string;
  company_name?: string;
  user_role?: string;
  [key: string]: any;
}

interface Booking {
  id: string | number;
  property_id?: string | number;
  user_id?: string | number;
  date?: string;
  time?: string;
  status?: string;
  type?: string;
  buyerId?: string | number;
  scheduledDate?: string;
  notes?: string;
  [key: string]: any;
}

interface Lead {
  id: string | number;
  property_id?: string | number;
  user_id?: string | number;
  name?: string;
  email?: string;
  phone?: string;
  message?: string;
  status?: string;
  buyerId?: string | number;
  interestLevel?: string;
  [key: string]: any;
}

interface Campaign {
  id: string | number;
  name?: string;
  status?: string;
  budget?: number;
  spent?: number;
  clicks?: number;
  views?: number;
  leads?: number;
  propertyId?: string | number;
  type?: string;
  [key: string]: any;
}

interface Document {
  id: string | number;
  name?: string;
  type?: string;
  url?: string;
  upload_date?: string;
  sellerId?: string | number;
  [key: string]: any;
}

interface PropertyDocument {
  id: string | number;
  property_id?: string | number;
  doc_type?: string;
  file_url?: string;
  user_id?: string | number;
  file_name?: string;
  document_type?: string;
  file_size?: number;
  upload_date?: string;
  download_url?: string;
  createElement?: any;
  body?: any;
  [key: string]: any;
}

export {};