// Grievance Management Types

export type UserType = 'buyer' | 'seller' | 'agent' | 'landlord' | 'tenant' | 'admin';

export type GrievanceType = 
  | 'property_dispute'
  | 'contract_breach'
  | 'misrepresentation'
  | 'payment_dispute'
  | 'agent_misconduct'
  | 'maintenance_issue'
  | 'neighbor_dispute'
  | 'legal_issue'
  | 'other';

export type Priority = 'low' | 'medium' | 'high' | 'critical';

export type Status = 
  | 'submitted'
  | 'registered'
  | 'under_investigation'
  | 'pending_resolution'
  | 'resolved'
  | 'closed'
  | 'escalated';

export interface Grievance {
  id: number;
  case_id: string;
  complainant_id: number;
  complainant_type: UserType;
  respondent_id?: number;
  respondent_type?: UserType;
  property_id?: number;
  grievance_type: GrievanceType;
  priority: Priority;
  status: Status;
  title: string;
  description: string;
  incident_date?: string;
  assigned_investigator?: number;
  investigation_notes?: string;
  resolution_summary?: string;
  created_at: string;
  registered_at?: string;
  investigation_started_at?: string;
  resolved_at?: string;
  closed_at?: string;
}

export interface GrievanceEvidence {
  id: number;
  case_id: number;
  file_path: string;
  file_name: string;
  file_type: string;
  uploaded_by: number;
  uploaded_at: string;
}

export interface GrievanceTimeline {
  id: number;
  case_id: number;
  action: string;
  description: string;
  performed_by: number;
  performed_by_type: UserType;
  timestamp: string;
}

export interface GrievanceNotification {
  id: number;
  case_id: number;
  recipient_id: number;
  recipient_type: UserType;
  message: string;
  is_read: boolean;
  created_at: string;
}

export interface GrievanceDetail extends Grievance {
  evidence: GrievanceEvidence[];
  timeline: GrievanceTimeline[];
}

export interface GrievanceSubmitData {
  complainant_id: number;
  complainant_type: UserType;
  grievance_type: GrievanceType;
  title: string;
  description: string;
  incident_date?: string;
  respondent_id?: number;
  respondent_type?: UserType;
  property_id?: number;
}

export interface StatusUpdateData {
  case_id: string;
  status: Status;
  admin_id: number;
  notes?: string;
}

export interface AssignInvestigatorData {
  case_id: string;
  investigator_id: number;
  admin_id: number;
}

export interface InvestigationUpdateData {
  case_id: string;
  investigator_id: number;
  notes: string;
}

export interface ResolveGrievanceData {
  case_id: string;
  investigator_id: number;
  resolution_summary: string;
}

export const GRIEVANCE_TYPE_LABELS: Record<GrievanceType, string> = {
  property_dispute: 'Property Dispute',
  contract_breach: 'Contract Breach',
  misrepresentation: 'Property Misrepresentation',
  payment_dispute: 'Payment Dispute',
  agent_misconduct: 'Agent Misconduct',
  maintenance_issue: 'Maintenance Issue',
  neighbor_dispute: 'Neighbor Dispute',
  legal_issue: 'Legal Issue',
  other: 'Other'
};

export const STATUS_LABELS: Record<Status, string> = {
  submitted: 'Submitted',
  registered: 'Registered',
  under_investigation: 'Under Investigation',
  pending_resolution: 'Pending Resolution',
  resolved: 'Resolved',
  closed: 'Closed',
  escalated: 'Escalated'
};

export const PRIORITY_LABELS: Record<Priority, string> = {
  low: 'Low',
  medium: 'Medium',
  high: 'High',
  critical: 'Critical'
};
