export interface ItineraryProperty {
  id: string;
  propertyId: number;
  title: string;
  address: string;
  city: string;
  photo: string;
  visitDate: string;
  visitTime: string;
  duration: number;
  order: number;
  notes?: string;
  status: 'pending' | 'confirmed' | 'completed' | 'cancelled';
  latitude?: number;
  longitude?: number;
  
  // Enhanced fields
  contactName: string;
  contactPhone: string;
  contactEmail?: string;
  alternateContact?: string;
  visitType: 'physical' | 'virtual' | 'hybrid';
  meetingWith: 'agent' | 'owner' | 'both' | 'manager';
  groupSize: string;
  transportMode: 'own' | 'public' | 'cab' | 'pickup';
  parkingRequired: boolean;
  areasToVisit: string[];
  purposeOfVisit: 'buying' | 'renting' | 'investment' | 'research' | 'comparison';
  budgetRange?: string;
  financingRequired: boolean;
  immediateDecision: boolean;
  documentsToReview: string[];
  photographyAllowed: boolean;
  videoCallBackup: boolean;
  accessibilityNeeds?: string;
  emergencyContact?: string;
  specialRequests?: string;
  covidPrecautions: boolean;
}

export interface TravelSegment {
  from: ItineraryProperty;
  to: ItineraryProperty;
  distance: number;
  duration: number;
  mode: 'driving' | 'walking' | 'transit';
}

export interface Itinerary {
  id: string;
  userId: string;
  title: string;
  date: string;
  properties: ItineraryProperty[];
  travelSegments: TravelSegment[];
  totalDuration: number;
  totalDistance: number;
  status: 'draft' | 'scheduled' | 'in-progress' | 'completed';
  createdAt: string;
  updatedAt: string;
}

export interface LiveTourProgress {
  itineraryId: string;
  currentPropertyIndex: number;
  checkIns: CheckInRecord[];
  startTime: string;
  completedProperties: string[];
}

export interface CheckInRecord {
  propertyId: string;
  timestamp: string;
  method: 'qr' | 'gps' | 'manual';
  location?: { lat: number; lng: number };
  photos?: string[];
  notes?: string;
  actualDuration?: number;
  visitRating?: number;
  feedback?: string;
}

export interface VisitBooking {
  id: string;
  propertyId: number;
  propertyTitle: string;
  contactName: string;
  contactPhone: string;
  contactEmail?: string;
  alternateContact?: string;
  visitDate: string;
  arrivalTime: string;
  duration: string;
  visitType: 'physical' | 'virtual' | 'hybrid';
  meetingWith: 'agent' | 'owner' | 'both' | 'manager';
  groupSize: string;
  transportMode: 'own' | 'public' | 'cab' | 'pickup';
  parkingRequired: boolean;
  areasToVisit: string[];
  purposeOfVisit: 'buying' | 'renting' | 'investment' | 'research' | 'comparison';
  budgetRange?: string;
  financingRequired: boolean;
  immediateDecision: boolean;
  documentsToReview: string[];
  photographyAllowed: boolean;
  videoCallBackup: boolean;
  accessibilityNeeds?: string;
  emergencyContact?: string;
  specialRequests?: string;
  covidPrecautions: boolean;
  status: 'scheduled' | 'confirmed' | 'in-progress' | 'completed' | 'cancelled';
  bookedAt: string;
  confirmedAt?: string;
  completedAt?: string;
}
