export interface ListingFormData {
  // Personal Details
  ownerName: string;
  companyName?: string;
  mobile: string;
  email: string;
  
  // Property Title
  title: string;
  description?: string;
  category?: string;
  price?: number;
  specifications?: string[];
  
  // Listing Type
  listingType: 'sell' | 'rent' | 'urgent-sale' | 'bidding' | 'lease';
  
  // Property Type
  propertyType: 'apartment' | 'villa' | 'house' | 'commercial' | 'pg-coliving';
  
  // Property Details (Conditional)
  builtUpArea?: number;
  carpetArea?: number;
  plotArea?: number;
  superArea?: number;
  bedrooms?: number;
  bathrooms?: number;
  balconies?: number;
  floorNumber?: string;
  totalFloors?: string;
  facing: string;
  furnishing: string;
  propertyAge: string;
  parking?: string;
  garden?: boolean;
  gatedCommunity: 'yes' | 'no';
  leaseTerms?: string;
  commonFacilities?: string[];
  
  // Pricing (Conditional by Listing Type)
  salePrice?: number;
  pricePerSqFt?: number;
  monthlyRent?: number;
  securityDeposit?: number;
  priceNegotiable: boolean;
  loanAvailability: boolean;
  possessionStatus: string;
  
  // Bidding specific
  startingBidPrice?: number;
  minimumIncrement?: number;
  reservePrice?: number;
  auctionStartDate?: string;
  auctionStartTime?: string;
  auctionEndDate?: string;
  auctionEndTime?: string;
  urgentSaleStartDate?: string;
  urgentSaleStartTime?: string;
  urgentSaleEndDate?: string;
  urgentSaleEndTime?: string;
  actualPrice?: number;
  depositRequirement?: number;
  bidderRegistrationFee?: number;
  auctionEligibility?: string;

  // Lease specific
  leaseType?: string;
  leaseDuration?: string;
  monthlyLeaseAmount?: number;
  advanceDeposit?: number;
  maintenanceCharges?: number;
  renewalTerms?: string;
  lockInPeriod?: string;
  leaseStartDate?: string;
  leaseEndDate?: string;
  possessionAvailability?: string;
  leaseAgreement?: File | null;
  autoRenew?: boolean;
  paymentFrequency?: string;
  maintenanceResponsibility?: string;

  // Timezone
  timezone?: string;

  // Location
  city: string;
  locality: string;
  address: string;
  landmark?: string;
  pincode?: string;
  state?: string;
  latitude?: number;
  longitude?: number;
  coordinates?: { lat: number; lng: number };
  nearbyPlaces?: string[];
  
  // Amenities & Features
  amenities: string[];
  customAmenities?: string[];
  features: string[];
  
  // Property Highlights
  highlights: string[];
  
  // Media
  selectedMedia?: any[];
  primaryImage?: any;
  images: File[];
  videos: File[];
  virtualTours?: string[];
  virtualTourUrl?: string;
  imageUrls?: string[];
  imageCategories: { [key: string]: File[] };
  threeSixtyView?: string;
  housePlan?: string;

  // Documents
  documents: File[];
  requiredDocs: { file: File; type: string }[];

  // PG/Co-living specific
  accommodationType?: string;
  totalBedsAvailable?: number;
  perBedRent?: number;
  foodAvailability?: string;
  genderPreference?: string;
  pgSecurityDeposit?: number;
  pgMaintenanceCharges?: number;
  securityType?: string;
  availabilityDate?: string;
  minimumStayDuration?: number;
  bookingAmount?: number;
  propertyManagerContact?: string;
  roomFurnishingDetails?: string;
  houseRules?: string;
  guestPolicy?: string;
  attachedBathroom?: boolean;
  pgCommonFacilities?: string[];

  // Legal Compliance
  reraNumber?: string;
  reraState?: string;
  reraVerified?: boolean;
  legalDocuments?: { file: File; type: 'ownership' | 'noc' | 'approval' | 'other' }[];
  privacyConsent?: boolean;
  dataProcessingConsent?: boolean;
  termsAccepted?: boolean;
  nalTermsAccepted?: boolean;
  acceptGovtGuidelines?: boolean;
  acceptTerms?: boolean;
  enableAlerts?: boolean;

  // Contact & Verification
  contactType: 'owner' | 'agent';
  kycVerified: boolean;
  phoneVerified: boolean;
  emailVerified: boolean;
}

export interface FormStep {
  id: string;
  title: string;
  component: React.ComponentType<FormStepProps>;
}

export interface FormStepProps {
  onNext: () => void;
  onPrev: () => void;
  isFirst: boolean;
  isLast: boolean;
}

// Import MediaGalleryItem from mediaApi
export interface ListingFormData {
  // Personal Details
  ownerName: string;
  companyName?: string;
  mobile: string;
  email: string;
  
  // Property Title
  title: string;
  description?: string;
  category?: string;
  price?: number;
  specifications?: string[];
  
  // Listing Type
  listingType: 'sell' | 'rent' | 'urgent-sale' | 'bidding' | 'lease';
  
  // Property Type
  propertyType: 'apartment' | 'villa' | 'house' | 'commercial' | 'pg-coliving';
  
  // Property Details (Conditional)
  builtUpArea?: number;
  carpetArea?: number;
  plotArea?: number;
  superArea?: number;
  bedrooms?: number;
  bathrooms?: number;
  balconies?: number;
  floorNumber?: string;
  totalFloors?: string;
  facing: string;
  furnishing: string;
  propertyAge: string;
  parking?: string;
  garden?: boolean;
  leaseTerms?: string;
  commonFacilities?: string[];
  
  // Pricing (Conditional by Listing Type)
  salePrice?: number;
  pricePerSqFt?: number;
  monthlyRent?: number;
  securityDeposit?: number;
  priceNegotiable: boolean;
  loanAvailability: boolean;
  possessionStatus: string;
  
  // Bidding specific
  startingBiddingPrice?: number;
  minimumIncrement?: number;
  reservePrice?: number;
  auctionStartDate?: string;
  auctionStartTime?: string;
  auctionEndDate?: string;
  auctionEndTime?: string;
  urgentSaleStartDate?: string;
  urgentSaleStartTime?: string;
  urgentSaleEndDate?: string;
  urgentSaleEndTime?: string;
  actualPrice?: number;
  depositRequirement?: number;
  bidderRegistrationFee?: number;
  auctionEligibility?: string;
  
  // Location
  city: string;
  locality: string;
  address: string;
  landmark?: string;
  pincode?: string;
  state?: string;
  latitude?: number;
  longitude?: number;
  coordinates?: { lat: number; lng: number };
  nearbyPlaces?: string[];
  
  // Amenities & Features
  amenities: string[];
  customAmenities?: string[];
  features: string[];
  
  // Property Highlights
  highlights: string[];
  
  // Media
  selectedMedia?: any[];
  primaryImage?: any;
  images: File[];
  videos: File[];
  virtualTours?: string[];
  virtualTourUrl?: string;
  imageUrls?: string[];
  imageCategories: { [key: string]: File[] };
  
  // Documents
  documents: File[];
  requiredDocs: { file: File; type: string }[];
  
  // Legal Compliance
  reraNumber?: string;
  reraState?: string;
  reraVerified?: boolean;
  legalDocuments?: { file: File; type: 'ownership' | 'noc' | 'approval' | 'other' }[];
  privacyConsent?: boolean;
  dataProcessingConsent?: boolean;
  termsAccepted?: boolean;
  nalTermsAccepted?: boolean;
  
  // Contact & Verification
  contactType: 'owner' | 'agent';
  kycVerified: boolean;
  phoneVerified: boolean;
  emailVerified: boolean;
}

export interface FormStep {
  id: string;
  title: string;
  component: React.ComponentType<FormStepProps>;
}

export interface FormStepProps {
  onNext: () => void;
  onPrev: () => void;
  isFirst: boolean;
  isLast: boolean;
}

// Import MediaGalleryItem from mediaApi
import { MediaGalleryItem } from '../utils/mediaApi';