export interface ListingPackage {
  id: number;
  name: string;
  code: string;
  package_type: string;
  audience_role: string;
  description?: string;
  features_json: string[];
  is_active: boolean;
  created_at?: string;
}

export interface PricingPlan {
  id: number;
  name: string;
  package: {
    id: number;
    name: string;
    code?: string;
    description?: string;
    features_json: string[];
  };
  billing_cycle: string;
  price: number;
  currency: string;
  discount_percent: number;
  duration_days: number;
  limits_json: Record<string, any>;
  is_default: boolean;
  is_recommended: boolean;
  is_active: boolean;
  created_at?: string;
}

export interface UserSubscription {
  id: number;
  plan: {
    id: number;
    name: string;
    package: {
      name: string;
    };
    price: number;
    currency: string;
    discount_percent: number;
  };
  start_date: string;
  end_date: string;
  status: string;
}

export interface ApiResponse<T> {
  success: boolean;
  data: T;
  message: string;
}
