export interface NegotiationEvent {
  id: string;
  event_type: 'NEGOTIATION_CREATED' | 'OFFER_SUBMITTED' | 'COUNTER_SUBMITTED' | 'OFFER_ACCEPTED' | 'OFFER_REJECTED' | 'OFFER_EXPIRED';
  offered_by: 'BUYER' | 'SELLER' | 'AGENT' | 'SYSTEM';
  amount?: number;
  message?: string;
  negotiation_status: 'INITIATED' | 'OFFER_SENT' | 'COUNTER_SENT' | 'ACCEPTED' | 'REJECTED' | 'EXPIRED';
  is_active: boolean;
  expires_at?: string;
  created_at: string;
}

export interface AIInsight {
  market_price: number;
  classification: 'LOWBALL' | 'FAIR' | 'AGGRESSIVE';
  suggested_range: {
    low: number;
    fair: number;
    high: number;
  };
}

export interface NegotiationTimeline {
  negotiation_id: string;
  status: string;
  events: NegotiationEvent[];
  ai_insight: AIInsight;
}

export interface CreateNegotiationRequest {
  property_id: number;
  seller_id: string;
  agent_id?: string;
}

export interface SubmitOfferRequest {
  amount: number;
  message?: string;
  expires_hours?: number;
}

export interface RejectOfferRequest {
  reason?: string;
}

export interface NegotiationResponse {
  negotiation_id: string;
  event_id: string;
  status: string;
  success: boolean;
  expires_at?: string;
  escrow_initiated?: boolean;
  existing?: boolean;
}

export type UserRole = 'BUYER' | 'SELLER' | 'AGENT';

export interface NegotiationState {
  timeline: NegotiationTimeline | null;
  loading: boolean;
  error: string | null;
}