// Re-export all types from API for convenience
export type {
    PropertyType,
    ListingType,
    PriceBreakdown,
    PredictionRequest,
    PredictionResponse,
    MarketInsightsResponse
} from '../api/pricePrediction';

// Additional component prop types
export interface PricePredictionFormProps {
    onPredictionComplete?: (result: PredictionResponse) => void;
    onError?: (error: string) => void;
}

export interface PSFForecastingProps {
    onError?: (error: string) => void;
}

export interface PricePredictionResultProps {
    result: PredictionResponse;
}

export interface PriceBreakdownProps {
    breakdown: PriceBreakdown;
}

// Import the types to make them available
import type { PredictionResponse, PriceBreakdown } from '../api/pricePrediction';